# دليل شامل - نظام نتائج الجامعة مع المعايرة

## 📚 الفهرس

1. [تسجيل الطلاب في المواد](#1-تسجيل-الطلاب-في-المواد)
2. [إدخال الدرجات الأصلية](#2-إدخال-الدرجات-الأصلية)
3. [عرض النتائج الأصلية](#3-عرض-النتائج-الأصلية)
4. [معايرة الدرجات](#4-معايرة-الدرجات)
5. [عرض النتائج المعايرة](#5-عرض-النتائج-المعايرة)

---

## 1. تسجيل الطلاب في المواد

### الطريقة الأولى: من صفحة إدخال الدرجات

1. اذهب إلى **"إدخال الدرجات (مبسط)"** (`enter_grades_simple.php`)
2. اختر الفصل الدراسي
3. اختر المادة
4. إذا لم تظهر قائمة الطلاب، ستجد رابط **"تسجيل طلاب في هذه المادة"**
5. اضغط على الرابط لتسجيل الطلاب

### الطريقة الثانية: من صفحة إدارة المواد

1. اذهب إلى **"إدارة المواد"** (`courses.php`)
2. اختر الفصل الدراسي
3. بجانب كل مادة، اضغط **"تسجيل طلاب"**
4. ستفتح صفحة تسجيل الطلاب

### في صفحة تسجيل الطلاب:

#### أ) التسجيل من ملف Excel/CSV (موصى به للعدد الكبير):

1. **جهز ملف Excel أو CSV** يحتوي على:
   - عمود واحد على الأقل من: `student_id`, `student_number`, `national_id`, أو `student_name`
   - مثال:
     ```csv
     student_number,student_name
     24001,هاشم جمال خالد محمد
     25005,ابوبكر محمد عبدالصادق
     ```

2. **ارفع الملف**:
   - اضغط على **"اختر ملف Excel أو CSV"**
   - اختر الملف
   - اضغط **"رفع الملف وتسجيل الطلاب"**

3. **النتيجة**:
   - سيتم تسجيل جميع الطلاب الموجودين في الملف
   - ستظهر رسالة بعدد الطلاب المسجلين

#### ب) التسجيل اليدوي:

1. **اختر الطلاب**:
   - حدد الطلاب من القائمة
   - يمكنك استخدام **"تحديد الكل"** أو **"إلغاء التحديد"**
   - سيظهر عدد الطلاب المحددين

2. **سجل الطلاب**:
   - اضغط **"تسجيل الطلاب المحددين"**
   - سيتم تسجيل جميع الطلاب المحددين

---

## 2. إدخال الدرجات الأصلية

### الخطوات:

1. **اذهب إلى صفحة إدخال الدرجات**:
   - من لوحة التحكم: **"إدخال الدرجات (مبسط)"**
   - أو افتح: `enter_grades_simple.php`

2. **اختر الفصل الدراسي**:
   - من القائمة المنسدلة
   - مثال: "فصل 1 - 2024-2025 (تقنية المعلومات)"

3. **اختر المادة**:
   - بعد اختيار الفصل، ستظهر قائمة بالمواد
   - اختر المادة المطلوبة

4. **أدخل الدرجات**:
   - ستظهر قائمة بجميع الطلاب المسجلين في المادة
   - أدخل الدرجة لكل طالب (من 0 إلى 100)
   - اضغط **"حفظ"** بجانب كل طالب
   - سيتم حساب التقدير الحرفي والنقاط تلقائياً

5. **التحقق**:
   - بعد الحفظ، ستظهر التقدير الحرفي (A, B+, B, C, D, F)
   - ستظهر النقاط (4.0, 3.5, 3.0, 2.0, 1.0, 0.0)
   - الحالة ستتحول من "⚠ لم يتم" إلى "✓ تم"

### نظام الدرجات:

| الدرجة | التقدير | النقاط |
|--------|---------|--------|
| 80 - 100 | A | 4.0 |
| 70 - 79 | B+ | 3.5 |
| 65 - 69 | B | 3.0 |
| 55 - 64 | C | 2.0 |
| 50 - 54 | D | 1.0 |
| أقل من 50 | F | 0.0 |

---

## 3. عرض النتائج الأصلية

### الخطوات:

1. **اذهب إلى صفحة النتائج**:
   - من لوحة التحكم: **"استخراج النتائج"**
   - أو افتح: `semester_results.php`

2. **اختر المعايير**:
   - **الكلية**: اختر الكلية
   - **التخصص**: اختر التخصص
   - **الفصل الدراسي**: اختر رقم الفصل
   - **السنة الدراسية**: اختر السنة

3. **عرض النتائج الأصلية**:
   - اضغط على **"النتائج الأصلية (قبل المعالجة)"**
   - ستظهر جميع الدرجات الأصلية للطلاب
   - ستظهر الدرجات الرقمية والتقديرات الحرفية
   - ستظهر المعدلات الفصلية

---

## 4. معايرة الدرجات

### الخطوات:

1. **من صفحة النتائج**:
   - بعد اختيار الفصل الدراسي
   - اضغط على **"النتائج بعد المعايرة (ثوراندويك)"**

2. **تعديل معاملات المعايرة** (اختياري):
   - **المتوسط المستهدف**: القيمة الافتراضية 70
   - **الانحراف المعياري المستهدف**: القيمة الافتراضية 12
   - اضغط **"تحديث المعايرة"** لتطبيق التغييرات

3. **حفظ الدرجات المعايرة**:
   - بعد التأكد من المعاملات المناسبة
   - اضغط **"💾 حفظ الدرجات المعايرة"**
   - سيتم حفظ جميع الدرجات المعايرة في قاعدة البيانات
   - ستظهر رسالة نجاح بعدد الدرجات المحفوظة

### معلومات المعايرة المحفوظة:

- **المتوسط المستهدف**: المتوسط المطلوب للدرجات بعد المعايرة
- **الانحراف المعياري المستهدف**: مدى انتشار الدرجات
- **المستخدم**: من قام بالمعايرة
- **التاريخ**: متى تمت المعايرة

---

## 5. عرض النتائج المعايرة

### الخطوات:

1. **من صفحة النتائج**:
   - اختر الفصل الدراسي
   - اضغط على **"النتائج بعد المعايرة (ثوراندويك)"**

2. **معلومات المعايرة**:
   - إذا كانت هناك معايرة محفوظة، ستظهر معلوماتها:
     - المتوسط المستهدف
     - الانحراف المعياري
     - من قام بالمعايرة
     - تاريخ المعايرة

3. **عرض الدرجات**:
   - ستظهر الدرجة المعايرة (بالأعلى)
   - التقدير الحرفي المعاير
   - مقارنة بالدرجة الأصلية: `[الأصلية → التغيير]`
   - اللون الأخضر: زيادة في الدرجة
   - اللون الأحمر: نقص في الدرجة

4. **إحصائيات المعايرة**:
   - ستظهر إحصائيات لكل مادة:
     - المتوسط الأصلي
     - الانحراف المعياري الأصلي
     - المتوسط بعد المعايرة
     - الانحراف المعياري بعد المعايرة

---

## 🔄 سير العمل الكامل

```
1. تسجيل الطلاب في المواد
   ↓
2. إدخال الدرجات الأصلية
   ↓
3. عرض النتائج الأصلية (للتحقق)
   ↓
4. معايرة الدرجات (اختياري)
   ↓
5. حفظ الدرجات المعايرة
   ↓
6. عرض النتائج المعايرة
```

---

## ⚠️ ملاحظات مهمة

1. **الترتيب مهم**:
   - يجب تسجيل الطلاب في المواد أولاً
   - ثم إدخال الدرجات الأصلية
   - ثم يمكن معايرة الدرجات

2. **الدرجات الأصلية مطلوبة**:
   - لا يمكن معايرة درجات غير موجودة
   - يجب إدخال جميع الدرجات الأصلية أولاً

3. **المعدلات التلقائية**:
   - بعد إدخال أو تعديل أي درجة، يتم تحديث المعدل الفصلي والتراكمي تلقائياً

4. **الصلاحيات**:
   - فقط المستخدمون المصرح لهم يمكنهم إدخال الدرجات
   - فقط المستخدمون المصرح لهم يمكنهم معايرة الدرجات

---

## 🔗 روابط سريعة

- **تسجيل الطلاب**: `register_students_to_course.php?course_id=X&semester_id=Y`
- **إدخال الدرجات**: `enter_grades_simple.php`
- **استخراج النتائج**: `semester_results.php`
- **إدارة المواد**: `courses.php`
- **إدارة الطلاب**: `students.php`

---

## 💡 نصائح

1. **استخدم إدخال الدرجات المبسط**: أسهل وأسرع
2. **استخدم ملفات Excel للعدد الكبير**: أسرع من الإدخال اليدوي
3. **احفظ المعايرة بعد التأكد**: يمكنك تعديل المعاملات قبل الحفظ
4. **راجع الإحصائيات**: تأكد من أن المعايرة منطقية قبل الحفظ

---

## 📞 المساعدة

إذا واجهت أي مشاكل:

1. **لا توجد درجات**: تأكد من إدخال الدرجات الأصلية أولاً
2. **لا يوجد طلاب**: تأكد من تسجيل الطلاب في المادة
3. **لا توجد مواد**: أضف المواد من صفحة إدارة المواد
4. **خطأ في المعايرة**: تحقق من وجود درجات أصلية كافية (3 طلاب على الأقل)

