# دليل تسجيل الطلاب من ملف Excel/CSV

## نظرة عامة

يمكنك تسجيل الطلاب في مادة معينة من خلال رفع ملف Excel أو CSV يحتوي على قائمة الطلاب.

## الخطوات

### 1. الوصول إلى صفحة التسجيل

1. اذهب إلى صفحة **المواد** (`courses.php`)
2. اختر **الفصل الدراسي** من القائمة
3. اضغط على زر **"تسجيل طلاب"** بجانب المادة المطلوبة

### 2. إعداد ملف Excel/CSV

#### تنسيق الملف المطلوب:

يجب أن يحتوي الملف على **عمود واحد على الأقل** من:

- **الرقم الجامعي** (يمكن استخدام أي من هذه الأسماء):
  - `student_number`
  - `رقم_جامعي`
  - `رقم جامعي`
  - `الرقم الجامعي`
  - `student_id`
  - `id`

- **اسم الطالب** (يمكن استخدام أي من هذه الأسماء):
  - `student_name`
  - `name`
  - `full_name`
  - `full_name_ar`
  - `اسم`
  - `الاسم`
  - `اسم الطالب`
  - `اسم_الطالب`

#### مثال ملف CSV:

```csv
الرقم الجامعي,اسم الطالب
2021001,أحمد محمد علي
2021002,فاطمة أحمد حسن
2021003,محمد خالد إبراهيم
```

#### مثال ملف Excel:

| الرقم الجامعي | اسم الطالب |
|--------------|-----------|
| 2021001 | أحمد محمد علي |
| 2021002 | فاطمة أحمد حسن |
| 2021003 | محمد خالد إبراهيم |

### 3. رفع الملف

1. في صفحة تسجيل الطلاب، ستجد قسم **"تسجيل الطلاب من ملف Excel/CSV"**
2. اضغط على **"اختر ملف"** واختر ملف Excel أو CSV
3. اضغط على **"رفع الملف وتسجيل الطلاب"**

### 4. النتائج

بعد رفع الملف، ستحصل على تقرير يوضح:

- ✅ عدد الطلاب الذين تم تسجيلهم بنجاح
- ⚠️ عدد الطلاب الذين كانوا مسجلين مسبقاً
- ⚠️ عدد الطلاب الذين لم يتم العثور عليهم (غير موجودين في التخصص أو غير نشطين)
- ❌ أي أخطاء حدثت

## ملاحظات مهمة

### متطلبات الملف:

- **الصيغ المدعومة**: CSV, Excel (.xlsx, .xls)
- **الحد الأقصى للحجم**: 10MB
- **الترميز**: يجب أن يكون الملف بترميز UTF-8 (خاصة للعربية)

### شروط التسجيل:

1. **الطالب يجب أن يكون موجوداً** في قاعدة البيانات
2. **الطالب يجب أن يكون في نفس التخصص** للمادة المختارة
3. **الطالب يجب أن يكون بحالة "نشط"** (active)
4. **إذا كنت مدير كلية**، يجب أن يكون الطالب في كليتك

### البحث عن الطلاب:

- النظام يبحث عن الطلاب أولاً بالرقم الجامعي
- إذا لم يُعثر عليه بالرقم، يبحث بالاسم
- يجب أن يكون الاسم مطابقاً تماماً كما هو في قاعدة البيانات

## حل المشاكل

### المشكلة: "لا توجد مكتبة لقراءة ملفات Excel"

**الحل**: استخدم ملف CSV بدلاً من Excel، أو قم بتثبيت مكتبة PhpSpreadsheet.

### المشكلة: "لم يتم العثور على طالب"

**الأسباب المحتملة**:
- الطالب غير موجود في قاعدة البيانات
- الطالب في تخصص مختلف
- الطالب غير نشط
- الاسم أو الرقم الجامعي غير مطابق

**الحل**:
1. تحقق من وجود الطالب في صفحة **إدارة الطلاب**
2. تأكد من أن الطالب في نفس التخصص
3. تأكد من أن الطالب بحالة "نشط"
4. تحقق من مطابقة الاسم أو الرقم الجامعي

### المشكلة: "حجم الملف كبير جداً"

**الحل**: قسّم الملف إلى ملفات أصغر (أقل من 10MB)

### المشكلة: "فشل قراءة الملف"

**الحل**:
1. تأكد من أن الملف بصيغة صحيحة (CSV أو Excel)
2. تأكد من أن الملف غير تالف
3. تحقق من وجود العناوين في الصف الأول
4. استخدم ملف CSV بسيط للتجربة

## تحميل ملف نموذجي

يمكنك تحميل ملف CSV نموذجي من صفحة التسجيل لاستخدامه كقالب.

## الدعم

إذا واجهت أي مشاكل، يرجى التواصل مع فريق الدعم التقني.

