# حل مشكلة الاتصال بقاعدة البيانات

## المشكلة
```
خطأ في الاتصال بقاعدة البيانات: SQLSTATE[HY000] [1045] Access denied for user 'root'@'localhost' (using password: NO)
```

## الحل السريع

### الخطوة 1: العثور على كلمة المرور الصحيحة

شغّل السكريبت التالي من المتصفح:
```
http://localhost/GUNS/find_mysql_password.php
```

أو من سطر الأوامر:
```bash
php find_mysql_password.php
```

هذا السكريبت سيجرب كلمات المرور الشائعة ويخبرك بالصحيحة.

### الخطوة 2: تحديث ملف الإعدادات

بعد معرفة كلمة المرور الصحيحة، افتح ملف:
```
config/database.php
```

وغيّر السطر 22 إلى:
```php
define('DB_PASS', 'root');  // أو '' إذا كانت فارغة
```

### الخطوة 3: التحقق من قاعدة البيانات

تأكد من وجود قاعدة البيانات `university_results`:

1. افتح phpMyAdmin: `http://localhost/phpmyadmin`
2. إذا لم تكن موجودة، استورد ملف `database/schema.sql`

## كلمات المرور الشائعة في AppServ

- `'root'` - الأكثر شيوعاً
- `''` (فارغة) - إذا تم التثبيت بدون كلمة مرور
- `'password'` - في بعض الإصدارات
- `'admin'` - في بعض الإصدارات

## التحقق من كلمة المرور يدوياً

### من AppServ Control Panel:
1. افتح AppServ Control Panel
2. ابحث عن إعدادات MySQL
3. تحقق من كلمة مرور root

### من phpMyAdmin:
1. افتح `http://localhost/phpmyadmin`
2. جرب تسجيل الدخول بكلمات مرور مختلفة
3. الكلمة التي تنجح هي الصحيحة

## إعادة تعيين كلمة مرور MySQL

إذا لم تنجح أي من الحلول أعلاه:

### الطريقة 1: من AppServ Control Panel
1. افتح AppServ Control Panel
2. ابحث عن خيار "Reset MySQL Password" أو "Change Password"
3. عيّن كلمة مرور جديدة (مثلاً: `root`)
4. حدّث `config/database.php` بالكلمة الجديدة

### الطريقة 2: من سطر الأوامر (متقدم)
```bash
# 1. أوقف MySQL من AppServ Control Panel

# 2. شغّل MySQL في وضع safe mode (في نافذة PowerShell جديدة)
cd C:\AppServ\MySQL\bin
mysqld --skip-grant-tables

# 3. في نافذة PowerShell أخرى
mysql -u root

# 4. في MySQL prompt
ALTER USER 'root'@'localhost' IDENTIFIED BY 'root';
FLUSH PRIVILEGES;
EXIT;

# 5. أوقف MySQL (Ctrl+C في النافذة الأولى)
# 6. أعد تشغيل MySQL من AppServ Control Panel
```

## اختبار الاتصال

بعد التحديث، اختبر الاتصال:

### اختبار شامل (موصى به):
```
http://localhost/GUNS/test_student_registration.php
```

### اختبار سريع:
```
http://localhost/GUNS/test_connection.php
```

## ملاحظات مهمة

1. **تأكد من تشغيل MySQL**: افتح AppServ Control Panel وتأكد من أن MySQL يعمل (Status: Running)

2. **تأكد من وجود قاعدة البيانات**: إذا كانت قاعدة البيانات غير موجودة، استورد `database/schema.sql` من phpMyAdmin

3. **الأمان**: بعد حل المشكلة، تأكد من تغيير كلمة مرور admin الافتراضية في النظام

## الملفات المساعدة

- `find_mysql_password.php` - للعثور على كلمة المرور الصحيحة
- `test_student_registration.php` - اختبار شامل للنظام
- `test_connection.php` - اختبار سريع للاتصال

## الدعم

إذا استمرت المشكلة:
1. تحقق من سجلات الأخطاء في `logs/php-error.log`
2. تأكد من إصدار PHP و MySQL المتوافق
3. جرب إعادة تشغيل AppServ

