# تثبيت مكتبة PhpSpreadsheet

مكتبة PhpSpreadsheet تُستخدم لقراءة وكتابة ملفات Excel (.xlsx, .xls) في نظام رفع الطلاب والدرجات.

## الطريقة 1: باستخدام Composer (مُوصى بها)

### 1. تثبيت Composer إن لم يكن مثبتاً

- حمّل Composer من: **https://getcomposer.org/download/**
- في Windows: شغّل الملف `Composer-Setup.exe` واتبع الخطوات (سيتم ربطه مع PHP الموجود في XAMPP).
- أو حمّل `composer.phar` وضعه في مجلد المشروع أو في `C:\xampp\php\`.

### 2. تثبيت PhpSpreadsheet

افتح **سطر الأوامر (CMD)** أو **PowerShell** ثم نفّذ:

```bash
cd c:\xampp\htdocs\alsharq
composer install
```

أو إذا كان Composer باسم الملف:

```bash
cd c:\xampp\htdocs\alsharq
php composer.phar install
```

أو إذا كان `composer.phar` داخل `C:\xampp\php\`:

```bash
cd c:\xampp\htdocs\alsharq
c:\xampp\php\php.exe c:\xampp\php\composer.phar install
```

### 3. تحميل الـ Autoload في PHP

بعد التثبيت ستجد مجلد `vendor` داخل المشروع. أضف في بداية أي ملف يقرأ Excel (أو في `config/config.php`) السطر التالي قبل استخدام PhpSpreadsheet:

```php
require_once __DIR__ . '/vendor/autoload.php';
```

ملاحظة: ملف `classes/ExcelReader.php` يتحقق تلقائياً من وجود الصنف `PhpOffice\PhpSpreadsheet\IOFactory`، لذا يكفي أن يتم تحميل الـ autoload في التطبيق (مثلاً من `config.php` أو من `students.php` و `upload_grades.php` قبل استدعاء ExcelReader).

---

## الطريقة 2: تحميل Composer محلياً ثم التثبيت

1. من **https://getcomposer.org/Composer-Setup.exe** ثبّت Composer عالمياً،  
   **أو** حمّل **composer.phar** من: https://getcomposer.org/download/

2. في مجلد المشروع نفّذ:
   - إذا Composer في PATH:
     ```bash
     cd c:\xampp\htdocs\alsharq
     composer install
     ```
   - إذا تستخدم composer.phar:
     ```bash
     cd c:\xampp\htdocs\alsharq
     php path\to\composer.phar install
     ```

3. بعد إنشاء مجلد `vendor` وملف `vendor/autoload.php`، تأكد من أن التطبيق يضمّن هذا الملف مرة واحدة (مثلاً من `config.php`).

---

## التحقق من التثبيت

بعد تنفيذ `composer install`:

- يجب أن يظهر مجلد **vendor** داخل `c:\xampp\htdocs\alsharq\`
- بداخله مجلد **phpoffice** ومجلد **autoload**

عند رفع ملف Excel من واجهة رفع الطلاب أو الدرجات، إذا كان التثبيت صحيحاً فسيتم قراءة الملف بدون رسالة "يرجى استخدام CSV أو تثبيت PhpSpreadsheet".
