# Guide for Publishing Results on Website
## دليل نشر النتائج على الموقع

For detailed Arabic guide, see: `دليل_نشر_النتائج.md`  
For quick summary, see: `ملخص_نشر_النتائج.md`

---

## Overview

The Results Publishing System allows students to search for their results on the website using only their student number. Results are available for a limited period (default: 7 days) and can be renewed or unpublished at any time.

---

## Quick Steps

### 1. Enter Grades (if not already entered)
```
Dashboard → Enter Grades → Select major/semester/course → Enter grades → Save
```

### 2. Publish Results
```
Dashboard → Publish Results → Select semester → Enter days (default: 7) → Publish
```

### 3. Test Publication
```
Open: http://localhost/GUNS/public_results.php
Enter student number → Search
```

---

## Files Structure

1. **`public_results.php`** - Public page for students to search their results
2. **`publish_results.php`** - Admin page to publish/unpublish results
3. **`published_results` table** - Database table storing publication information

---

## Database Setup

### Automatic Setup
The `published_results` table is created automatically when you first open `publish_results.php` or `public_results.php`. No manual setup needed.

### Manual Setup (if needed)

```sql
CREATE TABLE IF NOT EXISTS published_results (
    id INT PRIMARY KEY AUTO_INCREMENT,
    semester_id INT NOT NULL,
    published_by INT NOT NULL,
    published_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    expires_at TIMESTAMP NOT NULL,
    is_active BOOLEAN DEFAULT TRUE,
    FOREIGN KEY (semester_id) REFERENCES semesters(id) ON DELETE CASCADE,
    FOREIGN KEY (published_by) REFERENCES users(id) ON DELETE RESTRICT,
    UNIQUE KEY unique_semester_published (semester_id),
    INDEX idx_expires_at (expires_at),
    INDEX idx_is_active (is_active)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Add results_blocked column to students table
ALTER TABLE students 
ADD COLUMN IF NOT EXISTS results_blocked BOOLEAN DEFAULT FALSE AFTER status;
```

---

## Step-by-Step Guide

### Step 1: Enter Grades

Before publishing, ensure all grades are entered:

#### Simple Method:
1. Login as Admin/College Admin/Registrar
2. Go to **Dashboard**
3. Click **Enter Grades**
4. Select: Major → Semester → Course
5. Enter grades
6. Click **Save**

#### Advanced Method (Bulk Edit):
1. Dashboard → **Edit Student Grades by Major and Semester**
2. Select: College → Major → Semester Number → Academic Year
3. Edit all grades in one table
4. Click **Save All Edits**

### Step 2: Publish Results

1. **Login** as Admin/College Admin/Registrar
2. Go to **Dashboard**
3. Click **🌐 Publish Results on Website**
   Or directly: `publish_results.php`

4. Find the semester you want to publish
5. Check publication status:
   - ✅ **Published** → Results are available
   - ❌ **Not Published** → Ready to publish
   - ⏰ **Expired** → Time period ended

6. If **Not Published**:
   - Enter number of days (1-30, default: 7)
   - Click **Publish** button ✅

### Step 3: Test Publication

1. Open a new browser window (or incognito mode)
2. Go to: `http://localhost/GUNS/public_results.php`
3. Enter a **student number** that has grades in the published semester
4. Click **Search**
5. If results appear → ✅ Publication successful!

---

## Managing Published Results

### Unpublish Results
```
Publish Results → Find semester → Click Unpublish
```

### Renew Publication (after expiration)
```
Publish Results → Find expired semester → Enter new days → Publish
```

### Block Student Results
```
Publish Results → Manage Student Activity → Search student → Block Results
```

---

## Student Management

### Block Individual Student Results

1. In **Publish Results** page, go to **Manage Student Activity** section
2. Search by student number or full name
3. Click **Block Results**

**Result:** Student's results won't appear on public search page.

### Unblock Student Results
```
Search student → Click Unblock
```

### Suspend Student Activity
```
Search student → Click Suspend Activity
```

**Difference:**
- **Suspend Activity**: Stops student completely in system
- **Block Results**: Only hides results, student remains active

---

## Features

- ✅ Results available for limited period (default: 7 days)
- ✅ Automatic expiration after set period
- ✅ Manual unpublish option
- ✅ Comprehensive results display with semester GPA and letter grades
- ✅ Beautiful and user-friendly interface
- ✅ Print functionality
- ✅ Individual student blocking
- ✅ Student activity management

---

## Security

- Results only available for published semesters
- Results automatically expire after set period
- Admins can unpublish at any time
- Only active students can see results
- Blocked students cannot see their results
- Students need only student number to search (no login required)

---

## Important Notes

- Expired results are automatically disabled
- Same semester can be republished to renew period
- Grades can be modified after publishing without republishing
- Multiple semesters can be published simultaneously
- Only active students (status = 'active') can see results
- Students with blocked results (results_blocked = 1) cannot see results

---

## Troubleshooting

### Issue: Results not showing for student
**Solutions:**
- ✅ Check if semester is **published**
- ✅ Check if semester **hasn't expired**
- ✅ Check if student is **active** (status = active)
- ✅ Check if student results are **not blocked**

### Issue: Cannot publish
**Solutions:**
- ✅ Check if **grades are entered**
- ✅ Check your **permissions** (Admin/College Admin/Registrar)
- ✅ Verify semester exists in system

---

## Quick Reference

- **Publish Results:** `publish_results.php`
- **Search Results:** `public_results.php`
- **Dashboard:** `dashboard.php`

---

## Permissions Required

- **Publish Results:** Admin, College Admin, Registrar
- **Search Results:** Public (no login required)

---

**For detailed Arabic guide:** `دليل_نشر_النتائج.md`  
**For quick summary:** `ملخص_نشر_النتائج.md`

