# 🚀 دليل البدء السريع - نظام نتائج الجامعة

## خارطة الطريق الكاملة - خطوة بخطوة

---

## 📋 المرحلة الأولى: التثبيت والإعداد الأساسي

### الخطوة 1: إعداد قاعدة البيانات

#### الطريقة الأولى: من phpMyAdmin (الأسهل)

1. **افتح phpMyAdmin** من المتصفح:
   ```
   http://localhost/phpmyadmin
   ```

2. **أنشئ قاعدة بيانات جديدة**:
   - اضغط على "قاعدة بيانات جديدة" (New Database)
   - اكتب الاسم: `university_results`
   - اختر الترميز: `utf8mb4_unicode_ci`
   - اضغط "إنشاء" (Create)

3. **استورد ملف قاعدة البيانات**:
   - اختر قاعدة البيانات `university_results`
   - اضغط على تبويب "استيراد" (Import)
   - اضغط "اختر ملف" واختر: `database/schema.sql`
   - اضغط "تنفيذ" (Go)

#### الطريقة الثانية: من سطر الأوامر

```bash
mysql -u root -p < database/schema.sql
```

### الخطوة 2: إعداد الاتصال بقاعدة البيانات

1. **افتح الملف**: `config/database.php`

2. **عدّل البيانات التالية**:
   ```php
   define('DB_HOST', 'localhost');        // عنوان قاعدة البيانات
   define('DB_USER', 'root');              // اسم المستخدم
   define('DB_PASS', '');                  // كلمة المرور (اتركها فارغة إذا لم تكن موجودة)
   define('DB_NAME', 'university_results'); // اسم قاعدة البيانات
   ```

3. **احفظ الملف**

### الخطوة 3: إنشاء حساب المدير

1. **افتح المتصفح** وانتقل إلى:
   ```
   http://localhost/GUNS/create_admin.php
   ```

2. **ستظهر رسالة نجاح** إذا تم إنشاء الحساب بنجاح

3. **إذا لم يعمل**، افتح:
   ```
   http://localhost/GUNS/fix_admin_password.php
   ```

---

## 🔐 المرحلة الثانية: تسجيل الدخول الأول

### الخطوة 4: تسجيل الدخول

1. **افتح المتصفح** وانتقل إلى:
   ```
   http://localhost/GUNS
   ```
   أو
   ```
   http://localhost/GUNS/index.php
   ```

2. **أدخل بيانات الدخول**:
   - **اسم المستخدم**: `admin`
   - **كلمة المرور**: `admin123`

3. **اضغط "تسجيل الدخول"**

4. **⚠️ مهم جداً**: بعد تسجيل الدخول، غيّر كلمة المرور فوراً!

---

## 🏛️ المرحلة الثالثة: إعداد البيانات الأساسية

### الخطوة 5: إضافة كلية

1. من **لوحة التحكم** (Dashboard)، اضغط على **"إدارة الكليات"**

2. **أضف كلية جديدة**:
   - اضغط "إضافة كلية"
   - أدخل:
     - **اسم الكلية** (عربي): مثلاً "كلية الهندسة"
     - **اسم الكلية** (إنجليزي): مثلاً "College of Engineering"
     - **رمز الكلية**: مثلاً "ENG"
     - **سنة التوزيع على التخصصات**: (اختياري)
       - اختر "لا يوجد توزيع متأخر" إذا كان التوزيع من البداية
       - أو اختر السنة (الأولى، الثانية، الثالثة، الرابعة، الخامسة) إذا كان التوزيع يتم لاحقاً
   - اضغط "حفظ"

3. **كرر العملية** لإضافة كليات أخرى

### الخطوة 6: إضافة تخصص (Major)

1. من **لوحة التحكم**، اضغط على **"إدارة التخصصات"**

2. **أضف تخصص جديد**:
   - اختر **الكلية** من القائمة
   - أدخل:
     - **اسم التخصص** (عربي): مثلاً "هندسة الحاسوب"
     - **اسم التخصص** (إنجليزي): مثلاً "Computer Engineering"
     - **رمز التخصص**: مثلاً "CE"
     - **عدد الفصول**: مثلاً "8"
   - اضغط "حفظ"

3. **كرر العملية** لإضافة تخصصات أخرى

### الخطوة 7: إضافة فصل دراسي

1. من **لوحة التحكم**، اضغط على **"إدارة الفصول الدراسية"**

2. **أضف فصل دراسي جديد**:
   - اختر **الكلية** من القائمة
   - اختر **التخصص** من القائمة
   - أدخل:
     - **رقم الفصل**: مثلاً "1" (الفصل الأول)
     - **السنة الدراسية**: مثلاً "2024/2025"
     - **تاريخ البداية**: تاريخ بداية الفصل
     - **تاريخ النهاية**: تاريخ نهاية الفصل
   - اضغط "حفظ"

3. **كرر العملية** لإضافة فصول أخرى

### الخطوة 8: إضافة مادة (Course)

1. من **لوحة التحكم**، اضغط على **"إدارة المواد"**

2. **أضف مادة جديدة**:
   - اختر **الكلية** من القائمة
   - اختر **التخصص** من القائمة
   - اختر **الفصل الدراسي** من القائمة
   - أدخل:
     - **اسم المادة** (عربي): مثلاً "برمجة الحاسوب"
     - **اسم المادة** (إنجليزي): مثلاً "Computer Programming"
     - **رمز المادة**: مثلاً "CS101"
     - **عدد الساعات**: مثلاً "3"
   - اضغط "حفظ"

3. **كرر العملية** لإضافة مواد أخرى

---

## 👥 المرحلة الرابعة: إدارة الطلاب

### الخطوة 9: إضافة طالب

1. من **لوحة التحكم**، اضغط على **"إدارة الطلاب"**

2. **أضف طالب جديد**:
   - اضغط "إضافة طالب"
   - أدخل:
     - **الرقم الجامعي**: مثلاً "2021001"
     - **الاسم الكامل** (عربي): مثلاً "أحمد محمد علي"
     - **الاسم الكامل** (إنجليزي): مثلاً "Ahmed Mohammed Ali"
     - **تاريخ الميلاد**: تاريخ الميلاد
     - **الجنس**: ذكر أو أنثى
     - **البريد الإلكتروني**: البريد الإلكتروني
     - **رقم الهاتف**: رقم الهاتف
     - **الكلية**: اختر الكلية
     - **التخصص**: اختر التخصص
     - **تاريخ التسجيل**: تاريخ التسجيل
   - ✅ **إنشاء حساب تلقائي**: حدد هذا الخيار لإنشاء حساب للطالب
   - اضغط "حفظ"

3. **كرر العملية** لإضافة طلاب آخرين

### الخطوة 10: تسجيل الطلاب في المواد

#### الطريقة الأولى: من صفحة المادة

1. من **"إدارة المواد"**، اختر **الفصل الدراسي** من القائمة

2. **بجانب كل مادة**، اضغط على **"تسجيل طلاب"**

3. **اختر الطلاب** من القائمة:
   - حدد الطلاب الذين تريد تسجيلهم
   - اضغط "تسجيل الطلاب المحددين"

#### الطريقة الثانية: من ملف Excel/CSV

1. من صفحة **"تسجيل طلاب"**، ستجد قسم **"تسجيل الطلاب من ملف Excel/CSV"**

2. **أعد ملف Excel أو CSV** بالتنسيق التالي:
   ```csv
   الرقم الجامعي,اسم الطالب
   2021001,أحمد محمد علي
   2021002,فاطمة أحمد حسن
   ```

3. **ارفع الملف**:
   - اضغط "اختر ملف"
   - اختر الملف
   - اضغط "رفع الملف وتسجيل الطلاب"

---

## 📊 المرحلة الخامسة: إدخال الدرجات

### الخطوة 11: إدخال الدرجات

#### الطريقة الأولى: من صفحة المادة (مبسطة)

1. من **لوحة التحكم**، اضغط على **"إدخال الدرجات (مبسط)"**

2. **اختر الفصل الدراسي** من القائمة

3. **اختر المادة** من القائمة

4. **ستظهر قائمة الطلاب** المسجلين في المادة

5. **أدخل الدرجة** لكل طالب (من 0 إلى 100)

6. **اضغط "حفظ"** - سيتم حساب التقدير تلقائياً

#### الطريقة الثانية: من صفحة الدرجات

1. من **"إدارة المواد"**، اختر **الفصل الدراسي**

2. **بجانب كل مادة**، اضغط على **"الدرجات"**

3. **أدخل الدرجات** للطلاب

### الخطوة 12: التحقق من الدرجات

1. من **"إدارة الطلاب"**، اختر طالب

2. اضغط على **"الدرجات"** لعرض جميع درجاته

3. **ستظهر**:
   - الدرجات لكل مادة
   - التقدير (A, B+, B, C, D, F)
   - النقاط
   - المعدل الفصلي
   - المعدل التراكمي

---

## 💰 المرحلة السادسة: إدارة الرسوم

### الخطوة 13: إضافة رسوم للطالب

1. من **لوحة التحكم**، اضغط على **"إدارة الرسوم"**

2. **أضف رسوم جديدة**:
   - اختر **الطالب** من القائمة
   - اختر **الفصل الدراسي**
   - أدخل:
     - **نوع الرسوم**: مثلاً "رسوم دراسية"
     - **المبلغ**: المبلغ المطلوب
     - **تاريخ الاستحقاق**: تاريخ الاستحقاق
   - اضغط "حفظ"

### الخطوة 14: تسجيل الدفع

1. من صفحة **"إدارة الرسوم"**، ابحث عن الطالب

2. **بجانب كل رسوم**، اضغط "تسجيل دفع"

3. **أدخل**:
   - **تاريخ الدفع**
   - **طريقة الدفع**: نقدي، تحويل، إلخ
   - **رقم المرجع**: إذا كان موجوداً
   - **ملاحظات**
   - اضغط "حفظ"

---

## 📜 المرحلة السابعة: إصدار الشهادات

### الخطوة 15: طلب شهادة (للطالب)

1. **سجل دخول كطالب** (باستخدام حساب الطالب)

2. من **لوحة التحكم**، اضغط على **"طلب شهادة"**

3. **اختر نوع الشهادة**:
   - شهادة قيد
   - شهادة تفاصيل
   - شهادة تخرج
   - إلخ

4. **اضغط "تقديم الطلب"**

### الخطوة 16: الموافقة على الشهادة (للمسؤول)

1. **سجل دخول كمدير** أو **مدير كلية**

2. من **لوحة التحكم**، اضغط على **"طلبات الشهادات"**

3. **ستظهر جميع الطلبات**:
   - ✅ **مسدد**: الطالب دفع الرسوم
   - ❌ **غير مسدد**: الطالب لم يدفع الرسوم

4. **للموافقة**:
   - اضغط "موافقة" بجانب الطلب
   - سيتم إنشاء الشهادة تلقائياً

5. **لعرض الشهادة**:
   - اضغط "عرض" بجانب الشهادة

---

## 👤 المرحلة الثامنة: إدارة المستخدمين

### الخطوة 17: إضافة مستخدم جديد

1. من **لوحة التحكم**، اضغط على **"إدارة المستخدمين"**

2. **أضف مستخدم جديد**:
   - اضغط "إضافة مستخدم"
   - أدخل:
     - **اسم المستخدم**
     - **كلمة المرور**
     - **البريد الإلكتروني**
     - **الاسم الكامل**
     - **الدور** (Role):
       - `admin`: مدير عام
       - `college_admin`: مدير كلية
       - `registrar`: مسجل
       - `instructor`: أستاذ
       - `student`: طالب
     - **الكلية**: إذا كان المستخدم مرتبط بكلية
   - اضغط "حفظ"

### الخطوة 18: إدارة صلاحيات المستخدمين

- **المدير العام** (`admin`): يمكنه الوصول لكل شيء
- **مدير الكلية** (`college_admin`): يمكنه إدارة كليته فقط
- **المسجل** (`registrar`): يمكنه إضافة الطلاب وإدخال الدرجات
- **الأستاذ** (`instructor`): يمكنه إدخال الدرجات فقط
- **الطالب** (`student`): يمكنه عرض درجاته وطلب الشهادات

---

## ✅ قائمة التحقق النهائية

استخدم هذه القائمة للتأكد من أن كل شيء يعمل:

- [ ] قاعدة البيانات تم إنشاؤها واستيرادها
- [ ] بيانات الاتصال في `config/database.php` صحيحة
- [ ] حساب المدير تم إنشاؤه وتم تسجيل الدخول بنجاح
- [ ] تم إضافة كلية واحدة على الأقل
- [ ] تم إضافة تخصص واحد على الأقل
- [ ] تم إضافة فصل دراسي واحد على الأقل
- [ ] تم إضافة مادة واحدة على الأقل
- [ ] تم إضافة طالب واحد على الأقل
- [ ] تم تسجيل طالب واحد على الأقل في مادة
- [ ] تم إدخال درجة لطالب واحد على الأقل
- [ ] تم التحقق من حساب المعدل الفصلي والتراكمي

---

## 🆘 حل المشاكل الشائعة

### المشكلة: "خطأ في الاتصال بقاعدة البيانات"

**الحل**:
1. تحقق من أن MySQL يعمل
2. تحقق من بيانات الاتصال في `config/database.php`
3. تأكد من أن قاعدة البيانات موجودة

### المشكلة: "صفحة بيضاء"

**الحل**:
1. تحقق من سجلات الأخطاء في PHP
2. تأكد من أن PHP version 7.4 أو أحدث
3. تحقق من تفعيل PDO extension

### المشكلة: "لا يمكن رفع الملفات"

**الحل**:
1. تأكد من أن مجلدات `uploads/` و `certificates/` موجودة
2. تأكد من صلاحيات الكتابة على هذه المجلدات

### المشكلة: "لا تظهر الطلاب عند إدخال الدرجات"

**الحل**:
1. تأكد من تسجيل الطلاب في المادة أولاً
2. استخدم زر "تسجيل طلاب" بجانب المادة
3. تأكد من أن الطلاب بحالة "نشط"

---

## 📚 روابط مفيدة

- **دليل التثبيت الكامل**: `INSTALLATION.md`
- **دليل إدخال الدرجات**: `HOW_TO_ENTER_GRADES.md`
- **دليل تسجيل الطلاب من Excel**: `EXCEL_REGISTRATION_GUIDE.md`
- **نظرة عامة على النظام**: `SYSTEM_OVERVIEW.md`

---

## 🎯 الخطوات التالية بعد الإعداد

بعد إكمال جميع الخطوات الأساسية:

1. **أضف بيانات تجريبية** (اختياري):
   - افتح: `http://localhost/GUNS/load_sample_data.php`
   - سيتم تحميل بيانات تجريبية كاملة

2. **غيّر كلمة مرور المدير**:
   - من لوحة التحكم → إدارة المستخدمين
   - عدّل كلمة مرور المدير

3. **أضف مستخدمين جدد**:
   - أضف مدراء كليات
   - أضف مسجلين
   - أضف أساتذة

4. **ابدأ بإدخال البيانات الحقيقية**:
   - أضف الكليات والتخصصات
   - أضف الفصول والمواد
   - أضف الطلاب
   - سجل الطلاب في المواد
   - أدخل الدرجات

---

## 💡 نصائح مهمة

1. **احفظ نسخة احتياطية** من قاعدة البيانات بانتظام
2. **غيّر كلمة مرور المدير** فوراً بعد التثبيت
3. **استخدم بيانات تجريبية** للاختبار قبل إدخال البيانات الحقيقية
4. **تحقق من الصلاحيات** قبل إضافة المستخدمين
5. **راجع الدرجات** قبل إصدار الشهادات

---

**🎉 تهانينا! الآن النظام جاهز للاستخدام!**

إذا واجهت أي مشاكل، راجع قسم "حل المشاكل الشائعة" أعلاه.

