# دليل استخدام كود نتائج الملاحق وإزالة الرسوب

## نظرة عامة

تم إنشاء نظام متكامل لحساب نتائج امتحانات الملاحق وامتحانات إزالة الرسوب وفقاً للقواعد التالية:

### قواعد الملاحق:
- **الطالب الذي يرسب في أكثر من مادتين** من مواد الملاحق: **يعيد السنة الدراسية**
- **الطالب الذي يرسب في مادتين على الأكثر**: يكون لديه فرصة الجلوس لامتحان إزالة الرسوب

### قواعد إزالة الرسوب:
- **الطالب الذي يرسب في مادة واحدة** في امتحان إزالة الرسوب: **يعيد السنة الدراسية**
- **الطالب الذي لا يرسب** (أو يرسب في صفر مواد): **يستمر بشكل طبيعي**

## الملفات المُنشأة

### 1. الكلاسات (Classes)

#### `classes/SupplementaryResults.php`
كلاس لحساب نتائج امتحانات الملاحق

#### `classes/RemovalExamResults.php`
كلاس لحساب نتائج امتحانات إزالة الرسوب

### 2. الصفحات (Pages)

#### `supplementary_results_page.php`
صفحة ويب لعرض نتائج الملاحق مع واجهة مستخدم كاملة

#### `removal_exam_results_page.php`
صفحة ويب لعرض نتائج إزالة الرسوب مع واجهة مستخدم كاملة

### 3. ملفات الأمثلة

#### `example_usage_supplementary_removal.php`
أمثلة عملية على كيفية استخدام الكود

## طريقة الاستخدام

### الاستخدام البرمجي (Programmatic Usage)

#### مثال 1: حساب نتيجة الملاحق لطالب واحد

```php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/SupplementaryResults.php';

$db = Database::getInstance();
$supplementaryResults = new SupplementaryResults($db);

$student_id = 1;
$semester_id = 1;

$result = $supplementaryResults->calculateSupplementaryResult($student_id, $semester_id);

// $result يحتوي على:
// - 'status': 'repeat_year' | 'removal_exam' | 'pass'
// - 'failed_count': عدد المواد الراسبة
// - 'failed_courses': قائمة بالمواد الراسبة
// - 'arabic_status': الحالة بالعربية
// - 'message': رسالة توضيحية
```

#### مثال 2: حساب نتيجة إزالة الرسوب لطالب واحد

```php
require_once __DIR__ . '/classes/RemovalExamResults.php';

$removalExamResults = new RemovalExamResults($db);

$result = $removalExamResults->calculateRemovalExamResult($student_id, $semester_id);

// $result يحتوي على:
// - 'status': 'repeat_year' | 'pass'
// - 'failed_count': عدد المواد الراسبة
// - 'failed_courses': قائمة بالمواد الراسبة
// - 'arabic_status': الحالة بالعربية
// - 'message': رسالة توضيحية
```

#### مثال 3: حساب نتائج عدة طلاب دفعة واحدة

```php
$student_ids = [1, 2, 3, 4, 5];
$batch_results = $supplementaryResults->calculateBatchSupplementaryResults($student_ids, $semester_id);

foreach ($batch_results as $student_id => $result) {
    echo "الطالب $student_id: " . $result['arabic_status'] . "\n";
}
```

#### مثال 4: جلب تقرير شامل

```php
// تقرير الملاحق
$report = $supplementaryResults->getSupplementaryReport($semester_id, $college_id, $major_id);

// تقرير إزالة الرسوب
$report = $removalExamResults->getRemovalExamReport($semester_id, $college_id, $major_id);

// $report يحتوي على:
// - 'students': قائمة بجميع الطلاب ونتائجهم
// - 'summary': ملخص بالإحصائيات
```

### الاستخدام عبر الويب

1. **صفحة نتائج الملاحق**:
   - افتح: `supplementary_results_page.php`
   - اختر الكلية والتخصص والفصل الدراسي
   - اضغط "عرض النتائج"

2. **صفحة نتائج إزالة الرسوب**:
   - افتح: `removal_exam_results_page.php`
   - اختر الكلية والتخصص والفصل الدراسي
   - اضغط "عرض النتائج"

## الوظائف المتاحة

### SupplementaryResults Class

#### `calculateSupplementaryResult($student_id, $semester_id)`
حساب نتيجة الملاحق لطالب واحد

**المعاملات:**
- `$student_id`: معرف الطالب
- `$semester_id`: معرف الفصل الدراسي

**الإرجاع:** مصفوفة تحتوي على النتيجة والحالة

#### `calculateBatchSupplementaryResults($student_ids, $semester_id)`
حساب نتائج الملاحق لعدة طلاب دفعة واحدة

**المعاملات:**
- `$student_ids`: مصفوفة معرفات الطلاب
- `$semester_id`: معرف الفصل الدراسي

**الإرجاع:** مصفوفة مرتبطة بمعرفات الطلاب

#### `getSupplementaryReport($semester_id, $college_id = null, $major_id = null)`
جلب تقرير شامل لنتائج الملاحق

**المعاملات:**
- `$semester_id`: معرف الفصل الدراسي
- `$college_id`: معرف الكلية (اختياري)
- `$major_id`: معرف التخصص (اختياري)

**الإرجاع:** تقرير شامل بجميع النتائج والإحصائيات

### RemovalExamResults Class

#### `calculateRemovalExamResult($student_id, $semester_id)`
حساب نتيجة إزالة الرسوب لطالب واحد

**المعاملات:**
- `$student_id`: معرف الطالب
- `$semester_id`: معرف الفصل الدراسي

**الإرجاع:** مصفوفة تحتوي على النتيجة والحالة

#### `calculateBatchRemovalExamResults($student_ids, $semester_id)`
حساب نتائج إزالة الرسوب لعدة طلاب دفعة واحدة

#### `getRemovalExamReport($semester_id, $college_id = null, $major_id = null)`
جلب تقرير شامل لنتائج إزالة الرسوب

## الحالات الممكنة

### نتائج الملاحق:
- `repeat_year`: يعيد السنة الدراسية
- `removal_exam`: يسمح له بامتحان إزالة الرسوب
- `pass`: ناجح في جميع مواد الملاحق

### نتائج إزالة الرسوب:
- `repeat_year`: يعيد السنة الدراسية (راسب في مادة واحدة)
- `pass`: يستمر بشكل طبيعي

## ملاحظات مهمة

1. **تخزين الدرجات**: 
   - النظام الحالي يعتمد على جدول `grades` الموجود
   - يمكن تخصيص الكود إذا كان لديك جداول منفصلة للملاحق وإزالة الرسوب

2. **تحديد المواد الراسبة**:
   - الدرجة الرقمية أقل من 50 = راسبة
   - `F` أو `راسب` = راسبة
   - `غ` أو `غياب` أو `غش` = راسبة
   - `بد` (بديل) = لا تُحسب كراسبة

3. **الصلاحيات**:
   - الصفحات متاحة لـ: `admin`, `college_admin`, `registrar`
   - يمكن تعديل الصلاحيات في بداية كل ملف

## التخصيص

إذا كنت تريد تخصيص الكود:

1. **إضافة جداول منفصلة**: يمكن تعديل الدوال `getSupplementaryGrades()` و `getRemovalExamGrades()`

2. **تعديل القواعد**: يمكن تعديل المنطق في الدوال `calculateSupplementaryResult()` و `calculateRemovalExamResult()`

3. **إضافة حقول جديدة**: يمكن إضافة معلومات إضافية في المصفوفات المُرجعة

## الدعم

للمزيد من المعلومات أو المساعدة، راجع:
- ملف الأمثلة: `example_usage_supplementary_removal.php`
- الكود المصدري في مجلد `classes/`

