# دليل إعادة تعيين كلمة مرور MySQL في AppServ

## المشكلة
جميع كلمات المرور الشائعة فشلت في الاتصال بـ MySQL.

## الحل السريع (3 طرق)

### الطريقة 1: من AppServ Control Panel (الأسهل) ⭐

1. افتح **AppServ Control Panel**
2. ابحث عن خيار **"MySQL Password"** أو **"Reset Password"** أو **"Change Password"**
3. عيّن كلمة مرور جديدة: `root`
4. حدّث ملف `config/database.php`:
   ```php
   define('DB_PASS', 'root');
   ```
5. أعد تشغيل MySQL من AppServ Control Panel

---

### الطريقة 2: استخدام السكريبت التلقائي ⚡

1. افتح في المتصفح:
   ```
   http://localhost/GUNS/reset_mysql_password.php
   ```
2. اتبع التعليمات على الشاشة
3. أو شغّل ملف `reset_mysql_password.ps1` كمسؤول:
   - انقر بزر الماوس الأيمن على `reset_mysql_password.ps1`
   - اختر **"Run with PowerShell"** أو **"Run as Administrator"**

**ملاحظة:** إذا ظهرت رسالة خطأ في PowerShell، شغّل هذا الأمر أولاً:
```powershell
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned -Scope CurrentUser
```

---

### الطريقة 3: يدوياً من سطر الأوامر 🔧

#### الخطوة 1: إيقاف MySQL
- افتح **AppServ Control Panel**
- اضغط **Stop** على MySQL

#### الخطوة 2: تشغيل MySQL في وضع safe mode
افتح PowerShell كمسؤول واكتب:
```powershell
cd C:\AppServ\MySQL\bin
Start-Process -FilePath "mysqld.exe" -ArgumentList "--skip-grant-tables" -WindowStyle Hidden
```

#### الخطوة 3: إعادة تعيين كلمة المرور
في نافذة PowerShell جديدة (كمسؤول):
```powershell
cd C:\AppServ\MySQL\bin
mysql -u root
```

في MySQL prompt، اكتب:
```sql
ALTER USER 'root'@'localhost' IDENTIFIED BY 'root';
FLUSH PRIVILEGES;
EXIT;
```

#### الخطوة 4: إيقاف MySQL وإعادة تشغيله
- أوقف MySQL من AppServ Control Panel (أو أغلق نافذة PowerShell الأولى)
- أعد تشغيل MySQL من AppServ Control Panel

#### الخطوة 5: تحديث ملف الإعدادات
افتح `config/database.php` وحدّث:
```php
define('DB_PASS', 'root');
```

---

## التحقق من النجاح

بعد إعادة تعيين كلمة المرور:

1. **اختبر الاتصال:**
   ```
   http://localhost/GUNS/test_student_registration.php
   ```

2. **أو من phpMyAdmin:**
   ```
   http://localhost/phpmyadmin
   ```
   - اسم المستخدم: `root`
   - كلمة المرور: `root`

---

## إذا استمرت المشكلة

### 1. تحقق من أن MySQL يعمل
- افتح AppServ Control Panel
- تأكد من أن MySQL يعمل (Status: Running)

### 2. تحقق من المنفذ
- MySQL يستخدم المنفذ `3306` افتراضياً
- تأكد من عدم وجود برنامج آخر يستخدم هذا المنفذ

### 3. جرب كلمات مرور أخرى
إذا لم تنجح كلمة `root`، جرب:
- `''` (فارغة)
- `password`
- `123456`
- `admin`

### 4. إعادة تثبيت AppServ
كحل أخير، يمكنك إعادة تثبيت AppServ (لكن ستفقد جميع قواعد البيانات الموجودة)

---

## نصائح إضافية

- **احفظ كلمة المرور:** بعد إعادة التعيين، احفظ كلمة المرور في مكان آمن
- **الأمان:** في بيئة الإنتاج، استخدم كلمة مرور قوية
- **النسخ الاحتياطي:** قبل إعادة التعيين، احتفظ بنسخة احتياطية من قواعد البيانات المهمة

---

## الملفات المساعدة

- `reset_mysql_password.php` - واجهة ويب لإعادة التعيين
- `reset_mysql_password.ps1` - سكريبت PowerShell تلقائي
- `test_student_registration.php` - اختبار الاتصال بعد الإصلاح
- `find_mysql_password.php` - للبحث عن كلمة المرور

---

## الدعم

إذا واجهت أي مشاكل:
1. تحقق من سجلات MySQL في `C:\AppServ\MySQL\data\*.err`
2. تحقق من سجلات PHP في `logs/php-error.log`
3. تأكد من إصدار AppServ و MySQL المتوافق

