# نظرة عامة على النظام

## المكونات الرئيسية

### 1. قاعدة البيانات
- **15 جدول** تغطي جميع جوانب النظام
- دعم متعدد الكليات والتخصصات
- تتبع كامل للفصول والدرجات والرسوم

### 2. نظام المصادقة والأمان
- **5 أدوار مستخدمين**:
  - Admin: وصول كامل
  - College Admin: إدارة الكلية
  - Registrar: إدارة الطلاب والدرجات
  - Instructor: إدخال الدرجات
  - Student: عرض وطلب
- **عزل الكليات**: كل مستخدم لا يرى إلا كليته
- **حماية من SQL Injection** باستخدام Prepared Statements
- **تشفير كلمات المرور** باستخدام bcrypt

### 3. حساب المعدلات
- **المعدل الفصلي**: تلقائي لكل فصل
- **المعدل التراكمي**: تلقائي لجميع الفصول
- **صيغة الحساب**: (مجموع الساعات × النقاط) / مجموع الساعات

### 4. نظام الدرجات
- **A**: 80-100 → 4 نقاط
- **B+**: 70-79 → 3.5 نقاط
- **B**: 65-69 → 3 نقاط
- **C**: 55-64 → 2 نقاط
- **D**: 50-54 → 1 نقطة
- **F**: أقل من 50 → 0 نقاط

### 5. نظام الشهادات
- **5 أنواع شهادات**:
  - شهادة تفاصيل
  - شهادة جامعية
  - كشف درجات
  - شهادة قيد
  - شهادة تخرج
- **التحقق من الرسوم** قبل الإصدار
- **التقديم الإلكتروني** للطلاب

### 6. إدارة الرسوم
- تتبع الرسوم لكل فصل
- تسجيل المدفوعات
- التحقق التلقائي من السداد

## الصفحات الرئيسية

### للمدراء
- `colleges.php` - إدارة الكليات
- `majors.php` - إدارة التخصصات
- `semesters.php` - إدارة الفصول
- `courses.php` - إدارة المواد
- `students.php` - إدارة الطلاب
- `grades.php` - إدخال الدرجات
- `fees.php` - إدارة الرسوم
- `certificate_requests.php` - طلبات الشهادات

### للطلاب
- `student_grades.php` - عرض الدرجات
- `student_certificates.php` - طلب الشهادات
- `view_certificate.php` - عرض الشهادة

### مساعدة
- `register_courses.php` - تسجيل المواد
- `student_details.php` - تفاصيل الطالب

## الملفات الأساسية

### التكوين
- `config/config.php` - الإعدادات العامة
- `config/database.php` - اتصال قاعدة البيانات

### الفئات (Classes)
- `classes/Auth.php` - المصادقة والصلاحيات
- `classes/GradeCalculator.php` - حساب المعدلات
- `classes/CertificateGenerator.php` - إصدار الشهادات

### قاعدة البيانات
- `database/schema.sql` - هيكل قاعدة البيانات

## الميزات الأمنية

1. **عزل البيانات**: كل كلية لا ترى بيانات الكليات الأخرى
2. **الصلاحيات**: نظام صلاحيات دقيق لكل دور
3. **حماية SQL**: استخدام Prepared Statements
4. **حماية XSS**: تنظيف المدخلات
5. **جلسات آمنة**: timeout تلقائي
6. **حماية الملفات**: `.htaccess` يحمي الملفات الحساسة

## سير العمل

### إضافة طالب جديد
1. إضافة الطالب من `students.php`
2. يتم إنشاء حساب تلقائياً
3. تسجيل الطالب في المواد من `register_courses.php`
4. إدخال الدرجات من `grades.php`
5. يتم حساب المعدلات تلقائياً

### إصدار شهادة
1. الطالب يطلب شهادة من `student_certificates.php`
2. النظام يتحقق من سداد الرسوم
3. المسؤول يوافق من `certificate_requests.php`
4. يتم إنشاء الشهادة تلقائياً
5. الطالب يمكنه عرضها من `view_certificate.php`

## الدعم الفني

للمساعدة والدعم:
- راجع `README.md` للوثائق الكاملة
- راجع `INSTALLATION.md` لدليل التثبيت
- تحقق من سجلات الأخطاء في PHP

