<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || (!$auth->hasRole('admin') && !$auth->hasRole('college_admin'))) {
    header('Location: index.php');
    exit;
}

$db = Database::getInstance();
$message = '';

// فحص وإصلاح AUTO_INCREMENT إذا لزم الأمر
try {
    $zero_record = $db->fetchOne("SELECT id FROM colleges WHERE id = 0");
    if ($zero_record) {
        $db->query("DELETE FROM colleges WHERE id = 0");
    }
    
    $columns = $db->fetchAll("SHOW COLUMNS FROM colleges WHERE Field = 'id'");
    $has_auto_increment = false;
    if (!empty($columns)) {
        $has_auto_increment = (strpos($columns[0]['Extra'], 'auto_increment') !== false);
    }
    
    if (!$has_auto_increment) {
        $max_id_result = $db->fetchOne("SELECT MAX(id) as max_id FROM colleges WHERE id > 0");
        $max_id = $max_id_result['max_id'] ?? 0;
        $new_auto_increment = max($max_id + 1, 1);
        $db->getConnection()->exec("ALTER TABLE colleges MODIFY id INT(11) NOT NULL AUTO_INCREMENT");
        $db->getConnection()->exec("ALTER TABLE colleges AUTO_INCREMENT = " . (int)$new_auto_increment);
    }
} catch (PDOException $e) {
    error_log("Auto-increment check error: " . $e->getMessage());
}

// معالجة الإضافة
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add_bulk') {
    if (!$auth->hasRole('admin')) {
        $message = '<div class="alert alert-error">ليس لديك صلاحية لإضافة كليات</div>';
    } else {
        // جلب بيانات الكليات من النموذج
        $colleges_data = [];
        if (isset($_POST['colleges']) && is_array($_POST['colleges'])) {
            foreach ($_POST['colleges'] as $college) {
                if (!empty($college['name_ar']) && !empty($college['code'])) {
                    $colleges_data[] = [
                        'name_ar' => trim($college['name_ar']),
                        'name_en' => trim($college['name_en'] ?? ''),
                        'code' => trim($college['code']),
                        'specialization_year' => !empty($college['specialization_year']) ? (int)$college['specialization_year'] : null,
                    ];
                }
            }
        }
        
        if (!empty($colleges_data)) {
            try {
                $db->getConnection()->beginTransaction();
                
                $success_count = 0;
                $error_count = 0;
                $duplicate_count = 0;
                $errors = [];
                
                foreach ($colleges_data as $index => $college_data) {
                    try {
                        // التحقق من عدم وجود كلية بنفس الرمز
                        $existing = $db->fetchOne(
                            "SELECT * FROM colleges WHERE code = ?",
                            [$college_data['code']]
                        );
                        
                        if ($existing) {
                            $duplicate_count++;
                            continue;
                        }
                        
                        // التأكد من عدم وجود سجل ب id=0
                        $zero_record = $db->fetchOne("SELECT id FROM colleges WHERE id = 0");
                        if ($zero_record) {
                            $db->query("DELETE FROM colleges WHERE id = 0");
                        }
                        
                        // إضافة الكلية
                        $db->query(
                            "INSERT INTO colleges (name_ar, name_en, code, specialization_year) 
                             VALUES (?, ?, ?, ?)",
                            [
                                $college_data['name_ar'], 
                                $college_data['name_en'], 
                                $college_data['code'], 
                                $college_data['specialization_year']
                            ]
                        );
                        
                        // الحصول على ID المولّد تلقائياً
                        $college_id = $db->getConnection()->lastInsertId();
                        
                        // إذا كان ID = 0، إصلاح المشكلة
                        if ($college_id == 0 || $college_id === false || $college_id === '0') {
                            $db->query("DELETE FROM colleges WHERE id = 0");
                            $max_id_result = $db->fetchOne("SELECT MAX(id) as max_id FROM colleges WHERE id > 0");
                            $max_id = $max_id_result['max_id'] ?? 0;
                            $new_auto_increment = max($max_id + 1, 1);
                            $db->getConnection()->exec("ALTER TABLE colleges MODIFY id INT(11) NOT NULL AUTO_INCREMENT");
                            $db->getConnection()->exec("ALTER TABLE colleges AUTO_INCREMENT = " . (int)$new_auto_increment);
                            
                            $db->query(
                                "INSERT INTO colleges (name_ar, name_en, code, specialization_year) 
                                 VALUES (?, ?, ?, ?)",
                                [
                                    $college_data['name_ar'], 
                                    $college_data['name_en'], 
                                    $college_data['code'], 
                                    $college_data['specialization_year']
                                ]
                            );
                            $college_id = $db->getConnection()->lastInsertId();
                        }
                        
                        $success_count++;
                    } catch (PDOException $e) {
                        $error_count++;
                        $error_msg = $e->getMessage();
                        if (strpos($error_msg, 'Duplicate entry') !== false || strpos($error_msg, '1062') !== false) {
                            $duplicate_count++;
                        } else {
                            $errors[] = "الكلية " . $college_data['code'] . ": " . $error_msg;
                        }
                    }
                }
                
                $db->getConnection()->commit();
                
                // بناء رسالة النتيجة
                if ($success_count > 0) {
                    $message = '<div class="alert alert-success">✓ تم إضافة ' . $success_count . ' كلية بنجاح</div>';
                }
                if ($duplicate_count > 0) {
                    $message .= '<div class="alert alert-info">⚠ ' . $duplicate_count . ' كلية موجودة مسبقاً (تم تخطيها)</div>';
                }
                if ($error_count > 0) {
                    $message .= '<div class="alert alert-warning">⚠ ' . $error_count . ' خطأ في الإضافة</div>';
                    if (count($errors) > 0 && count($errors) <= 10) {
                        $message .= '<div class="alert alert-info" style="margin-top:10px;"><small>' . implode('<br>', array_map('htmlspecialchars', $errors)) . '</small></div>';
                    }
                }
            } catch (Exception $e) {
                $db->getConnection()->rollBack();
                $message = '<div class="alert alert-error">خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
            }
        } else {
            $message = '<div class="alert alert-error">يرجى ملء جميع الحقول المطلوبة</div>';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إضافة كليات - دفعة واحدة</title>
    <?php include __DIR__ . '/includes/compatibility.php'; ?>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px 0;
        }
        
        .main-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        .page-header {
            background: white;
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        
        .page-header h1 {
            color: #667eea;
            margin: 0 0 10px 0;
            font-size: 32px;
            font-weight: 700;
        }
        
        .page-header p {
            color: #666;
            margin: 0;
            font-size: 16px;
        }
        
        .form-card {
            background: white;
            border-radius: 15px;
            padding: 35px;
            margin-bottom: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        
        .colleges-table-container {
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            overflow-x: auto;
        }
        
        .table-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        
        .table-header h3 {
            color: #667eea;
            margin: 0;
            font-size: 22px;
        }
        
        .btn {
            padding: 12px 25px;
            border: none;
            border-radius: 8px;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-block;
        }
        
        .btn-success {
            background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
            color: white;
        }
        
        .btn-success:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(17, 153, 142, 0.4);
        }
        
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        
        .btn-secondary:hover {
            background: #5a6268;
        }
        
        .btn-add-row {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            color: white;
            padding: 10px 20px;
            font-size: 14px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        
        table thead {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        table th {
            padding: 15px;
            text-align: right;
            font-weight: 600;
            font-size: 14px;
        }
        
        table td {
            padding: 12px 15px;
            border-bottom: 1px solid #f0f0f0;
        }
        
        table tbody tr {
            transition: background 0.2s ease;
        }
        
        table tbody tr:hover {
            background: #f8f9ff;
        }
        
        table input, table select {
            width: 100%;
            padding: 8px 12px;
            border: 1px solid #e0e0e0;
            border-radius: 6px;
            font-size: 14px;
            background: white;
        }
        
        table input:focus, table select:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 2px rgba(102, 126, 234, 0.1);
        }
        
        .btn-remove {
            background: #dc3545;
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 13px;
        }
        
        .btn-remove:hover {
            background: #c82333;
        }
        
        .alert {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            font-size: 15px;
        }
        
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        
        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        
        .alert-info {
            background: #d1ecf1;
            color: #0c5460;
            border: 1px solid #bee5eb;
        }
        
        .alert-warning {
            background: #fff3cd;
            color: #856404;
            border: 1px solid #ffeaa7;
        }
        
        .info-box {
            background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%);
            border-right: 4px solid #667eea;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 25px;
        }
        
        .info-box p {
            margin: 5px 0;
            color: #555;
        }
        
        .info-box strong {
            color: #667eea;
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="main-container">
        <div class="page-header">
            <h1>🏛️ إضافة كليات - دفعة واحدة</h1>
            <p>أضف عدة كليات دفعة واحدة بسهولة وسرعة</p>
        </div>
        
        <?php echo $message; ?>
        
        <?php if (!$auth->hasRole('admin')): ?>
            <div class="alert alert-error">ليس لديك صلاحية للوصول إلى هذه الصفحة</div>
        <?php else: ?>
        <form method="POST" id="addCollegesForm">
            <input type="hidden" name="action" value="add_bulk">
            
            <div class="colleges-table-container">
                <div class="table-header">
                    <h3>📋 بيانات الكليات</h3>
                    <button type="button" class="btn btn-add-row" onclick="addCollegeRow()">
                        ➕ إضافة صف جديد
                    </button>
                </div>
                
                <div class="info-box">
                    <p><strong>💡 ملاحظات:</strong></p>
                    <p>• الحقول المطلوبة: اسم الكلية (عربي) ورمز الكلية</p>
                    <p>• يمكنك إضافة عدة صفوف وإزالة أي صف غير مطلوب</p>
                    <p>• الكليات المكررة (بنفس الرمز) سيتم تخطيها تلقائياً</p>
                </div>
                
                <table id="collegesTable">
                    <thead>
                        <tr>
                            <th style="width: 80px;">#</th>
                            <th>اسم الكلية (عربي) *</th>
                            <th>اسم الكلية (إنجليزي)</th>
                            <th>رمز الكلية *</th>
                            <th>سنة التوزيع على التخصصات</th>
                            <th style="width: 100px;">إجراءات</th>
                        </tr>
                    </thead>
                    <tbody id="collegesTableBody">
                        <tr>
                            <td>1</td>
                            <td><input type="text" name="colleges[0][name_ar]" required></td>
                            <td><input type="text" name="colleges[0][name_en]"></td>
                            <td><input type="text" name="colleges[0][code]" required></td>
                            <td>
                                <select name="colleges[0][specialization_year]">
                                    <option value="">من البداية</option>
                                    <option value="1">السنة الأولى</option>
                                    <option value="2">السنة الثانية</option>
                                    <option value="3">السنة الثالثة</option>
                                    <option value="4">السنة الرابعة</option>
                                    <option value="5">السنة الخامسة</option>
                                </select>
                            </td>
                            <td><button type="button" class="btn-remove" onclick="removeRow(this)" disabled>🗑️</button></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            
            <div class="form-card" style="text-align: center; margin-top: 30px;">
                <button type="submit" class="btn btn-success" style="padding: 15px 40px; font-size: 18px;">
                    ✅ حفظ جميع الكليات
                </button>
                <a href="colleges.php" class="btn btn-secondary" style="margin-right: 15px;">
                    🔙 العودة
                </a>
            </div>
        </form>
        <?php endif; ?>
    </div>
    
    <script>
        let rowCount = 1;
        
        function addCollegeRow() {
            const tbody = document.getElementById('collegesTableBody');
            const row = document.createElement('tr');
            row.innerHTML = `
                <td>${rowCount + 1}</td>
                <td><input type="text" name="colleges[${rowCount}][name_ar]" required></td>
                <td><input type="text" name="colleges[${rowCount}][name_en]"></td>
                <td><input type="text" name="colleges[${rowCount}][code]" required></td>
                <td>
                    <select name="colleges[${rowCount}][specialization_year]">
                        <option value="">من البداية</option>
                        <option value="1">السنة الأولى</option>
                        <option value="2">السنة الثانية</option>
                        <option value="3">السنة الثالثة</option>
                        <option value="4">السنة الرابعة</option>
                        <option value="5">السنة الخامسة</option>
                    </select>
                </td>
                <td><button type="button" class="btn-remove" onclick="removeRow(this)">🗑️</button></td>
            `;
            tbody.appendChild(row);
            rowCount++;
            updateRowNumbers();
        }
        
        function removeRow(button) {
            const row = button.closest('tr');
            const tbody = document.getElementById('collegesTableBody');
            if (tbody.children.length > 1) {
                row.remove();
                updateRowNumbers();
            }
        }
        
        function updateRowNumbers() {
            const rows = document.querySelectorAll('#collegesTableBody tr');
            rows.forEach((row, index) => {
                row.querySelector('td:first-child').textContent = index + 1;
                if (rows.length === 1) {
                    row.querySelector('.btn-remove').disabled = true;
                } else {
                    row.querySelector('.btn-remove').disabled = false;
                }
            });
        }
    </script>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>
