<?php
/**
 * إدخال بيانات تجريبية كاملة للشهادات
 * Add Complete Test Data for Certificates
 */

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';
require_once __DIR__ . '/classes/GradeCalculator.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || (!$auth->hasRole('admin') && !$auth->hasRole('college_admin'))) {
    die('ليس لديك صلاحية للوصول إلى هذه الصفحة');
}

$db = Database::getInstance();
$gradeCalculator = new GradeCalculator();
$message = '';

// البحث عن تخصص تقنية المعلومات
$it_major = $db->fetchOne(
    "SELECT * FROM majors WHERE name_ar LIKE '%تقنية المعلومات%' OR name_ar LIKE '%تكنولوجيا المعلومات%' OR name_en LIKE '%Information Technology%' OR name_en LIKE '%IT%' LIMIT 1"
);

if (!$it_major) {
    $message = '<div class="alert alert-error">✗ يجب إنشاء تخصص تقنية المعلومات أولاً من <a href="add_test_semesters_it.php">هنا</a></div>';
}

// معالجة إدخال البيانات
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add_test_data' && $it_major) {
    try {
        $db->getConnection()->beginTransaction();
        
        // 1. إدخال طلاب تجريبيين
        $students_data = [
            ['student_number' => '24001', 'full_name_ar' => 'هاشم جمال خالد محمد', 'national_id' => '123456789001'],
            ['student_number' => '24002', 'full_name_ar' => 'أحمد محمد علي', 'national_id' => '123456789002'],
            ['student_number' => '24003', 'full_name_ar' => 'فاطمة أحمد حسن', 'national_id' => '123456789003'],
            ['student_number' => '24004', 'full_name_ar' => 'محمد خالد إبراهيم', 'national_id' => '123456789004'],
            ['student_number' => '24005', 'full_name_ar' => 'سارة علي محمود', 'national_id' => '123456789005'],
        ];
        
        $students_added = 0;
        $student_ids = [];
        
        foreach ($students_data as $student_data) {
            // التحقق من وجود الطالب
            $existing = $db->fetchOne(
                "SELECT * FROM students WHERE student_number = ?",
                [$student_data['student_number']]
            );
            
            if ($existing) {
                $student_ids[] = $existing['id'];
                continue;
            }
            
            // إضافة الطالب
            $db->query(
                "INSERT INTO students (college_id, major_id, student_number, national_id, full_name_ar, enrollment_date, status)
                 VALUES (?, ?, ?, ?, ?, CURDATE(), 'active')",
                [
                    $it_major['college_id'],
                    $it_major['id'],
                    $student_data['student_number'],
                    $student_data['national_id'],
                    $student_data['full_name_ar']
                ]
            );
            
            $student_id = $db->getConnection()->lastInsertId();
            $student_ids[] = $student_id;
            $students_added++;
        }
        
        // 2. جلب الفصول الدراسية
        $semesters = $db->fetchAll(
            "SELECT * FROM semesters WHERE major_id = ? ORDER BY academic_year, semester_number",
            [$it_major['id']]
        );
        
        if (empty($semesters)) {
            throw new Exception('لا توجد فصول دراسية. يجب إضافة الفصول أولاً.');
        }
        
        // 3. إدخال مواد لكل فصل
        $courses_data = [
            // الفصل الأول
            ['code' => 'CS101', 'name_ar' => 'مقدمة في علوم الحاسوب', 'credit_hours' => 3],
            ['code' => 'MATH101', 'name_ar' => 'رياضيات 1', 'credit_hours' => 3],
            ['code' => 'ENG101', 'name_ar' => 'لغة إنجليزية 1', 'credit_hours' => 2],
            ['code' => 'PHYS101', 'name_ar' => 'فيزياء عامة', 'credit_hours' => 3],
            
            // الفصل الثاني
            ['code' => 'CS102', 'name_ar' => 'برمجة 1', 'credit_hours' => 3],
            ['code' => 'MATH102', 'name_ar' => 'رياضيات 2', 'credit_hours' => 3],
            ['code' => 'ENG102', 'name_ar' => 'لغة إنجليزية 2', 'credit_hours' => 2],
            ['code' => 'STAT101', 'name_ar' => 'إحصاء', 'credit_hours' => 2],
            
            // الفصل الثالث
            ['code' => 'CS201', 'name_ar' => 'هياكل البيانات', 'credit_hours' => 3],
            ['code' => 'CS202', 'name_ar' => 'قواعد البيانات', 'credit_hours' => 3],
            ['code' => 'MATH201', 'name_ar' => 'جبر خطي', 'credit_hours' => 3],
            ['code' => 'CS203', 'name_ar' => 'شبكات الحاسوب', 'credit_hours' => 3],
            
            // الفصل الرابع
            ['code' => 'CS204', 'name_ar' => 'أنظمة التشغيل', 'credit_hours' => 3],
            ['code' => 'CS205', 'name_ar' => 'هندسة البرمجيات', 'credit_hours' => 3],
            ['code' => 'CS206', 'name_ar' => 'الذكاء الاصطناعي', 'credit_hours' => 3],
            ['code' => 'CS207', 'name_ar' => 'أمن المعلومات', 'credit_hours' => 2],
            
            // الفصل الخامس
            ['code' => 'CS301', 'name_ar' => 'تطوير الويب', 'credit_hours' => 3],
            ['code' => 'CS302', 'name_ar' => 'البرمجة الشيئية', 'credit_hours' => 3],
            ['code' => 'CS303', 'name_ar' => 'الخوارزميات', 'credit_hours' => 3],
            ['code' => 'CS304', 'name_ar' => 'الرسوميات الحاسوبية', 'credit_hours' => 2],
            
            // الفصل السادس
            ['code' => 'CS305', 'name_ar' => 'إدارة المشاريع', 'credit_hours' => 2],
            ['code' => 'CS306', 'name_ar' => 'التعلم الآلي', 'credit_hours' => 3],
            ['code' => 'CS307', 'name_ar' => 'الحوسبة السحابية', 'credit_hours' => 3],
            ['code' => 'CS308', 'name_ar' => 'تطبيقات الهاتف', 'credit_hours' => 3],
            
            // الفصل السابع
            ['code' => 'CS401', 'name_ar' => 'مشروع التخرج 1', 'credit_hours' => 3],
            ['code' => 'CS402', 'name_ar' => 'أخلاقيات الحاسوب', 'credit_hours' => 2],
            ['code' => 'CS403', 'name_ar' => 'التدريب الميداني', 'credit_hours' => 3],
            ['code' => 'CS404', 'name_ar' => 'موضوعات متقدمة', 'credit_hours' => 3],
            
            // الفصل الثامن
            ['code' => 'CS405', 'name_ar' => 'مشروع التخرج 2', 'credit_hours' => 3],
            ['code' => 'CS406', 'name_ar' => 'إدارة نظم المعلومات', 'credit_hours' => 3],
            ['code' => 'CS407', 'name_ar' => 'الأنظمة الموزعة', 'credit_hours' => 3],
            ['code' => 'CS408', 'name_ar' => 'التحليل والتصميم', 'credit_hours' => 2],
        ];
        
        $courses_added = 0;
        $course_ids_by_semester = [];
        
        // توزيع المواد على الفصول (4 مواد لكل فصل)
        foreach ($semesters as $semester_index => $semester) {
            $course_ids_by_semester[$semester['id']] = [];
            $courses_start_index = $semester_index * 4;
            
            for ($i = 0; $i < 4 && isset($courses_data[$courses_start_index + $i]); $i++) {
                $course_data = $courses_data[$courses_start_index + $i];
                
                // التحقق من وجود المادة
                $existing = $db->fetchOne(
                    "SELECT * FROM courses WHERE code = ? AND major_id = ?",
                    [$course_data['code'], $it_major['id']]
                );
                
                if ($existing) {
                    $course_ids_by_semester[$semester['id']][] = $existing['id'];
                    continue;
                }
                
                // إضافة المادة
                $db->query(
                    "INSERT INTO courses (major_id, semester_id, code, name_ar, credit_hours, is_required)
                     VALUES (?, ?, ?, ?, ?, 1)",
                    [
                        $it_major['id'],
                        $semester['id'],
                        $course_data['code'],
                        $course_data['name_ar'],
                        $course_data['credit_hours']
                    ]
                );
                
                $course_id = $db->getConnection()->lastInsertId();
                $course_ids_by_semester[$semester['id']][] = $course_id;
                $courses_added++;
            }
        }
        
        // 4. تسجيل الطلاب في المواد
        $registrations_added = 0;
        foreach ($student_ids as $student_id) {
            foreach ($semesters as $semester) {
                if (!isset($course_ids_by_semester[$semester['id']])) {
                    continue;
                }
                
                foreach ($course_ids_by_semester[$semester['id']] as $course_id) {
                    // التحقق من التسجيل المسبق
                    $existing = $db->fetchOne(
                        "SELECT * FROM student_courses 
                         WHERE student_id = ? AND course_id = ? AND semester_id = ?",
                        [$student_id, $course_id, $semester['id']]
                    );
                    
                    if ($existing) {
                        continue;
                    }
                    
                    // تسجيل الطالب في المادة
                    $db->query(
                        "INSERT INTO student_courses (student_id, course_id, semester_id, registration_date)
                         VALUES (?, ?, ?, CURDATE())",
                        [$student_id, $course_id, $semester['id']]
                    );
                    
                    $registrations_added++;
                }
            }
        }
        
        // 5. إدخال درجات للطلاب
        $grades_added = 0;
        foreach ($student_ids as $student_index => $student_id) {
            foreach ($semesters as $semester_index => $semester) {
                if (!isset($course_ids_by_semester[$semester['id']])) {
                    continue;
                }
                
                foreach ($course_ids_by_semester[$semester['id']] as $course_index => $course_id) {
                    // الحصول على تسجيل الطالب في المادة
                    $student_course = $db->fetchOne(
                        "SELECT * FROM student_courses 
                         WHERE student_id = ? AND course_id = ? AND semester_id = ?",
                        [$student_id, $course_id, $semester['id']]
                    );
                    
                    if (!$student_course) {
                        continue;
                    }
                    
                    // التحقق من وجود درجة
                    $existing_grade = $db->fetchOne(
                        "SELECT * FROM grades WHERE student_course_id = ?",
                        [$student_course['id']]
                    );
                    
                    if ($existing_grade) {
                        continue;
                    }
                    
                    // إنشاء درجات متنوعة (من 60 إلى 95)
                    // الطالب الأول (24001) يحصل على درجات عالية
                    // الطلاب الآخرون يحصلون على درجات متنوعة
                    $base_marks = 75;
                    if ($student_index == 0) {
                        // الطالب الأول: درجات عالية (85-95)
                        $marks = 85 + ($course_index * 2) + ($semester_index * 1);
                        $marks = min(95, $marks);
                    } else {
                        // الطلاب الآخرون: درجات متنوعة (60-85)
                        $marks = 60 + ($student_index * 3) + ($course_index * 2) + ($semester_index * 1);
                        $marks = min(85, $marks);
                    }
                    
                    // معالجة الدرجة
                    $grade_info = $gradeCalculator->calculatePoints($marks);
                    
                    // إدخال الدرجة
                    $db->query(
                        "INSERT INTO grades (student_course_id, student_id, course_id, semester_id, marks, letter_grade, points, entered_by)
                         VALUES (?, ?, ?, ?, ?, ?, ?, ?)",
                        [
                            $student_course['id'],
                            $student_id,
                            $course_id,
                            $semester['id'],
                            $marks,
                            $grade_info['letter'],
                            $grade_info['points'],
                            $_SESSION['user_id'] ?? 1
                        ]
                    );
                    
                    $grades_added++;
                }
            }
        }
        
        // 6. تحديث المعدلات
        $gpas_updated = 0;
        foreach ($student_ids as $student_id) {
            foreach ($semesters as $semester) {
                $result = $gradeCalculator->calculateSemesterGPA($student_id, $semester['id']);
                if ($result) {
                    $gpas_updated++;
                }
            }
            // تحديث المعدل التراكمي
            $gradeCalculator->calculateCumulativeGPA($student_id);
        }
        
        $db->getConnection()->commit();
        
        $message = '<div class="alert alert-success">✓ تم إدخال البيانات بنجاح:<br>';
        $message .= '- تم إضافة ' . $students_added . ' طالب جديد<br>';
        $message .= '- تم إضافة ' . $courses_added . ' مادة جديدة<br>';
        $message .= '- تم تسجيل ' . $registrations_added . ' تسجيل في المواد<br>';
        $message .= '- تم إدخال ' . $grades_added . ' درجة<br>';
        $message .= '- تم تحديث ' . $gpas_updated . ' معدل فصلي<br>';
        $message .= '</div>';
        
    } catch (Exception $e) {
        $db->getConnection()->rollBack();
        $message = '<div class="alert alert-error">✗ خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
        error_log("Error adding test data: " . $e->getMessage());
    }
}

// جلب الإحصائيات
$stats = [
    'students' => 0,
    'courses' => 0,
    'semesters' => 0,
    'grades' => 0
];

if ($it_major) {
    $stats['students'] = $db->fetchOne(
        "SELECT COUNT(*) as count FROM students WHERE major_id = ?",
        [$it_major['id']]
    )['count'] ?? 0;
    
    $stats['courses'] = $db->fetchOne(
        "SELECT COUNT(*) as count FROM courses WHERE major_id = ?",
        [$it_major['id']]
    )['count'] ?? 0;
    
    $stats['semesters'] = $db->fetchOne(
        "SELECT COUNT(*) as count FROM semesters WHERE major_id = ?",
        [$it_major['id']]
    )['count'] ?? 0;
    
    $stats['grades'] = $db->fetchOne(
        "SELECT COUNT(*) as count FROM grades g
         JOIN student_courses sc ON g.student_course_id = sc.id
         JOIN courses c ON sc.course_id = c.id
         WHERE c.major_id = ?",
        [$it_major['id']]
    )['count'] ?? 0;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدخال بيانات تجريبية للشهادات</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .info-box {
            background: #e3f2fd;
            border-right: 5px solid #2196F3;
            padding: 15px;
            border-radius: 5px;
            margin: 15px 0;
        }
        .warning-box {
            background: #fff3cd;
            border-right: 5px solid #ffc107;
            padding: 15px;
            border-radius: 5px;
            margin: 15px 0;
        }
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin: 20px 0;
        }
        .stat-card {
            background: #f9f9f9;
            padding: 20px;
            border-radius: 8px;
            text-align: center;
            border: 2px solid #667eea;
        }
        .stat-card h3 {
            margin: 0 0 10px 0;
            color: #667eea;
        }
        .stat-card p {
            margin: 0;
            font-size: 2em;
            font-weight: bold;
            color: #333;
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h2>إدخال بيانات تجريبية للشهادات</h2>
            <a href="dashboard.php" class="btn btn-secondary">العودة</a>
        </div>
        
        <?php echo $message; ?>
        
        <?php if (!$it_major): ?>
            <div class="warning-box">
                <strong>⚠️ تحذير:</strong> يجب إنشاء تخصص تقنية المعلومات والفصول الدراسية أولاً.
                <a href="add_test_semesters_it.php" class="btn btn-primary" style="margin-top: 10px;">إضافة الفصول الدراسية</a>
            </div>
        <?php else: ?>
            <div class="info-box">
                <strong>📋 معلومات التخصص:</strong>
                <p>التخصص: <?php echo htmlspecialchars($it_major['name_ar']); ?> (<?php echo htmlspecialchars($it_major['code']); ?>)</p>
            </div>
            
            <div class="stats-grid">
                <div class="stat-card">
                    <h3>الطلاب</h3>
                    <p><?php echo $stats['students']; ?></p>
                </div>
                <div class="stat-card">
                    <h3>المواد</h3>
                    <p><?php echo $stats['courses']; ?></p>
                </div>
                <div class="stat-card">
                    <h3>الفصول</h3>
                    <p><?php echo $stats['semesters']; ?></p>
                </div>
                <div class="stat-card">
                    <h3>الدرجات</h3>
                    <p><?php echo $stats['grades']; ?></p>
                </div>
            </div>
            
            <div class="card">
                <div class="card-header">
                    <h3>البيانات التي سيتم إضافتها:</h3>
                </div>
                <div style="padding: 20px;">
                    <h4>1. الطلاب (5 طلاب):</h4>
                    <ul style="margin-right: 20px;">
                        <li>24001 - هاشم جمال خالد محمد</li>
                        <li>24002 - أحمد محمد علي</li>
                        <li>24003 - فاطمة أحمد حسن</li>
                        <li>24004 - محمد خالد إبراهيم</li>
                        <li>24005 - سارة علي محمود</li>
                    </ul>
                    
                    <h4 style="margin-top: 20px;">2. المواد (32 مادة - 4 مواد لكل فصل):</h4>
                    <ul style="margin-right: 20px;">
                        <li><strong>الفصل 1:</strong> CS101, MATH101, ENG101, PHYS101</li>
                        <li><strong>الفصل 2:</strong> CS102, MATH102, ENG102, STAT101</li>
                        <li><strong>الفصل 3:</strong> CS201, CS202, MATH201, CS203</li>
                        <li><strong>الفصل 4:</strong> CS204, CS205, CS206, CS207</li>
                        <li><strong>الفصل 5:</strong> CS301, CS302, CS303, CS304</li>
                        <li><strong>الفصل 6:</strong> CS305, CS306, CS307, CS308</li>
                        <li><strong>الفصل 7:</strong> CS401, CS402, CS403, CS404</li>
                        <li><strong>الفصل 8:</strong> CS405, CS406, CS407, CS408</li>
                    </ul>
                    
                    <h4 style="margin-top: 20px;">3. التسجيلات والدرجات:</h4>
                    <ul style="margin-right: 20px;">
                        <li>تسجيل جميع الطلاب في جميع المواد</li>
                        <li>إدخال درجات متنوعة للطلاب (60-95)</li>
                        <li>حساب المعدلات الفصلية والتراكمية تلقائياً</li>
                    </ul>
                    
                    <div class="warning-box" style="margin-top: 20px;">
                        <strong>⚠️ ملاحظة:</strong> إذا كانت البيانات موجودة مسبقاً، سيتم تخطيها.
                    </div>
                    
                    <form method="POST" style="margin-top: 20px;">
                        <input type="hidden" name="action" value="add_test_data">
                        <button type="submit" class="btn btn-primary" style="padding: 12px 30px; font-size: 16px;" onclick="return confirm('هل تريد إدخال البيانات التجريبية؟');">
                            ✅ إدخال البيانات التجريبية
                        </button>
                    </form>
                </div>
            </div>
        <?php endif; ?>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>

