<?php
/**
 * سكريبت تلقائي لإعادة تعيين كلمة مرور MySQL وتحديث ملف الإعدادات
 * Automatic script to reset MySQL password and update config file
 */

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إعادة تعيين كلمة مرور MySQL</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 700px;
            margin: 0 auto;
            background: white;
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .content { padding: 30px; }
        .step {
            padding: 20px;
            margin: 15px 0;
            border-radius: 8px;
            border-right: 4px solid #ddd;
            background: #f9f9f9;
        }
        .step.success { border-right-color: #4caf50; background: #f1f8f4; }
        .step.error { border-right-color: #f44336; background: #ffebee; }
        .step.warning { border-right-color: #ff9800; background: #fff3e0; }
        .step.info { border-right-color: #2196f3; background: #e3f2fd; }
        h2 { color: #667eea; margin-bottom: 15px; }
        h3 { margin: 10px 0; }
        code {
            background: #f4f4f4;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: 'Courier New', monospace;
            color: #d63384;
            display: block;
            padding: 10px;
            margin: 10px 0;
            overflow-x: auto;
        }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin: 10px 5px;
            border: none;
            cursor: pointer;
            font-size: 16px;
        }
        .btn:hover { background: #5568d3; }
        .btn-success { background: #4caf50; }
        ol { margin-right: 20px; }
        li { margin: 8px 0; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🔧 إعادة تعيين كلمة مرور MySQL</h1>
            <p>تحديث تلقائي لملف الإعدادات</p>
        </div>
        
        <div class="content">
            <?php
            $newPassword = 'root'; // كلمة المرور الجديدة
            $dbFilePath = __DIR__ . '/config/database.php';
            
            echo '<div class="step info">';
            echo '<h2>الخطوة 1: تحديث ملف الإعدادات</h2>';
            
            // تحديث ملف database.php
            if (file_exists($dbFilePath) && is_writable($dbFilePath)) {
                $dbFile = file_get_contents($dbFilePath);
                $lines = explode("\n", $dbFile);
                $updated = false;
                
                foreach ($lines as $i => $line) {
                    if (preg_match("/define\s*\(\s*['\"]DB_PASS['\"]/", $line)) {
                        $lines[$i] = "define('DB_PASS', '$newPassword'); // قم بتغيير هذه القيمة إلى كلمة مرور MySQL الخاصة بك";
                        $updated = true;
                        break;
                    }
                }
                
                if ($updated) {
                    file_put_contents($dbFilePath, implode("\n", $lines));
                    echo '<p style="color: #4caf50;">✓ تم تحديث ملف <code>config/database.php</code> بنجاح!</p>';
                    echo '<p>كلمة المرور الجديدة: <code>' . htmlspecialchars($newPassword) . '</code></p>';
                } else {
                    echo '<p style="color: #f44336;">✗ لم يتم العثور على سطر DB_PASS في الملف</p>';
                }
            } else {
                echo '<p style="color: #f44336;">✗ لا يمكن كتابة ملف config/database.php (مشكلة في الصلاحيات)</p>';
            }
            echo '</div>';
            
            // اختبار الاتصال
            echo '<div class="step info">';
            echo '<h2>الخطوة 2: اختبار الاتصال</h2>';
            
            try {
                require_once $dbFilePath;
                $db = Database::getInstance();
                $connection = $db->getConnection();
                echo '<p style="color: #4caf50;">✓ الاتصال بقاعدة البيانات نجح!</p>';
                echo '<p>كلمة المرور <code>' . htmlspecialchars($newPassword) . '</code> صحيحة.</p>';
                $connectionSuccess = true;
            } catch (PDOException $e) {
                $errorMsg = $e->getMessage();
                echo '<p style="color: #f44336;">✗ فشل الاتصال: ' . htmlspecialchars($errorMsg) . '</p>';
                $connectionSuccess = false;
                
                if (strpos($errorMsg, 'Access denied') !== false) {
                    echo '<p><strong>المشكلة:</strong> كلمة المرور <code>' . htmlspecialchars($newPassword) . '</code> غير صحيحة.</p>';
                }
            }
            echo '</div>';
            
            // إذا فشل الاتصال، عرض التعليمات
            if (!$connectionSuccess) {
                echo '<div class="step warning">';
                echo '<h2>⚠ يجب إعادة تعيين كلمة مرور MySQL</h2>';
                echo '<p>كلمة المرور <code>' . htmlspecialchars($newPassword) . '</code> غير صحيحة. يجب إعادة تعيينها في MySQL.</p>';
                
                echo '<h3>الطريقة 1: من AppServ Control Panel (الأسهل)</h3>';
                echo '<ol>';
                echo '<li>افتح <strong>AppServ Control Panel</strong></li>';
                echo '<li>ابحث عن خيار <strong>"MySQL Password"</strong> أو <strong>"Change Password"</strong></li>';
                echo '<li>عيّن كلمة مرور جديدة: <code>' . htmlspecialchars($newPassword) . '</code></li>';
                echo '<li>أعد تشغيل MySQL</li>';
                echo '<li>حدّث هذه الصفحة</li>';
                echo '</ol>';
                
                echo '<h3>الطريقة 2: من سطر الأوامر</h3>';
                echo '<p><strong>الخطوات:</strong></p>';
                echo '<ol>';
                echo '<li>أوقف MySQL من AppServ Control Panel</li>';
                echo '<li>افتح PowerShell كمسؤول واكتب:</li>';
                echo '</ol>';
                echo '<code>';
                echo 'cd C:\\AppServ\\MySQL\\bin<br>';
                echo 'Start-Process -FilePath "mysqld.exe" -ArgumentList "--skip-grant-tables" -WindowStyle Hidden<br><br>';
                echo '# انتظر 5 ثوانٍ، ثم في نافذة PowerShell أخرى:<br>';
                echo 'mysql -u root<br><br>';
                echo '# في MySQL prompt:<br>';
                echo 'ALTER USER \'root\'@\'localhost\' IDENTIFIED BY \'' . htmlspecialchars($newPassword) . '\';<br>';
                echo 'FLUSH PRIVILEGES;<br>';
                echo 'EXIT;<br><br>';
                echo '# أوقف MySQL وأعد تشغيله من AppServ Control Panel';
                echo '</code>';
                
                echo '<h3>الطريقة 3: استخدام السكريبت</h3>';
                echo '<p>شغّل ملف <code>reset_mysql_password.ps1</code> كمسؤول:</p>';
                echo '<ol>';
                echo '<li>انقر بزر الماوس الأيمن على <code>reset_mysql_password.ps1</code></li>';
                echo '<li>اختر <strong>"Run with PowerShell"</strong> أو <strong>"Run as Administrator"</strong></li>';
                echo '</ol>';
                
                echo '</div>';
            } else {
                echo '<div class="step success">';
                echo '<h2>✅ تم بنجاح!</h2>';
                echo '<p>تم تحديث كلمة مرور قاعدة البيانات بنجاح.</p>';
                echo '<p><strong>كلمة المرور الحالية:</strong> <code>' . htmlspecialchars($newPassword) . '</code></p>';
                echo '<p><a href="test_student_registration.php" class="btn btn-success">اختبار شامل للنظام</a></p>';
                echo '</div>';
            }
            ?>
            
            <div class="step info" style="margin-top: 30px;">
                <h3>ملاحظات:</h3>
                <ul style="margin-right: 20px;">
                    <li>تم تحديث ملف <code>config/database.php</code> تلقائياً</li>
                    <li>إذا فشل الاتصال، يجب إعادة تعيين كلمة المرور في MySQL أولاً</li>
                    <li>بعد إعادة التعيين في MySQL، حدّث هذه الصفحة للتحقق</li>
                </ul>
            </div>
        </div>
    </div>
</body>
</html>

