<?php
/**
 * سكريبت لفحص جدول colleges والتحقق من المشكلة
 */

require_once __DIR__ . '/config/config.php';

$db = Database::getInstance();

echo "=== فحص جدول colleges ===\n\n";

try {
    // 1. فحص بنية الجدول
    echo "1. بنية الجدول:\n";
    $structure = $db->fetchAll("DESCRIBE colleges");
    foreach ($structure as $col) {
        echo "   - {$col['Field']}: {$col['Type']} " . ($col['Key'] === 'PRI' ? '(PRIMARY KEY)' : '') . 
             ($col['Extra'] === 'auto_increment' ? '(AUTO_INCREMENT)' : '') . "\n";
    }
    
    echo "\n2. حالة AUTO_INCREMENT:\n";
    $status = $db->fetchOne("SHOW TABLE STATUS LIKE 'colleges'");
    echo "   - AUTO_INCREMENT الحالي: " . ($status['Auto_increment'] ?? 'NULL') . "\n";
    
    echo "\n3. البيانات الموجودة:\n";
    $colleges = $db->fetchAll("SELECT * FROM colleges ORDER BY id");
    if (empty($colleges)) {
        echo "   - لا توجد بيانات\n";
    } else {
        foreach ($colleges as $college) {
            echo "   - ID: {$college['id']}, Code: {$college['code']}, Name: {$college['name_ar']}\n";
        }
    }
    
    echo "\n4. فحص وجود ID = 0:\n";
    $zero_id = $db->fetchOne("SELECT * FROM colleges WHERE id = 0");
    if ($zero_id) {
        echo "   ⚠️  تحذير: يوجد سجل ب ID = 0!\n";
        echo "   هذا قد يسبب المشكلة. يجب حذف هذا السجل.\n";
    } else {
        echo "   ✓ لا يوجد سجل ب ID = 0\n";
    }
    
    echo "\n5. فحص وجود ID = 9:\n";
    $id_9 = $db->fetchOne("SELECT * FROM colleges WHERE id = 9");
    if ($id_9) {
        echo "   ✓ يوجد سجل ب ID = 9:\n";
        echo "   - Code: {$id_9['code']}\n";
        echo "   - Name: {$id_9['name_ar']}\n";
    } else {
        echo "   ⚠️  لا يوجد سجل ب ID = 9\n";
    }
    
} catch (PDOException $e) {
    echo "✗ خطأ: " . $e->getMessage() . "\n";
}

