<?php
/**
 * توجيه مباشر لإدارة الفصول للكليات التي ليس بها تشعيب
 * للكليات التي بها تشعيب يتم التوجيه إلى majors.php
 */
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || (!$auth->hasRole('admin') && !$auth->hasRole('college_admin'))) {
    header('Location: index.php');
    exit;
}

$college_id = isset($_GET['college_id']) ? (int)$_GET['college_id'] : 0;
if (!$college_id) {
    header('Location: colleges.php');
    exit;
}

$db = Database::getInstance();

// التحقق من الصلاحية
if (!$auth->belongsToCollege($college_id) && !$auth->hasRole('admin')) {
    header('Location: colleges.php');
    exit;
}

$college = $db->fetchOne("SELECT * FROM colleges WHERE id = ?", [$college_id]);
if (!$college) {
    header('Location: colleges.php');
    exit;
}

$has_specialization = isset($college['specialization_year']) && $college['specialization_year'] > 0;

// كلية بها تشعيب → إدارة التخصصات أولاً
if ($has_specialization) {
    header('Location: majors.php?college_id=' . $college_id);
    exit;
}

// كلية بدون تشعيب: الحصول على أو إنشاء تخصص افتراضي واحد ثم التوجيه للفصول
$major = $db->fetchOne("SELECT id FROM majors WHERE college_id = ? ORDER BY id ASC LIMIT 1", [$college_id]);

if (!$major) {
    // التأكد من وجود عمود is_general
    try {
        $col = $db->fetchOne("SHOW COLUMNS FROM majors WHERE Field = 'is_general'");
        if (!$col) {
            $db->getConnection()->exec("ALTER TABLE majors ADD COLUMN is_general TINYINT(1) NOT NULL DEFAULT 0 AFTER total_semesters");
        }
    } catch (PDOException $e) {
        // تجاهل
    }
    $db->query(
        "INSERT INTO majors (college_id, name_ar, name_en, code, total_semesters, is_general) VALUES (?, ?, ?, ?, ?, 0)",
        [$college_id, 'الكلية', 'College', 'DEFAULT', 8]
    );
    $major_id = (int)$db->getConnection()->lastInsertId();
} else {
    $major_id = (int)$major['id'];
}

header('Location: semesters.php?major_id=' . $major_id);
exit;
