<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || (!$auth->hasRole('admin') && !$auth->hasRole('college_admin'))) {
    header('Location: index.php');
    exit;
}

$db = Database::getInstance();
$message = '';

// فحص وإصلاح AUTO_INCREMENT إذا لزم الأمر
try {
    // التحقق من وجود سجل ب id=0 وحذفه
    $zero_record = $db->fetchOne("SELECT id FROM colleges WHERE id = 0");
    if ($zero_record) {
        $db->query("DELETE FROM colleges WHERE id = 0");
    }
    
    // التحقق من أن حقل id لديه خاصية AUTO_INCREMENT
    $columns = $db->fetchAll("SHOW COLUMNS FROM colleges WHERE Field = 'id'");
    $has_auto_increment = false;
    if (!empty($columns)) {
        $has_auto_increment = (strpos($columns[0]['Extra'], 'auto_increment') !== false);
    }
    
    // إذا لم يكن لديه AUTO_INCREMENT، قم بإضافته
    if (!$has_auto_increment) {
        // جلب أعلى ID موجود
        $max_id_result = $db->fetchOne("SELECT MAX(id) as max_id FROM colleges WHERE id > 0");
        $max_id = $max_id_result['max_id'] ?? 0;
        $new_auto_increment = max($max_id + 1, 1);
        
        // إضافة AUTO_INCREMENT للحقل
        $db->getConnection()->exec("ALTER TABLE colleges MODIFY id INT(11) NOT NULL AUTO_INCREMENT");
        $db->getConnection()->exec("ALTER TABLE colleges AUTO_INCREMENT = " . (int)$new_auto_increment);
    } else {
        // التحقق من أن AUTO_INCREMENT مضبوط بشكل صحيح
        $status = $db->fetchOne("SHOW TABLE STATUS LIKE 'colleges'");
        $auto_increment = $status['Auto_increment'] ?? null;
        $max_id_result = $db->fetchOne("SELECT MAX(id) as max_id FROM colleges WHERE id > 0");
        $max_id = $max_id_result['max_id'] ?? 0;
        
        // إذا كان AUTO_INCREMENT أقل من أو يساوي أعلى ID موجود، قم بتحديثه
        if ($auto_increment !== null && $auto_increment <= $max_id) {
            $new_auto_increment = max($max_id + 1, 1);
            $db->getConnection()->exec("ALTER TABLE colleges AUTO_INCREMENT = " . (int)$new_auto_increment);
        }
    }
} catch (PDOException $e) {
    // تجاهل الأخطاء في الفحص الاستباقي
    error_log("Auto-increment check error: " . $e->getMessage());
}

// معالجة الإضافة
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add') {
    $name_ar = $_POST['name_ar'] ?? '';
    $name_en = $_POST['name_en'] ?? '';
    $code = $_POST['code'] ?? '';
    $specialization_year = !empty($_POST['specialization_year']) ? (int)$_POST['specialization_year'] : null;
    
    if ($name_ar && $code) {
        try {
            // التأكد من عدم وجود سجل ب id=0 قبل الإدراج
            $zero_record = $db->fetchOne("SELECT id FROM colleges WHERE id = 0");
            if ($zero_record) {
                $db->query("DELETE FROM colleges WHERE id = 0");
            }
            
            // التأكد من أن AUTO_INCREMENT يعمل بشكل صحيح
            $columns = $db->fetchAll("SHOW COLUMNS FROM colleges WHERE Field = 'id'");
            $has_auto_increment = false;
            if (!empty($columns)) {
                $has_auto_increment = (strpos($columns[0]['Extra'], 'auto_increment') !== false);
            }
            
            if (!$has_auto_increment) {
                // إضافة AUTO_INCREMENT إذا لم يكن موجوداً
                $max_id_result = $db->fetchOne("SELECT MAX(id) as max_id FROM colleges WHERE id > 0");
                $max_id = $max_id_result['max_id'] ?? 0;
                $new_auto_increment = max($max_id + 1, 1);
                $db->getConnection()->exec("ALTER TABLE colleges MODIFY id INT(11) NOT NULL AUTO_INCREMENT");
                $db->getConnection()->exec("ALTER TABLE colleges AUTO_INCREMENT = " . (int)$new_auto_increment);
            }
            
            // إدراج السجل الجديد (بدون تحديد id ليتم توليده تلقائياً)
            $db->query(
                "INSERT INTO colleges (name_ar, name_en, code, specialization_year) VALUES (?, ?, ?, ?)",
                [$name_ar, $name_en, $code, $specialization_year]
            );
            
            // الحصول على ID المولّد تلقائياً
            $new_id = $db->getConnection()->lastInsertId();
            
            // إذا كان ID = 0 أو false، فهناك مشكلة، يجب إصلاحها
            if ($new_id == 0 || $new_id === false || $new_id === '0') {
                // حذف أي سجل ب id=0
                $db->query("DELETE FROM colleges WHERE id = 0");
                
                // جلب أعلى ID موجود
                $max_id_result = $db->fetchOne("SELECT MAX(id) as max_id FROM colleges WHERE id > 0");
                $max_id = $max_id_result['max_id'] ?? 0;
                $new_auto_increment = max($max_id + 1, 1);
                
                // إصلاح AUTO_INCREMENT
                $db->getConnection()->exec("ALTER TABLE colleges MODIFY id INT(11) NOT NULL AUTO_INCREMENT");
                $db->getConnection()->exec("ALTER TABLE colleges AUTO_INCREMENT = " . (int)$new_auto_increment);
                
                // إعادة إدراج السجل
                $db->query(
                    "INSERT INTO colleges (name_ar, name_en, code, specialization_year) VALUES (?, ?, ?, ?)",
                    [$name_ar, $name_en, $code, $specialization_year]
                );
                $new_id = $db->getConnection()->lastInsertId();
                
                // التحقق مرة أخرى
                if ($new_id == 0 || $new_id === false || $new_id === '0') {
                    throw new Exception("فشل في توليد ID تلقائياً. يرجى التحقق من إعدادات قاعدة البيانات.");
                }
            }
            
            $message = '<div class="alert alert-success">تم إضافة الكلية بنجاح</div>';
        } catch (PDOException $e) {
            $message = '<div class="alert alert-error">خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
        } catch (Exception $e) {
            $message = '<div class="alert alert-error">خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
        }
    }
}

// معالجة التعديل
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'edit') {
    $id = (int)($_POST['id'] ?? 0);
    $name_ar = $_POST['name_ar'] ?? '';
    $name_en = $_POST['name_en'] ?? '';
    $code = $_POST['code'] ?? '';
    $specialization_year = !empty($_POST['specialization_year']) ? (int)$_POST['specialization_year'] : null;
    
    if ($id && $name_ar && $code && $auth->hasRole('admin')) {
        try {
            $db->query(
                "UPDATE colleges SET name_ar = ?, name_en = ?, code = ?, specialization_year = ? WHERE id = ?",
                [$name_ar, $name_en, $code, $specialization_year, $id]
            );
            $message = '<div class="alert alert-success">تم تحديث الكلية بنجاح</div>';
        } catch (PDOException $e) {
            $message = '<div class="alert alert-error">خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
        }
    }
}

// جلب بيانات الكلية للتعديل
$edit_college = null;
if (isset($_GET['edit']) && $auth->hasRole('admin')) {
    $edit_id = (int)$_GET['edit'];
    $edit_college = $db->fetchOne("SELECT * FROM colleges WHERE id = ?", [$edit_id]);
}

// معالجة الحذف
if (isset($_GET['delete']) && $auth->hasRole('admin')) {
    $id = (int)$_GET['delete'];
    $db->query("DELETE FROM colleges WHERE id = ?", [$id]);
    $message = '<div class="alert alert-success">تم حذف الكلية بنجاح</div>';
}

// جلب الكليات
$colleges = $db->fetchAll("SELECT * FROM colleges ORDER BY name_ar");
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة الكليات</title>
    <?php include __DIR__ . '/includes/compatibility.php'; ?>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h2>إدارة الكليات</h2>
            <?php if ($auth->hasRole('admin')): ?>
                <a href="add_colleges_bulk.php" class="btn btn-primary" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; margin-left: 10px;">➕ إضافة كليات دفعة واحدة</a>
                <button onclick="document.getElementById('addForm').style.display='block'" class="btn btn-primary">إضافة كلية</button>
            <?php endif; ?>
        </div>
        
        <?php echo $message; ?>
        
        <?php if ($auth->hasRole('admin')): ?>
        <div id="addForm" class="card" style="display:<?php echo $edit_college ? 'none' : 'none'; ?>; margin-bottom: 20px;">
            <div class="card-header">
                <h3>إضافة كلية جديدة</h3>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="add">
                <div class="form-group">
                    <label>اسم الكلية (عربي)</label>
                    <input type="text" name="name_ar" required>
                </div>
                <div class="form-group">
                    <label>اسم الكلية (إنجليزي)</label>
                    <input type="text" name="name_en">
                </div>
                <div class="form-group">
                    <label>رمز الكلية</label>
                    <input type="text" name="code" required>
                </div>
                <div class="form-group">
                    <label>سنة التوزيع على التخصصات</label>
                    <select name="specialization_year">
                        <option value="">بدون تشعيب (كلية واحدة بدون تخصصات)</option>
                        <option value="1">السنة الأولى</option>
                        <option value="2">السنة الثانية</option>
                        <option value="3">السنة الثالثة</option>
                        <option value="4">السنة الرابعة</option>
                        <option value="5">السنة الخامسة</option>
                    </select>
                    <small style="display: block; color: #666; margin-top: 5px;">
                        اختر «بدون تشعيب» للكليات التي ليس بها تخصصات (مثل كلية القانون). اختر السنة إذا كانت الكلية تتوزع على تخصصات لاحقاً.
                    </small>
                </div>
                <button type="submit" class="btn btn-success">إضافة</button>
                <button type="button" onclick="document.getElementById('addForm').style.display='none'" class="btn btn-secondary">إلغاء</button>
            </form>
        </div>
        
        <?php if ($edit_college): ?>
        <div id="editForm" class="card" style="margin-bottom: 20px;">
            <div class="card-header">
                <h3>تعديل الكلية</h3>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="edit">
                <input type="hidden" name="id" value="<?php echo $edit_college['id']; ?>">
                <div class="form-group">
                    <label>اسم الكلية (عربي)</label>
                    <input type="text" name="name_ar" value="<?php echo htmlspecialchars($edit_college['name_ar']); ?>" required>
                </div>
                <div class="form-group">
                    <label>اسم الكلية (إنجليزي)</label>
                    <input type="text" name="name_en" value="<?php echo htmlspecialchars($edit_college['name_en']); ?>">
                </div>
                <div class="form-group">
                    <label>رمز الكلية</label>
                    <input type="text" name="code" value="<?php echo htmlspecialchars($edit_college['code']); ?>" required>
                </div>
                <div class="form-group">
                    <label>سنة التوزيع على التخصصات</label>
                    <select name="specialization_year">
                        <option value="" <?php echo empty($edit_college['specialization_year']) ? 'selected' : ''; ?>>بدون تشعيب (كلية واحدة بدون تخصصات)</option>
                        <option value="1" <?php echo (int)($edit_college['specialization_year'] ?? 0) === 1 ? 'selected' : ''; ?>>السنة الأولى</option>
                        <option value="2" <?php echo (int)($edit_college['specialization_year'] ?? 0) === 2 ? 'selected' : ''; ?>>السنة الثانية</option>
                        <option value="3" <?php echo (int)($edit_college['specialization_year'] ?? 0) === 3 ? 'selected' : ''; ?>>السنة الثالثة</option>
                        <option value="4" <?php echo (int)($edit_college['specialization_year'] ?? 0) === 4 ? 'selected' : ''; ?>>السنة الرابعة</option>
                        <option value="5" <?php echo (int)($edit_college['specialization_year'] ?? 0) === 5 ? 'selected' : ''; ?>>السنة الخامسة</option>
                    </select>
                    <small style="display: block; color: #666; margin-top: 5px;">
                        «بدون تشعيب» للكليات التي ليس بها تخصصات. اختر السنة إذا كانت الكلية تتوزع على تخصصات لاحقاً.
                    </small>
                </div>
                <button type="submit" class="btn btn-success">تحديث</button>
                <a href="colleges.php" class="btn btn-secondary">إلغاء</a>
            </form>
        </div>
        <?php endif; ?>
        <?php endif; ?>
        
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>الرمز</th>
                        <th>الاسم (عربي)</th>
                        <th>الاسم (إنجليزي)</th>
                        <th>نوع الكلية / سنة التشعيب</th>
                        <th>الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($colleges as $college): ?>
                        <?php if ($auth->hasRole('admin') || $college['id'] == $_SESSION['college_id']): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($college['code']); ?></td>
                            <td><?php echo htmlspecialchars($college['name_ar']); ?></td>
                            <td><?php echo htmlspecialchars($college['name_en']); ?></td>
                            <td>
                                <?php 
                                if (isset($college['specialization_year']) && (int)$college['specialization_year'] > 0) {
                                    echo 'تشعيب من السنة ' . (int)$college['specialization_year'];
                                } else {
                                    echo '<span style="color: #1976d2;" title="كلية بدون تخصصات - إدارة الفصول مباشرة">بدون تشعيب</span>';
                                }
                                ?>
                            </td>
                            <td>
                                <?php 
                                $college_has_specialization = isset($college['specialization_year']) && (int)$college['specialization_year'] > 0;
                                if ($college_has_specialization): ?>
                                <a href="majors.php?college_id=<?php echo $college['id']; ?>" class="btn btn-primary">التخصصات</a>
                                <?php else: ?>
                                <a href="college_semesters.php?college_id=<?php echo $college['id']; ?>" class="btn btn-primary" title="كلية بدون تخصصات - إدارة الفصول مباشرة">الفصول</a>
                                <?php endif; ?>
                                <?php if ($auth->hasRole('admin')): ?>
                                    <a href="?edit=<?php echo $college['id']; ?>" class="btn btn-success">تعديل</a>
                                    <a href="?delete=<?php echo $college['id']; ?>" 
                                       onclick="return confirm('هل أنت متأكد من الحذف؟')" 
                                       class="btn btn-danger">حذف</a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>

