<?php
/**
 * حل نهائي شامل لإصلاح جدول الكليات
 * يجب تشغيله مرة واحدة فقط
 */

require_once __DIR__ . '/config/config.php';

$db = Database::getInstance();

echo "<!DOCTYPE html><html lang='ar' dir='rtl'><head><meta charset='UTF-8'><title>الحل النهائي - إصلاح جدول الكليات</title>";
echo "<style>body{font-family:Arial;padding:20px;direction:rtl;max-width:800px;margin:0 auto;} .success{color:green;font-weight:bold;background:#d4edda;padding:10px;border-radius:5px;margin:10px 0;} .error{color:red;font-weight:bold;background:#f8d7da;padding:10px;border-radius:5px;margin:10px 0;} .info{color:blue;background:#d1ecf1;padding:10px;border-radius:5px;margin:10px 0;} a{display:inline-block;padding:10px 20px;text-decoration:none;border-radius:5px;margin:5px;}</style></head><body>";
echo "<h1>🔧 الحل النهائي - إصلاح جدول الكليات</h1>";

try {
    echo "<div class='info'>جاري فحص وإصلاح جدول الكليات...</div>";
    
    // 1. فحص السجل ب ID = 0
    $zero_college = $db->fetchOne("SELECT * FROM colleges WHERE id = 0");
    
    // 2. فحص AUTO_INCREMENT
    $status = $db->fetchOne("SHOW TABLE STATUS LIKE 'colleges'");
    $current_auto = $status['Auto_increment'] ?? null;
    
    echo "<h2>الخطوة 1: فحص المشاكل</h2>";
    echo "<ul>";
    echo "<li>السجل ب ID = 0: " . ($zero_college ? "⚠️ موجود" : "✓ غير موجود") . "</li>";
    echo "<li>AUTO_INCREMENT: " . ($current_auto === null || $current_auto == 0 ? "⚠️ NULL أو 0" : "✓ " . $current_auto) . "</li>";
    echo "</ul>";
    
    // 3. الإصلاح
    if ($zero_college || $current_auto === null || $current_auto == 0) {
        echo "<h2>الخطوة 2: بدء الإصلاح</h2>";
        
        // بدء المعاملة
        $db->getConnection()->beginTransaction();
        
        try {
            // نقل السجل ب ID = 0 إذا كان موجوداً
            if ($zero_college) {
                echo "<p>📦 فحص السجل ب ID = 0...</p>";
                echo "<p>الرمز: " . htmlspecialchars($zero_college['code']) . "</p>";
                echo "<p>الاسم: " . htmlspecialchars($zero_college['name_ar']) . "</p>";
                
                // التحقق من وجود رمز مكرر
                $code_exists = $db->fetchOne("SELECT id, name_ar FROM colleges WHERE code = ? AND id > 0", [$zero_college['code']]);
                
                if ($code_exists) {
                    // الرمز موجود في سجل آخر، حذف السجل ب ID = 0 مباشرة
                    echo "<p class='warning'>⚠️ الرمز موجود في سجل آخر (ID: {$code_exists['id']} - " . htmlspecialchars($code_exists['name_ar']) . ")</p>";
                    echo "<p>سيتم حذف السجل ب ID = 0 مباشرة...</p>";
                    
                    // تحديث السجلات المرتبطة إلى السجل الموجود
                    $target_id = $code_exists['id'];
                    $majors_updated = $db->query("UPDATE majors SET college_id = ? WHERE college_id = 0", [$target_id])->rowCount();
                    $users_updated = $db->query("UPDATE users SET college_id = ? WHERE college_id = 0", [$target_id])->rowCount();
                    $students_updated = $db->query("UPDATE students SET college_id = ? WHERE college_id = 0", [$target_id])->rowCount();
                    
                    if ($majors_updated > 0) echo "<p class='success'>✓ تم تحديث {$majors_updated} تخصص إلى ID: {$target_id}</p>";
                    if ($users_updated > 0) echo "<p class='success'>✓ تم تحديث {$users_updated} مستخدم إلى ID: {$target_id}</p>";
                    if ($students_updated > 0) echo "<p class='success'>✓ تم تحديث {$students_updated} طالب إلى ID: {$target_id}</p>";
                    
                    // حذف السجل ب ID = 0
                    $db->query("DELETE FROM colleges WHERE id = 0");
                    echo "<p class='success'>✓ تم حذف السجل ب ID = 0</p>";
                } else {
                    // الرمز غير موجود، نقل السجل إلى ID جديد
                    echo "<p>📦 نقل السجل ب ID = 0 إلى ID جديد...</p>";
                    
                    $new_id = 1;
                    $existing_1 = $db->fetchOne("SELECT id FROM colleges WHERE id = ?", [$new_id]);
                    if ($existing_1) {
                        $max_id = $db->fetchOne("SELECT MAX(id) as max_id FROM colleges WHERE id > 0");
                        $new_id = ($max_id['max_id'] ?? 0) + 1;
                    }
                    
                    // نقل السجل
                    $db->query(
                        "INSERT INTO colleges (id, name_ar, name_en, code, specialization_year, created_at, updated_at, gpa_calculation_method) 
                         VALUES (?, ?, ?, ?, ?, ?, ?, ?)",
                        [
                            $new_id, 
                            $zero_college['name_ar'], 
                            $zero_college['name_en'] ?? '', 
                            $zero_college['code'], 
                            $zero_college['specialization_year'], 
                            $zero_college['created_at'], 
                            $zero_college['updated_at'],
                            $zero_college['gpa_calculation_method'] ?? 'standard'
                        ]
                    );
                    echo "<p class='success'>✓ تم نقل السجل إلى ID: {$new_id}</p>";
                    
                    // تحديث السجلات المرتبطة
                    $majors_updated = $db->query("UPDATE majors SET college_id = ? WHERE college_id = 0", [$new_id])->rowCount();
                    $users_updated = $db->query("UPDATE users SET college_id = ? WHERE college_id = 0", [$new_id])->rowCount();
                    $students_updated = $db->query("UPDATE students SET college_id = ? WHERE college_id = 0", [$new_id])->rowCount();
                    
                    if ($majors_updated > 0) echo "<p class='success'>✓ تم تحديث {$majors_updated} تخصص</p>";
                    if ($users_updated > 0) echo "<p class='success'>✓ تم تحديث {$users_updated} مستخدم</p>";
                    if ($students_updated > 0) echo "<p class='success'>✓ تم تحديث {$students_updated} طالب</p>";
                    
                    // حذف السجل القديم
                    $db->query("DELETE FROM colleges WHERE id = 0");
                    echo "<p class='success'>✓ تم حذف السجل القديم ب ID = 0</p>";
                }
            }
            
            // إصلاح AUTO_INCREMENT
            echo "<p>🔧 إصلاح AUTO_INCREMENT...</p>";
            $max_id = $db->fetchOne("SELECT MAX(id) as max_id FROM colleges WHERE id > 0");
            $new_auto = max(($max_id['max_id'] ?? 0) + 1, 1);
            $db->getConnection()->exec("ALTER TABLE colleges AUTO_INCREMENT = " . (int)$new_auto);
            echo "<p class='success'>✓ تم تعيين AUTO_INCREMENT إلى {$new_auto}</p>";
            
            // تأكيد المعاملة
            $db->getConnection()->commit();
            
            // التحقق النهائي
            echo "<h2>الخطوة 3: التحقق النهائي</h2>";
            $status_after = $db->fetchOne("SHOW TABLE STATUS LIKE 'colleges'");
            $auto_after = $status_after['Auto_increment'] ?? null;
            $zero_check = $db->fetchOne("SELECT id FROM colleges WHERE id = 0");
            $all_colleges = $db->fetchAll("SELECT id, name_ar, code FROM colleges ORDER BY id");
            
            echo "<ul>";
            echo "<li>AUTO_INCREMENT: <strong>" . ($auto_after ?? 'NULL') . "</strong></li>";
            echo "<li>السجل ب ID = 0: " . ($zero_check ? "⚠️ لا يزال موجوداً" : "✓ تم حذفه") . "</li>";
            echo "<li>عدد الكليات: <strong>" . count($all_colleges) . "</strong></li>";
            echo "</ul>";
            
            if (!empty($all_colleges)) {
                echo "<p><strong>الكليات الموجودة:</strong></p><ul>";
                foreach ($all_colleges as $col) {
                    echo "<li>ID: {$col['id']} - " . htmlspecialchars($col['name_ar']) . " (" . htmlspecialchars($col['code']) . ")</li>";
                }
                echo "</ul>";
            }
            
            echo "<div class='success'>";
            echo "<h2>✅ تم الإصلاح بنجاح!</h2>";
            echo "<p>يمكنك الآن:</p>";
            echo "<ul>";
            echo "<li>إضافة كليات جديدة من صفحة الكليات</li>";
            echo "<li>تعديل الكليات الموجودة</li>";
            echo "<li>استخدام النظام بشكل طبيعي</li>";
            echo "</ul>";
            echo "</div>";
            
            echo "<p><a href='colleges.php' style='background:green;color:white;'>العودة إلى صفحة الكليات</a></p>";
            
        } catch (PDOException $e) {
            $db->getConnection()->rollBack();
            throw $e;
        }
    } else {
        echo "<div class='success'>";
        echo "<h2>✅ لا توجد مشاكل!</h2>";
        echo "<p>جدول الكليات في حالة جيدة. لا حاجة للإصلاح.</p>";
        echo "</div>";
        echo "<p><a href='colleges.php' style='background:blue;color:white;'>العودة إلى صفحة الكليات</a></p>";
    }
    
} catch (PDOException $e) {
    echo "<div class='error'>";
    echo "<h2>❌ خطأ في الإصلاح</h2>";
    echo "<p>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "</div>";
    echo "<p><a href='diagnose_colleges.php' style='background:orange;color:white;'>فتح صفحة التشخيص</a></p>";
}

echo "</body></html>";

