-- التحقق من بنية جدول students والقيود الفعلية والترقيم التلقائي
-- شغّل هذا في phpMyAdmin أو MySQL ثم راجع النتائج

USE university_results;

-- 1) عرض بنية الجدول كما هي في قاعدة البيانات
SHOW CREATE TABLE students;

-- 2) عرض الفهارس والقيود الفريدة
SHOW INDEX FROM students;

-- 3) عدد الطلاب الحالي (للتشخيص)
SELECT COUNT(*) AS total_students FROM students;

-- 4) التحقق من الترقيم التلقائي (AUTO_INCREMENT)
--    القيمة التالية لـ id يجب أن تكون أكبر من أعلى id موجود
SELECT 
    (SELECT Auto_increment FROM information_schema.tables 
     WHERE table_schema = DATABASE() AND table_name = 'students') AS next_id_value,
    (SELECT COALESCE(MAX(id), 0) FROM students) AS max_id_in_table,
    CASE 
        WHEN (SELECT Auto_increment FROM information_schema.tables 
              WHERE table_schema = DATABASE() AND table_name = 'students') > (SELECT COALESCE(MAX(id), 0) FROM students)
        THEN 'OK'
        WHEN (SELECT COUNT(*) FROM students) = 0
        THEN 'OK (جدول فارغ)'
        ELSE 'يُنصح بإصلاح: ALTER TABLE students AUTO_INCREMENT = 1 + (SELECT MAX(id) FROM students);'
    END AS auto_increment_status;

-- 5) إن كان هناك قيد UNIQUE على عمود واحد فقط (student_number)
--    فالنظام يسمح بعدة طلاب بأرقام مختلفة.
--    ظهور طالب واحد فقط يعني أن الملف المرفوع كان فيه نفس الرقم مكرراً
--    أو أن قارئ الملف قرأ صفاً واحداً فقط.
