-- جدول أرشيف النتائج
-- Results Archive Table
-- لحفظ نسخ من النتائج: الدور الأول، الملاحق، إزالة الرسوب

CREATE TABLE IF NOT EXISTS results_archive (
    id INT PRIMARY KEY AUTO_INCREMENT,
    semester_id INT NOT NULL,
    college_id INT NULL,
    major_id INT NULL,
    result_type ENUM('first_term', 'supplementary', 'removal_exam') NOT NULL COMMENT 'نوع النتيجة: الدور الأول، الملاحق، إزالة الرسوب',
    result_data TEXT NOT NULL COMMENT 'بيانات النتائج بصيغة JSON',
    summary_data TEXT NULL COMMENT 'ملخص الإحصائيات بصيغة JSON',
    saved_by INT NOT NULL COMMENT 'المستخدم الذي حفظ النتائج',
    saved_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT 'تاريخ ووقت الحفظ',
    notes TEXT NULL COMMENT 'ملاحظات إضافية',
    FOREIGN KEY (semester_id) REFERENCES semesters(id) ON DELETE CASCADE,
    FOREIGN KEY (college_id) REFERENCES colleges(id) ON DELETE SET NULL,
    FOREIGN KEY (major_id) REFERENCES majors(id) ON DELETE SET NULL,
    FOREIGN KEY (saved_by) REFERENCES users(id) ON DELETE RESTRICT,
    INDEX idx_semester_type (semester_id, result_type),
    INDEX idx_saved_at (saved_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='أرشيف النتائج';

