# بنية جدول students

## التعريف الحالي (من schema.sql)

```sql
CREATE TABLE students (
    id INT PRIMARY KEY AUTO_INCREMENT,
    college_id INT NOT NULL,
    major_id INT NOT NULL,
    student_number VARCHAR(50) UNIQUE NOT NULL,   -- فريد في كل الجدول
    national_id VARCHAR(50) UNIQUE,               -- فريد (NULL مسموح لتكراره)
    full_name_ar VARCHAR(255) NOT NULL,
    full_name_en VARCHAR(255),
    email VARCHAR(255),
    phone VARCHAR(50),
    address TEXT,
    enrollment_date DATE NOT NULL,
    graduation_date DATE,
    status ENUM('active', 'graduated', 'suspended', 'withdrawn') DEFAULT 'active',
    user_id INT,
    FOREIGN KEY (college_id) REFERENCES colleges(id) ON DELETE CASCADE,
    FOREIGN KEY (major_id) REFERENCES majors(id) ON DELETE CASCADE,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE SET NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);
```

## القيود التي تؤثر على الإدراج

| القيد | التأثير |
|-------|---------|
| `student_number UNIQUE` | لا يمكن وجود طالبين بنفس الرقم الجامعي **في كل النظام**. لا يمنع إضافة 96 طالباً بأرقام مختلفة. |
| `national_id UNIQUE` | لا يمكن وجود طالبين بنفس الرقم الوطني (القيم NULL لا تُحسب تكراراً في MySQL). |
| `FOREIGN KEY (college_id)` | يجب أن يكون college_id موجوداً في جدول colleges. |
| `FOREIGN KEY (major_id)` | يجب أن يكون major_id موجوداً في جدول majors. |

## الخلاصة

- **البنية لا تمنع** وجود أكثر من طالب واحد. يمكن إدراج عشرات الطلاب بأرقام جامعية مختلفة.
- ظهور "طالب واحد فقط" بعد الرفع يكون عادة لأن:
  1. الملف المرفوع يحتوي على **نفس الرقم الجامعي في كل الصفوف** (أو Excel/القارئ يعيد نفس الصف)، فيُضاف الطالب الأول ثم يُعتبر الباقي تكراراً بسبب `UNIQUE(student_number)`.
  2. أو أن قارئ الملف (Excel/CSV) يقرأ صفاً واحداً فقط.

إذا أردت **السماح بنفس الرقم الجامعي في كليات مختلفة** (مثلاً نفس الرقم في كلية القانون وعلوم الحاسوب)، يمكن تغيير القيد إلى `UNIQUE(student_number, college_id)` — انظر الملف `alter_students_unique_to_per_college.sql`.

---

## الترقيم التلقائي (AUTO_INCREMENT) على عمود id

- عمود **id** معرّف كـ `PRIMARY KEY` و **AUTO_INCREMENT** في الجدول، وهذا كافٍ ليعمل الترقيم التلقائي بشكل صحيح.
- في التطبيق: جمل **INSERT** لا تضمن قيمة لـ `id`، فيقوم MySQL بتوليد القيمة تلقائياً.
- الكود في `students.php` يتحقق عند كل تحميل من:
  - حذف أي سجل بـ `id = 0` (إن وُجد).
  - أن عمود `id` يحمل خاصية AUTO_INCREMENT.
  - أن القيمة التالية للترقيم أكبر من `MAX(id)`؛ إن لم تكن، يتم تصحيحها.

**للتحقق يدوياً:** شغّل `check_students_structure.sql` واطلع على نتيجة الاستعلام رقم 4 (قيمة الترقيم التالية مقابل أعلى id). إن ظهر تحذير، نفّذ في SQL:

```sql
SELECT MAX(id) + 1 FROM students;  -- لمعرفة القيمة المطلوبة
ALTER TABLE students AUTO_INCREMENT = <النتيجة>;
```
