<?php
/**
 * سكريبت لحذف جميع الفصول الدراسية وإعادة تعيين AUTO_INCREMENT
 */

require_once __DIR__ . '/config/config.php';

$db = Database::getInstance();

echo "<!DOCTYPE html><html lang='ar' dir='rtl'><head><meta charset='UTF-8'><title>حذف جميع الفصول الدراسية</title>";
echo "<style>body{font-family:Arial;padding:20px;direction:rtl;max-width:800px;margin:0 auto;} .success{color:green;font-weight:bold;background:#d4edda;padding:15px;border-radius:5px;margin:10px 0;} .error{color:red;font-weight:bold;background:#f8d7da;padding:15px;border-radius:5px;margin:10px 0;} .warning{color:orange;font-weight:bold;background:#fff3cd;padding:15px;border-radius:5px;margin:10px 0;} a{display:inline-block;padding:10px 20px;text-decoration:none;border-radius:5px;margin:5px;}</style></head><body>";
echo "<h1>🗑️ حذف جميع الفصول الدراسية</h1>";

// التحقق من وجود معامل التأكيد
if (!isset($_GET['confirm']) || $_GET['confirm'] !== 'yes') {
    echo "<div class='warning'>";
    echo "<h2>⚠️ تحذير!</h2>";
    echo "<p>هذا السكريبت سيقوم بـ:</p>";
    echo "<ul>";
    echo "<li>حذف <strong>جميع</strong> الفصول الدراسية من الجدول</li>";
    echo "<li>حذف جميع الدرجات المرتبطة</li>";
    echo "<li>حذف جميع المواد المرتبطة</li>";
    echo "<li>إعادة تعيين AUTO_INCREMENT إلى 1</li>";
    echo "</ul>";
    echo "<p><strong>هذه العملية لا يمكن التراجع عنها!</strong></p>";
    echo "<p><a href='?confirm=yes' style='background:red;color:white;'>تأكيد الحذف</a></p>";
    echo "<p><a href='majors.php' style='background:gray;color:white;'>إلغاء</a></p>";
    echo "</div>";
    echo "</body></html>";
    exit;
}

try {
    echo "<h2>بدء العملية...</h2>";
    
    // 1. جلب عدد السجلات قبل الحذف
    $semesters_count = count($db->fetchAll("SELECT id FROM semesters"));
    $grades_count = count($db->fetchAll("SELECT id FROM grades"));
    $courses_count = count($db->fetchAll("SELECT id FROM courses"));
    
    echo "<p>عدد السجلات الموجودة:</p>";
    echo "<ul>";
    echo "<li>الفصول الدراسية: <strong>{$semesters_count}</strong></li>";
    echo "<li>الدرجات: <strong>{$grades_count}</strong></li>";
    echo "<li>المواد: <strong>{$courses_count}</strong></li>";
    echo "</ul>";
    
    // 2. بدء المعاملة
    $db->getConnection()->beginTransaction();
    
    echo "<h2>جاري الحذف...</h2>";
    
    // 3. حذف السجلات المرتبطة أولاً (بسبب Foreign Keys)
    echo "<p>1. حذف الدرجات المرتبطة...</p>";
    $deleted_grades = $db->query("DELETE FROM grades")->rowCount();
    echo "<p class='success'>✓ تم حذف {$deleted_grades} درجة</p>";
    
    echo "<p>2. حذف المواد المرتبطة...</p>";
    $deleted_courses = $db->query("DELETE FROM courses")->rowCount();
    echo "<p class='success'>✓ تم حذف {$deleted_courses} مادة</p>";
    
    echo "<p>3. حذف جميع الفصول الدراسية...</p>";
    $deleted_semesters = $db->query("DELETE FROM semesters")->rowCount();
    echo "<p class='success'>✓ تم حذف {$deleted_semesters} فصل دراسي</p>";
    
    // 4. إعادة تعيين AUTO_INCREMENT
    echo "<p>4. إعادة تعيين AUTO_INCREMENT...</p>";
    $db->getConnection()->exec("ALTER TABLE semesters AUTO_INCREMENT = 1");
    echo "<p class='success'>✓ تم إعادة تعيين AUTO_INCREMENT إلى 1</p>";
    
    // 5. التحقق من الحذف
    $remaining_semesters = count($db->fetchAll("SELECT id FROM semesters"));
    $status = $db->fetchOne("SHOW TABLE STATUS LIKE 'semesters'");
    $auto_increment = $status['Auto_increment'] ?? 'NULL';
    
    // تأكيد المعاملة
    $db->getConnection()->commit();
    
    echo "<h2 class='success'>✓✓✓ تمت العملية بنجاح! ✓✓✓</h2>";
    echo "<p>النتائج:</p>";
    echo "<ul>";
    echo "<li>عدد الفصول المتبقية: <strong>{$remaining_semesters}</strong></li>";
    echo "<li>AUTO_INCREMENT الحالي: <strong>{$auto_increment}</strong></li>";
    echo "</ul>";
    
    echo "<div class='success'>";
    echo "<h2>✅ تم حذف جميع الفصول الدراسية بنجاح!</h2>";
    echo "<p>يمكنك الآن:</p>";
    echo "<ul>";
    echo "<li>إضافة فصول دراسية جديدة من صفحة الفصول</li>";
    echo "<li>بدء استخدام النظام من جديد</li>";
    echo "</ul>";
    echo "</div>";
    
    echo "<p><a href='majors.php' style='background:green;color:white;'>العودة إلى صفحة التخصصات</a></p>";
    
} catch (PDOException $e) {
    // إلغاء المعاملة في حالة الخطأ
    if ($db->getConnection()->inTransaction()) {
        $db->getConnection()->rollBack();
    }
    
    echo "<h2 class='error'>✗ خطأ في العملية</h2>";
    echo "<p class='error'>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<p>تم إلغاء جميع التغييرات.</p>";
    echo "<p><a href='majors.php'>العودة إلى صفحة التخصصات</a></p>";
}

echo "</body></html>";

