<?php
/**
 * سكريبت تشخيصي لفحص وإصلاح جدول الكليات
 */

require_once __DIR__ . '/config/config.php';

$db = Database::getInstance();

echo "<!DOCTYPE html><html lang='ar' dir='rtl'><head><meta charset='UTF-8'><title>تشخيص جدول الكليات</title>";
echo "<style>body{font-family:Arial;padding:20px;direction:rtl;} .success{color:green;} .error{color:red;} .warning{color:orange;} table{border-collapse:collapse;width:100%;margin:20px 0;} th,td{border:1px solid #ddd;padding:8px;text-align:right;} th{background:#f2f2f2;}</style></head><body>";
echo "<h1>=== تشخيص جدول الكليات ===</h1>";

try {
    // 1. فحص بنية الجدول
    echo "<h2>1. بنية الجدول:</h2>";
    $structure = $db->fetchAll("DESCRIBE colleges");
    echo "<table><tr><th>الحقل</th><th>النوع</th><th>NULL</th><th>المفتاح</th><th>الافتراضي</th><th>إضافي</th></tr>";
    foreach ($structure as $col) {
        echo "<tr>";
        echo "<td><strong>{$col['Field']}</strong></td>";
        echo "<td>{$col['Type']}</td>";
        echo "<td>{$col['Null']}</td>";
        echo "<td>{$col['Key']}</td>";
        echo "<td>{$col['Default']}</td>";
        echo "<td>{$col['Extra']}</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    // 2. فحص AUTO_INCREMENT
    echo "<h2>2. حالة AUTO_INCREMENT:</h2>";
    $status = $db->fetchOne("SHOW TABLE STATUS LIKE 'colleges'");
    echo "<p>AUTO_INCREMENT الحالي: <strong>" . ($status['Auto_increment'] ?? 'NULL') . "</strong></p>";
    
    // 3. فحص جميع الكليات
    echo "<h2>3. جميع الكليات الموجودة:</h2>";
    $all_colleges = $db->fetchAll("SELECT * FROM colleges ORDER BY id");
    if (empty($all_colleges)) {
        echo "<p class='warning'>⚠️ لا توجد كليات في الجدول</p>";
    } else {
        echo "<table><tr><th>ID</th><th>الرمز</th><th>الاسم (عربي)</th><th>الاسم (إنجليزي)</th><th>سنة التخصص</th><th>تاريخ الإنشاء</th></tr>";
        foreach ($all_colleges as $col) {
            $row_class = $col['id'] == 0 ? 'error' : '';
            echo "<tr class='{$row_class}'>";
            echo "<td><strong>{$col['id']}</strong>" . ($col['id'] == 0 ? ' ⚠️' : '') . "</td>";
            echo "<td>" . htmlspecialchars($col['code']) . "</td>";
            echo "<td>" . htmlspecialchars($col['name_ar']) . "</td>";
            echo "<td>" . htmlspecialchars($col['name_en'] ?? '') . "</td>";
            echo "<td>" . ($col['specialization_year'] ?? 'NULL') . "</td>";
            echo "<td>" . ($col['created_at'] ?? '') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
    // 4. فحص ID = 7 تحديداً
    echo "<h2>4. فحص ID = 7:</h2>";
    $college_7 = $db->fetchOne("SELECT * FROM colleges WHERE id = 7");
    if ($college_7) {
        echo "<p class='success'>✓ تم العثور على كلية ب ID = 7:</p>";
        echo "<ul>";
        echo "<li>الرمز: " . htmlspecialchars($college_7['code']) . "</li>";
        echo "<li>الاسم (عربي): " . htmlspecialchars($college_7['name_ar']) . "</li>";
        echo "<li>الاسم (إنجليزي): " . htmlspecialchars($college_7['name_en'] ?? '') . "</li>";
        echo "</ul>";
    } else {
        echo "<p class='error'>✗ لا توجد كلية ب ID = 7</p>";
        
        // البحث عن أقرب ID
        $nearby = $db->fetchAll("SELECT id, name_ar, code FROM colleges WHERE id BETWEEN 5 AND 10 ORDER BY id");
        if (!empty($nearby)) {
            echo "<p>الكليات القريبة:</p><ul>";
            foreach ($nearby as $col) {
                echo "<li>ID: {$col['id']} - " . htmlspecialchars($col['name_ar']) . " (" . htmlspecialchars($col['code']) . ")</li>";
            }
            echo "</ul>";
        }
    }
    
    // 5. فحص ID = 0
    echo "<h2>5. فحص ID = 0:</h2>";
    $college_0 = $db->fetchOne("SELECT * FROM colleges WHERE id = 0");
    if ($college_0) {
        echo "<p class='error'>⚠️ يوجد سجل ب ID = 0:</p>";
        echo "<ul>";
        echo "<li>الرمز: " . htmlspecialchars($college_0['code']) . "</li>";
        echo "<li>الاسم (عربي): " . htmlspecialchars($college_0['name_ar']) . "</li>";
        echo "</ul>";
        echo "<p><a href='fix_college_id_zero.php' style='background:orange;color:white;padding:10px 20px;text-decoration:none;border-radius:5px;'>إصلاح السجل ب ID = 0</a></p>";
    } else {
        echo "<p class='success'>✓ لا يوجد سجل ب ID = 0</p>";
    }
    
    // 6. إصلاح AUTO_INCREMENT إذا لزم الأمر
    echo "<h2>6. إصلاح AUTO_INCREMENT:</h2>";
    $max_id = $db->fetchOne("SELECT MAX(id) as max_id FROM colleges WHERE id > 0");
    $current_max = $max_id['max_id'] ?? 0;
    $current_auto = $status['Auto_increment'] ?? 0;
    $expected_auto = max($current_max + 1, 1);
    
    echo "<p>أعلى ID موجود: <strong>{$current_max}</strong></p>";
    echo "<p>AUTO_INCREMENT الحالي: <strong>{$current_auto}</strong></p>";
    echo "<p>AUTO_INCREMENT المتوقع: <strong>{$expected_auto}</strong></p>";
    
    if ($current_auto != $expected_auto && $current_auto != 0) {
        echo "<p class='warning'>⚠️ AUTO_INCREMENT يحتاج إلى إصلاح</p>";
        if (isset($_GET['fix_auto_increment'])) {
            try {
                $db->getConnection()->exec("ALTER TABLE colleges AUTO_INCREMENT = " . (int)$expected_auto);
                echo "<p class='success'>✓ تم إصلاح AUTO_INCREMENT إلى {$expected_auto}</p>";
            } catch (PDOException $e) {
                echo "<p class='error'>✗ فشل الإصلاح: " . htmlspecialchars($e->getMessage()) . "</p>";
            }
        } else {
            echo "<p><a href='?fix_auto_increment=1' style='background:green;color:white;padding:10px 20px;text-decoration:none;border-radius:5px;'>إصلاح AUTO_INCREMENT</a></p>";
        }
    } else {
        echo "<p class='success'>✓ AUTO_INCREMENT صحيح</p>";
    }
    
    echo "<p><a href='colleges.php' style='background:blue;color:white;padding:10px 20px;text-decoration:none;border-radius:5px;'>العودة إلى صفحة الكليات</a></p>";
    
} catch (PDOException $e) {
    echo "<p class='error'>✗ خطأ: " . htmlspecialchars($e->getMessage()) . "</p>";
}

echo "</body></html>";

