<?php
/**
 * سكريبت لإصلاح كلمة مرور المدير
 * Script to fix admin password
 */

require_once __DIR__ . '/config/config.php';

$db = Database::getInstance();

// كلمة المرور الجديدة: admin123
$new_password = password_hash('admin123', PASSWORD_DEFAULT);

try {
    // التحقق من وجود كلية أولاً
    $college = $db->fetchOne("SELECT * FROM colleges WHERE id = 1");
    if (!$college) {
        // محاولة الحصول على أي كلية موجودة
        $any_college = $db->fetchOne("SELECT * FROM colleges LIMIT 1");
        if (!$any_college) {
            // إنشاء كلية افتراضية
            $db->query(
                "INSERT INTO colleges (id, name_ar, name_en, code) 
                 VALUES (1, 'كلية الهندسة', 'College of Engineering', 'ENG')"
            );
            echo "✓ تم إنشاء كلية افتراضية\n";
        } else {
            // استخدام الكلية الموجودة
            $college_id = $any_college['id'];
        }
    } else {
        $college_id = 1;
    }
    
    // التحقق من وجود المستخدم
    $admin = $db->fetchOne("SELECT * FROM users WHERE username = 'admin'");
    
    if ($admin) {
        // تحديث كلمة المرور فقط
        $db->query(
            "UPDATE users SET password = ? WHERE username = 'admin'",
            [$new_password]
        );
        echo "✓ تم تحديث كلمة مرور المدير بنجاح!\n";
        echo "اسم المستخدم: admin\n";
        echo "كلمة المرور: admin123\n";
    } else {
        // إنشاء مستخدم جديد إذا لم يكن موجوداً
        $college_id = $college_id ?? 1;
        $db->query(
            "INSERT INTO users (college_id, username, password, full_name_ar, role) 
             VALUES (?, 'admin', ?, 'مدير النظام', 'admin')",
            [$college_id, $new_password]
        );
        echo "✓ تم إنشاء مستخدم المدير بنجاح!\n";
        echo "اسم المستخدم: admin\n";
        echo "كلمة المرور: admin123\n";
    }
    
} catch (PDOException $e) {
    echo "✗ خطأ: " . $e->getMessage() . "\n";
    echo "\nيرجى التحقق من:\n";
    echo "1. قاعدة البيانات موجودة ومتصلة\n";
    echo "2. إعدادات الاتصال في config/database.php صحيحة\n";
    echo "3. تم تشغيل ملف schema.sql\n";
}

