<?php
/**
 * سكريبت لإصلاح السجل ب ID = 0 في جدول colleges
 * يقوم بنقل السجل إلى ID جديد بدلاً من حذفه
 */

require_once __DIR__ . '/config/config.php';

$db = Database::getInstance();

echo "=== إصلاح السجل ب ID = 0 في جدول colleges ===\n\n";

try {
    // 1. فحص وجود السجل ب ID = 0
    echo "1. فحص السجل ب ID = 0:\n";
    $zero_college = $db->fetchOne("SELECT * FROM colleges WHERE id = 0");
    
    if ($zero_college) {
        echo "   ⚠️  تم العثور على سجل ب ID = 0:\n";
        echo "   - الاسم (عربي): {$zero_college['name_ar']}\n";
        echo "   - الاسم (إنجليزي): {$zero_college['name_en']}\n";
        echo "   - الرمز: {$zero_college['code']}\n";
        
        // 2. جلب أعلى ID موجود
        $max_id = $db->fetchOne("SELECT MAX(id) as max_id FROM colleges");
        $current_max = $max_id['max_id'] ?? 0;
        $new_id = $current_max + 1;
        
        echo "\n2. نقل السجل إلى ID جديد:\n";
        echo "   - أعلى ID موجود: {$current_max}\n";
        echo "   - ID الجديد: {$new_id}\n";
        
        // 3. التحقق من عدم وجود ID الجديد
        $existing = $db->fetchOne("SELECT id FROM colleges WHERE id = ?", [$new_id]);
        if ($existing) {
            echo "   ⚠️  تحذير: ID {$new_id} موجود بالفعل، سيتم استخدام ID أعلى\n";
            $new_id = $current_max + 10; // استخدام رقم أعلى لتجنب التعارض
        }
        
        // 4. نقل السجل إلى ID جديد
        // أولاً: إنشاء سجل جديد ب ID الجديد
        $db->query(
            "INSERT INTO colleges (id, name_ar, name_en, code, specialization_year, created_at, updated_at) 
             VALUES (?, ?, ?, ?, ?, ?, ?)",
            [
                $new_id,
                $zero_college['name_ar'],
                $zero_college['name_en'],
                $zero_college['code'],
                $zero_college['specialization_year'],
                $zero_college['created_at'],
                $zero_college['updated_at']
            ]
        );
        echo "   ✓ تم إنشاء سجل جديد ب ID {$new_id}\n";
        
        // 5. التحقق من وجود تخصصات مرتبطة بالسجل القديم
        $majors = $db->fetchAll("SELECT id FROM majors WHERE college_id = 0");
        if (!empty($majors)) {
            echo "\n3. تحديث التخصصات المرتبطة:\n";
            echo "   - عدد التخصصات المرتبطة: " . count($majors) . "\n";
            $db->query("UPDATE majors SET college_id = ? WHERE college_id = 0", [$new_id]);
            echo "   ✓ تم تحديث التخصصات المرتبطة\n";
        }
        
        // 6. التحقق من وجود مستخدمين مرتبطين
        $users = $db->fetchAll("SELECT id FROM users WHERE college_id = 0");
        if (!empty($users)) {
            echo "\n4. تحديث المستخدمين المرتبطين:\n";
            echo "   - عدد المستخدمين المرتبطين: " . count($users) . "\n";
            $db->query("UPDATE users SET college_id = ? WHERE college_id = 0", [$new_id]);
            echo "   ✓ تم تحديث المستخدمين المرتبطين\n";
        }
        
        // 7. التحقق من وجود طلاب مرتبطين
        $students = $db->fetchAll("SELECT id FROM students WHERE college_id = 0");
        if (!empty($students)) {
            echo "\n5. تحديث الطلاب المرتبطين:\n";
            echo "   - عدد الطلاب المرتبطين: " . count($students) . "\n";
            $db->query("UPDATE students SET college_id = ? WHERE college_id = 0", [$new_id]);
            echo "   ✓ تم تحديث الطلاب المرتبطين\n";
        }
        
        // 8. حذف السجل القديم ب ID = 0
        echo "\n6. حذف السجل القديم ب ID = 0:\n";
        $db->query("DELETE FROM colleges WHERE id = 0");
        echo "   ✓ تم حذف السجل القديم\n";
        
        // 9. إصلاح AUTO_INCREMENT
        $new_auto_increment = $new_id + 1;
        echo "\n7. إصلاح AUTO_INCREMENT:\n";
        echo "   - سيتم تعيين AUTO_INCREMENT إلى: {$new_auto_increment}\n";
        $db->getConnection()->exec("ALTER TABLE colleges AUTO_INCREMENT = " . (int)$new_auto_increment);
        echo "   ✓ تم إصلاح AUTO_INCREMENT بنجاح\n";
        
        // 10. التحقق من الإصلاح
        echo "\n8. التحقق من الإصلاح:\n";
        $status_after = $db->fetchOne("SHOW TABLE STATUS LIKE 'colleges'");
        echo "   - AUTO_INCREMENT الجديد: " . ($status_after['Auto_increment'] ?? 'NULL') . "\n";
        
        $zero_check = $db->fetchOne("SELECT id FROM colleges WHERE id = 0");
        if (!$zero_check) {
            echo "   ✓ لا يوجد سجل ب ID = 0\n";
        }
        
        echo "\n✓✓✓ تم إصلاح المشكلة بنجاح! ✓✓✓\n";
        echo "\nملاحظة: تم نقل الكلية '{$zero_college['name_ar']}' من ID 0 إلى ID {$new_id}\n";
        
    } else {
        echo "   ✓ لا يوجد سجل ب ID = 0\n";
        
        // فقط إصلاح AUTO_INCREMENT
        $max_id = $db->fetchOne("SELECT MAX(id) as max_id FROM colleges");
        $current_max = $max_id['max_id'] ?? 0;
        $new_auto_increment = max($current_max + 1, 1);
        
        echo "\n2. إصلاح AUTO_INCREMENT:\n";
        echo "   - أعلى ID موجود: {$current_max}\n";
        echo "   - سيتم تعيين AUTO_INCREMENT إلى: {$new_auto_increment}\n";
        $db->getConnection()->exec("ALTER TABLE colleges AUTO_INCREMENT = " . (int)$new_auto_increment);
        echo "   ✓ تم إصلاح AUTO_INCREMENT بنجاح\n";
    }
    
} catch (PDOException $e) {
    echo "\n✗ خطأ: " . $e->getMessage() . "\n";
    echo "\nتفاصيل الخطأ:\n";
    echo $e->getTraceAsString();
}

