<?php
/**
 * سكريبت لإصلاح AUTO_INCREMENT في جدول colleges
 */

require_once __DIR__ . '/config/config.php';

$db = Database::getInstance();

echo "=== إصلاح AUTO_INCREMENT لجدول colleges ===\n\n";

try {
    // 1. فحص الحالة الحالية
    echo "1. فحص الحالة الحالية:\n";
    $status = $db->fetchOne("SHOW TABLE STATUS LIKE 'colleges'");
    echo "   - AUTO_INCREMENT الحالي: " . ($status['Auto_increment'] ?? 'NULL') . "\n";
    
    // 2. جلب أعلى ID موجود
    $max_id = $db->fetchOne("SELECT MAX(id) as max_id FROM colleges");
    $current_max = $max_id['max_id'] ?? 0;
    echo "   - أعلى ID موجود: " . $current_max . "\n";
    
    // 3. فحص وجود ID = 0
    $zero_id = $db->fetchOne("SELECT * FROM colleges WHERE id = 0");
    if ($zero_id) {
        echo "\n⚠️  تحذير: يوجد سجل ب ID = 0!\n";
        echo "   هذا يسبب المشكلة. سيتم حذف هذا السجل.\n";
        $db->query("DELETE FROM colleges WHERE id = 0");
        echo "   ✓ تم حذف السجل ب ID = 0\n";
    }
    
    // 4. إصلاح AUTO_INCREMENT
    $new_auto_increment = max($current_max + 1, 1);
    echo "\n2. إصلاح AUTO_INCREMENT:\n";
    echo "   - سيتم تعيين AUTO_INCREMENT إلى: " . $new_auto_increment . "\n";
    
    // استخدام القيمة مباشرة لأن ALTER TABLE لا يدعم prepared statements
    $db->getConnection()->exec("ALTER TABLE colleges AUTO_INCREMENT = " . (int)$new_auto_increment);
    echo "   ✓ تم إصلاح AUTO_INCREMENT بنجاح\n";
    
    // 5. التحقق من الإصلاح
    echo "\n3. التحقق من الإصلاح:\n";
    $status_after = $db->fetchOne("SHOW TABLE STATUS LIKE 'colleges'");
    echo "   - AUTO_INCREMENT الجديد: " . ($status_after['Auto_increment'] ?? 'NULL') . "\n";
    
    echo "\n✓✓✓ تم إصلاح المشكلة بنجاح! ✓✓✓\n";
    
} catch (PDOException $e) {
    echo "\n✗ خطأ: " . $e->getMessage() . "\n";
}

