<?php
/**
 * سكريبت شامل لإصلاح جدول الكليات
 * يقوم بإصلاح AUTO_INCREMENT ونقل السجل ب ID = 0
 */

require_once __DIR__ . '/config/config.php';

$db = Database::getInstance();

echo "<!DOCTYPE html><html lang='ar' dir='rtl'><head><meta charset='UTF-8'><title>إصلاح شامل لجدول الكليات</title>";
echo "<style>body{font-family:Arial;padding:20px;direction:rtl;} .success{color:green;font-weight:bold;} .error{color:red;font-weight:bold;} .warning{color:orange;font-weight:bold;} pre{background:#f5f5f5;padding:10px;border-radius:5px;}</style></head><body>";
echo "<h1>=== إصلاح شامل لجدول الكليات ===</h1>";

try {
    echo "<h2>الخطوة 1: فحص الحالة الحالية</h2>";
    
    // فحص AUTO_INCREMENT
    $status = $db->fetchOne("SHOW TABLE STATUS LIKE 'colleges'");
    $current_auto = $status['Auto_increment'] ?? 'NULL';
    echo "<p>AUTO_INCREMENT الحالي: <strong>{$current_auto}</strong></p>";
    
    // فحص السجل ب ID = 0
    $zero_college = $db->fetchOne("SELECT * FROM colleges WHERE id = 0");
    if ($zero_college) {
        echo "<p class='warning'>⚠️ تم العثور على سجل ب ID = 0:</p>";
        echo "<ul>";
        echo "<li>الرمز: " . htmlspecialchars($zero_college['code']) . "</li>";
        echo "<li>الاسم (عربي): " . htmlspecialchars($zero_college['name_ar']) . "</li>";
        echo "<li>الاسم (إنجليزي): " . htmlspecialchars($zero_college['name_en'] ?? '') . "</li>";
        echo "</ul>";
    } else {
        echo "<p class='success'>✓ لا يوجد سجل ب ID = 0</p>";
    }
    
    // فحص أعلى ID
    $max_id = $db->fetchOne("SELECT MAX(id) as max_id FROM colleges WHERE id > 0");
    $current_max = $max_id['max_id'] ?? 0;
    echo "<p>أعلى ID موجود: <strong>{$current_max}</strong></p>";
    
    echo "<h2>الخطوة 2: إصلاح السجل ب ID = 0</h2>";
    
    if ($zero_college) {
        // نقل السجل إلى ID = 1
        $new_id = 1;
        
        // التحقق من عدم وجود ID = 1
        $existing_1 = $db->fetchOne("SELECT id FROM colleges WHERE id = ?", [$new_id]);
        if ($existing_1) {
            // إذا كان ID = 1 موجوداً، استخدم ID أعلى
            $new_id = $current_max + 1;
            if ($new_id <= 0) $new_id = 1;
        }
        
        echo "<p>سيتم نقل السجل إلى ID: <strong>{$new_id}</strong></p>";
        
        // نقل السجل
        $db->query(
            "INSERT INTO colleges (id, name_ar, name_en, code, specialization_year, created_at, updated_at, gpa_calculation_method) 
             VALUES (?, ?, ?, ?, ?, ?, ?, ?)",
            [
                $new_id, 
                $zero_college['name_ar'], 
                $zero_college['name_en'], 
                $zero_college['code'], 
                $zero_college['specialization_year'], 
                $zero_college['created_at'], 
                $zero_college['updated_at'],
                $zero_college['gpa_calculation_method'] ?? 'standard'
            ]
        );
        echo "<p class='success'>✓ تم إنشاء سجل جديد ب ID {$new_id}</p>";
        
        // تحديث السجلات المرتبطة
        $majors_count = count($db->fetchAll("SELECT id FROM majors WHERE college_id = 0"));
        $users_count = count($db->fetchAll("SELECT id FROM users WHERE college_id = 0"));
        $students_count = count($db->fetchAll("SELECT id FROM students WHERE college_id = 0"));
        
        if ($majors_count > 0) {
            $db->query("UPDATE majors SET college_id = ? WHERE college_id = 0", [$new_id]);
            echo "<p class='success'>✓ تم تحديث {$majors_count} تخصص</p>";
        }
        if ($users_count > 0) {
            $db->query("UPDATE users SET college_id = ? WHERE college_id = 0", [$new_id]);
            echo "<p class='success'>✓ تم تحديث {$users_count} مستخدم</p>";
        }
        if ($students_count > 0) {
            $db->query("UPDATE students SET college_id = ? WHERE college_id = 0", [$new_id]);
            echo "<p class='success'>✓ تم تحديث {$students_count} طالب</p>";
        }
        
        // حذف السجل القديم
        $db->query("DELETE FROM colleges WHERE id = 0");
        echo "<p class='success'>✓ تم حذف السجل القديم ب ID = 0</p>";
    } else {
        echo "<p class='success'>✓ لا يوجد سجل ب ID = 0 يحتاج إلى إصلاح</p>";
    }
    
    echo "<h2>الخطوة 3: إصلاح AUTO_INCREMENT</h2>";
    
    // حساب AUTO_INCREMENT الجديد
    $max_id_after = $db->fetchOne("SELECT MAX(id) as max_id FROM colleges WHERE id > 0");
    $new_max = $max_id_after['max_id'] ?? 0;
    $new_auto_increment = max($new_max + 1, 1);
    
    echo "<p>أعلى ID بعد الإصلاح: <strong>{$new_max}</strong></p>";
    echo "<p>سيتم تعيين AUTO_INCREMENT إلى: <strong>{$new_auto_increment}</strong></p>";
    
    // إصلاح AUTO_INCREMENT
    $db->getConnection()->exec("ALTER TABLE colleges AUTO_INCREMENT = " . (int)$new_auto_increment);
    echo "<p class='success'>✓ تم إصلاح AUTO_INCREMENT إلى {$new_auto_increment}</p>";
    
    // التحقق من الإصلاح
    $status_after = $db->fetchOne("SHOW TABLE STATUS LIKE 'colleges'");
    $auto_after = $status_after['Auto_increment'] ?? 'NULL';
    echo "<p>AUTO_INCREMENT بعد الإصلاح: <strong>{$auto_after}</strong></p>";
    
    // التحقق النهائي
    echo "<h2>الخطوة 4: التحقق النهائي</h2>";
    $zero_check = $db->fetchOne("SELECT id FROM colleges WHERE id = 0");
    if (!$zero_check) {
        echo "<p class='success'>✓ لا يوجد سجل ب ID = 0</p>";
    } else {
        echo "<p class='error'>✗ لا يزال يوجد سجل ب ID = 0!</p>";
    }
    
    $all_colleges = $db->fetchAll("SELECT id, name_ar, code FROM colleges ORDER BY id");
    echo "<p>عدد الكليات الموجودة: <strong>" . count($all_colleges) . "</strong></p>";
    if (!empty($all_colleges)) {
        echo "<p>الكليات:</p><ul>";
        foreach ($all_colleges as $col) {
            echo "<li>ID: {$col['id']} - " . htmlspecialchars($col['name_ar']) . " (" . htmlspecialchars($col['code']) . ")</li>";
        }
        echo "</ul>";
    }
    
    echo "<h2 class='success'>✓✓✓ تم إصلاح جميع المشاكل بنجاح! ✓✓✓</h2>";
    echo "<p><a href='colleges.php' style='background:green;color:white;padding:10px 20px;text-decoration:none;border-radius:5px;display:inline-block;margin:10px 0;'>العودة إلى صفحة الكليات</a></p>";
    echo "<p><a href='diagnose_colleges.php' style='background:blue;color:white;padding:10px 20px;text-decoration:none;border-radius:5px;display:inline-block;margin:10px 0;'>فحص مرة أخرى</a></p>";
    
} catch (PDOException $e) {
    echo "<h2 class='error'>✗ خطأ في العملية</h2>";
    echo "<p class='error'>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
    echo "<p><a href='colleges.php'>العودة إلى صفحة الكليات</a></p>";
}

echo "</body></html>";

