<?php
/**
 * سكريبت لإصلاح مشكلة AUTO_INCREMENT و ID = 0 في جدول semesters
 */

require_once __DIR__ . '/config/config.php';

$db = Database::getInstance();

echo "<!DOCTYPE html><html lang='ar' dir='rtl'><head><meta charset='UTF-8'><title>إصلاح جدول الفصول الدراسية</title>";
echo "<style>body{font-family:Arial;padding:20px;direction:rtl;max-width:800px;margin:0 auto;} .success{color:green;font-weight:bold;background:#d4edda;padding:15px;border-radius:5px;margin:10px 0;} .error{color:red;font-weight:bold;background:#f8d7da;padding:15px;border-radius:5px;margin:10px 0;} .warning{color:orange;font-weight:bold;background:#fff3cd;padding:15px;border-radius:5px;margin:10px 0;} a{display:inline-block;padding:10px 20px;text-decoration:none;border-radius:5px;margin:5px;background:#007bff;color:white;}</style></head><body>";
echo "<h1>🔧 إصلاح جدول الفصول الدراسية (semesters)</h1>";

try {
    echo "<h2>1. فحص الحالة الحالية:</h2>";
    
    // فحص AUTO_INCREMENT
    $status = $db->fetchOne("SHOW TABLE STATUS LIKE 'semesters'");
    $auto_increment = $status['Auto_increment'] ?? 'NULL';
    echo "<p>- AUTO_INCREMENT الحالي: <strong>{$auto_increment}</strong></p>";
    
    // فحص أعلى ID
    $max_id_result = $db->fetchOne("SELECT MAX(id) as max_id FROM semesters");
    $max_id = $max_id_result['max_id'] ?? 0;
    echo "<p>- أعلى ID موجود: <strong>{$max_id}</strong></p>";
    
    // فحص ID = 0
    $id_zero = $db->fetchOne("SELECT * FROM semesters WHERE id = 0");
    if ($id_zero) {
        echo "<p class='warning'>⚠️ تحذير: يوجد سجل ب ID = 0!</p>";
        echo "<p>تفاصيل السجل:</p>";
        echo "<ul>";
        echo "<li>ID: 0</li>";
        echo "<li>major_id: {$id_zero['major_id']}</li>";
        echo "<li>semester_number: {$id_zero['semester_number']}</li>";
        echo "<li>academic_year: {$id_zero['academic_year']}</li>";
        echo "</ul>";
    } else {
        echo "<p class='success'>✓ لا يوجد سجل ب ID = 0</p>";
    }
    
    echo "<h2>2. بدء الإصلاح:</h2>";
    
    // إذا كان هناك سجل ب ID = 0، نحذفه أولاً
    if ($id_zero) {
        echo "<p>جاري حذف السجل ب ID = 0...</p>";
        
        // التحقق من وجود سجلات مرتبطة (grades, courses, etc.)
        $related_grades = $db->fetchOne("SELECT COUNT(*) as count FROM grades WHERE semester_id = 0");
        $related_courses = $db->fetchOne("SELECT COUNT(*) as count FROM courses WHERE semester_id = 0");
        
        if ($related_grades['count'] > 0 || $related_courses['count'] > 0) {
            echo "<p class='warning'>⚠️ يوجد {$related_grades['count']} درجات و {$related_courses['count']} مواد مرتبطة ب ID = 0</p>";
            echo "<p>سيتم حذف هذه السجلات المرتبطة أيضاً...</p>";
            
            // حذف السجلات المرتبطة
            if ($related_grades['count'] > 0) {
                $db->query("DELETE FROM grades WHERE semester_id = 0");
                echo "<p class='success'>✓ تم حذف {$related_grades['count']} درجة</p>";
            }
            if ($related_courses['count'] > 0) {
                $db->query("DELETE FROM courses WHERE semester_id = 0");
                echo "<p class='success'>✓ تم حذف {$related_courses['count']} مادة</p>";
            }
        }
        
        // حذف السجل ب ID = 0
        $db->query("DELETE FROM semesters WHERE id = 0");
        echo "<p class='success'>✓ تم حذف السجل ب ID = 0</p>";
    }
    
    // إصلاح AUTO_INCREMENT
    echo "<p>جاري إصلاح AUTO_INCREMENT...</p>";
    $new_auto_increment = max(1, $max_id + 1);
    if ($id_zero && $max_id == 0) {
        $new_auto_increment = 1;
    }
    
    $db->getConnection()->exec("ALTER TABLE semesters AUTO_INCREMENT = " . (int)$new_auto_increment);
    echo "<p class='success'>✓ تم تعيين AUTO_INCREMENT إلى: {$new_auto_increment}</p>";
    
    // التحقق النهائي
    echo "<h2>3. التحقق النهائي:</h2>";
    $status_after = $db->fetchOne("SHOW TABLE STATUS LIKE 'semesters'");
    $auto_increment_after = $status_after['Auto_increment'] ?? 'NULL';
    $id_zero_after = $db->fetchOne("SELECT * FROM semesters WHERE id = 0");
    
    echo "<p>- AUTO_INCREMENT بعد الإصلاح: <strong>{$auto_increment_after}</strong></p>";
    if ($id_zero_after) {
        echo "<p class='error'>✗ لا يزال يوجد سجل ب ID = 0!</p>";
    } else {
        echo "<p class='success'>✓ لا يوجد سجل ب ID = 0</p>";
    }
    
    echo "<h2 class='success'>✅ تم الإصلاح بنجاح!</h2>";
    echo "<p><a href='semesters.php'>العودة إلى صفحة الفصول الدراسية</a></p>";
    
} catch (PDOException $e) {
    echo "<h2 class='error'>✗ خطأ في الإصلاح</h2>";
    echo "<p class='error'>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<p><a href='semesters.php'>العودة إلى صفحة الفصول الدراسية</a></p>";
}

echo "</body></html>";

