<?php
/**
 * سكريبت قوي لإصلاح السجل ب ID = 0 في جدول colleges
 * يقوم بحذف السجل مباشرة إذا كان يسبب مشاكل
 */

require_once __DIR__ . '/config/config.php';

$db = Database::getInstance();

echo "<!DOCTYPE html><html lang='ar' dir='rtl'><head><meta charset='UTF-8'><title>إصلاح قوي للسجل ب ID = 0</title></head><body>";
echo "<h1>=== إصلاح قوي للسجل ب ID = 0 في جدول colleges ===</h1><pre>";

try {
    // 1. فحص وجود السجل ب ID = 0
    echo "1. فحص السجل ب ID = 0:\n";
    $zero_college = $db->fetchOne("SELECT * FROM colleges WHERE id = 0");
    
    if ($zero_college) {
        echo "   ⚠️  تم العثور على سجل ب ID = 0:\n";
        echo "   - الاسم (عربي): {$zero_college['name_ar']}\n";
        echo "   - الاسم (إنجليزي): {$zero_college['name_en']}\n";
        echo "   - الرمز: {$zero_college['code']}\n";
        
        // 2. التحقق من وجود سجلات مرتبطة
        $majors_count = count($db->fetchAll("SELECT id FROM majors WHERE college_id = 0"));
        $users_count = count($db->fetchAll("SELECT id FROM users WHERE college_id = 0"));
        $students_count = count($db->fetchAll("SELECT id FROM students WHERE college_id = 0"));
        
        echo "\n2. السجلات المرتبطة:\n";
        echo "   - التخصصات: {$majors_count}\n";
        echo "   - المستخدمين: {$users_count}\n";
        echo "   - الطلاب: {$students_count}\n";
        
        // 3. محاولة نقل السجل إلى ID جديد
        $max_id = $db->fetchOne("SELECT MAX(id) as max_id FROM colleges WHERE id > 0");
        $current_max = $max_id['max_id'] ?? 0;
        $new_id = $current_max + 1;
        
        echo "\n3. محاولة نقل السجل إلى ID جديد:\n";
        echo "   - أعلى ID موجود: {$current_max}\n";
        echo "   - ID الجديد: {$new_id}\n";
        
        try {
            // التحقق من عدم وجود رمز مكرر
            $code_exists = $db->fetchOne("SELECT id FROM colleges WHERE code = ? AND id > 0", [$zero_college['code']]);
            if ($code_exists) {
                echo "   ⚠️  الرمز '{$zero_college['code']}' موجود بالفعل في ID: {$code_exists['id']}\n";
                echo "   سيتم حذف السجل ب ID = 0 مباشرة دون نقل\n";
                
                // حذف السجلات المرتبطة أولاً
                if ($majors_count > 0) {
                    echo "   - حذف التخصصات المرتبطة...\n";
                    $db->query("DELETE FROM majors WHERE college_id = 0");
                }
                if ($users_count > 0) {
                    echo "   - حذف المستخدمين المرتبطين...\n";
                    $db->query("DELETE FROM users WHERE college_id = 0");
                }
                if ($students_count > 0) {
                    echo "   - حذف الطلاب المرتبطين...\n";
                    $db->query("DELETE FROM students WHERE college_id = 0");
                }
                
                // حذف السجل ب ID = 0
                $db->query("DELETE FROM colleges WHERE id = 0");
                echo "   ✓ تم حذف السجل ب ID = 0\n";
            } else {
                // نقل السجل إلى ID جديد
                $db->query(
                    "INSERT INTO colleges (id, name_ar, name_en, code, specialization_year, created_at, updated_at) 
                     VALUES (?, ?, ?, ?, ?, ?, ?)",
                    [$new_id, $zero_college['name_ar'], $zero_college['name_en'], $zero_college['code'], 
                     $zero_college['specialization_year'], $zero_college['created_at'], $zero_college['updated_at']]
                );
                echo "   ✓ تم إنشاء سجل جديد ب ID {$new_id}\n";
                
                // تحديث السجلات المرتبطة
                if ($majors_count > 0) {
                    $db->query("UPDATE majors SET college_id = ? WHERE college_id = 0", [$new_id]);
                    echo "   ✓ تم تحديث التخصصات المرتبطة\n";
                }
                if ($users_count > 0) {
                    $db->query("UPDATE users SET college_id = ? WHERE college_id = 0", [$new_id]);
                    echo "   ✓ تم تحديث المستخدمين المرتبطين\n";
                }
                if ($students_count > 0) {
                    $db->query("UPDATE students SET college_id = ? WHERE college_id = 0", [$new_id]);
                    echo "   ✓ تم تحديث الطلاب المرتبطين\n";
                }
                
                // حذف السجل القديم
                $db->query("DELETE FROM colleges WHERE id = 0");
                echo "   ✓ تم حذف السجل القديم ب ID = 0\n";
            }
            
            // إصلاح AUTO_INCREMENT
            $max_id_after = $db->fetchOne("SELECT MAX(id) as max_id FROM colleges WHERE id > 0");
            $new_auto_increment = ($max_id_after['max_id'] ?? 0) + 1;
            echo "\n4. إصلاح AUTO_INCREMENT:\n";
            echo "   - سيتم تعيين AUTO_INCREMENT إلى: {$new_auto_increment}\n";
            $db->getConnection()->exec("ALTER TABLE colleges AUTO_INCREMENT = " . (int)$new_auto_increment);
            echo "   ✓ تم إصلاح AUTO_INCREMENT بنجاح\n";
            
        } catch (PDOException $e) {
            echo "   ✗ خطأ في النقل: " . $e->getMessage() . "\n";
            echo "   محاولة الحذف المباشر...\n";
            
            // محاولة حذف مباشر
            try {
                $db->query("DELETE FROM majors WHERE college_id = 0");
                $db->query("DELETE FROM users WHERE college_id = 0");
                $db->query("DELETE FROM students WHERE college_id = 0");
                $db->query("DELETE FROM colleges WHERE id = 0");
                echo "   ✓ تم حذف السجل ب ID = 0 مباشرة\n";
                
                // إصلاح AUTO_INCREMENT
                $max_id_after = $db->fetchOne("SELECT MAX(id) as max_id FROM colleges WHERE id > 0");
                $new_auto_increment = ($max_id_after['max_id'] ?? 0) + 1;
                $db->getConnection()->exec("ALTER TABLE colleges AUTO_INCREMENT = " . (int)$new_auto_increment);
                echo "   ✓ تم إصلاح AUTO_INCREMENT\n";
            } catch (PDOException $e2) {
                echo "   ✗ فشل الحذف المباشر: " . $e2->getMessage() . "\n";
                throw $e2;
            }
        }
        
        // التحقق من الإصلاح
        echo "\n5. التحقق من الإصلاح:\n";
        $zero_check = $db->fetchOne("SELECT id FROM colleges WHERE id = 0");
        if (!$zero_check) {
            echo "   ✓ لا يوجد سجل ب ID = 0\n";
        } else {
            echo "   ✗ لا يزال يوجد سجل ب ID = 0!\n";
        }
        
        $status_after = $db->fetchOne("SHOW TABLE STATUS LIKE 'colleges'");
        echo "   - AUTO_INCREMENT: " . ($status_after['Auto_increment'] ?? 'NULL') . "\n";
        
        echo "\n✓✓✓ تم إصلاح المشكلة بنجاح! ✓✓✓\n";
        
    } else {
        echo "   ✓ لا يوجد سجل ب ID = 0\n";
        
        // فقط إصلاح AUTO_INCREMENT
        $max_id = $db->fetchOne("SELECT MAX(id) as max_id FROM colleges WHERE id > 0");
        $current_max = $max_id['max_id'] ?? 0;
        $new_auto_increment = max($current_max + 1, 1);
        
        echo "\n2. إصلاح AUTO_INCREMENT:\n";
        echo "   - أعلى ID موجود: {$current_max}\n";
        echo "   - سيتم تعيين AUTO_INCREMENT إلى: {$new_auto_increment}\n";
        $db->getConnection()->exec("ALTER TABLE colleges AUTO_INCREMENT = " . (int)$new_auto_increment);
        echo "   ✓ تم إصلاح AUTO_INCREMENT بنجاح\n";
    }
    
} catch (PDOException $e) {
    echo "\n✗ خطأ: " . $e->getMessage() . "\n";
    echo "\nتفاصيل الخطأ:\n";
    echo $e->getTraceAsString();
}

echo "</pre>";
echo "<p><a href='colleges.php'>العودة إلى صفحة الكليات</a></p>";
echo "</body></html>";

