<?php
if (!isset($auth)) {
    require_once __DIR__ . '/../config/config.php';
    require_once __DIR__ . '/../classes/Auth.php';
    $auth = new Auth();
}
$user = $auth->getCurrentUser();

// توثيق كل نشاط للمستخدم: زيارة الصفحة بالزمن والتاريخ (منذ الدخول حتى الخروج) - مرة واحدة لكل طلب
if ($user && empty($GLOBALS['_activity_page_logged'])) {
    try {
        $GLOBALS['_activity_page_logged'] = true;
        require_once __DIR__ . '/../classes/ActivityLogger.php';
        $activityLogger = new ActivityLogger();
        $req_uri = $_SERVER['REQUEST_URI'] ?? $_SERVER['SCRIPT_NAME'] ?? '';
        $req_method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
        $activityLogger->log('page_access', 'page', null, $req_method . ' ' . $req_uri);
    } catch (Exception $e) {
        error_log("Activity log page_access: " . $e->getMessage());
    }
}
?>
<header class="main-header">
    <div class="header-content">
        <div class="header-logo-title">
            <h1>نظام نتائج الجامعة</h1>
        </div>
        <nav class="main-nav">
            <?php if ($user): ?>
                <span class="user-info">
                    <?php echo htmlspecialchars($user['full_name'] ?: 'مستخدم'); ?>
                    <?php if (!empty($user['college_name'])): ?>(<?php echo htmlspecialchars($user['college_name']); ?>)<?php endif; ?>
                </span>
                <a href="dashboard.php">لوحة التحكم</a>
                <a href="logout.php">تسجيل الخروج</a>
            <?php endif; ?>
        </nav>
    </div>
</header>

