<?php
/**
 * الصفحة الرئيسية - تسجيل الدخول
 * Main Page - Login
 */

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
$error = '';

// إذا كان المستخدم مسجل دخول، إعادة توجيه للوحة التحكم
if ($auth->isLoggedIn()) {
    header('Location: dashboard.php');
    exit;
}

// معالجة تسجيل الدخول
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if (empty($username) || empty($password)) {
        $error = 'خطأ: يرجى إدخال اسم المستخدم وكلمة المرور';
    } elseif ($auth->login($username, $password)) {
        // تسجيل نشاط تسجيل الدخول
        require_once __DIR__ . '/classes/ActivityLogger.php';
        $logger = new ActivityLogger();
        $logger->log('login', null, null, 'تسجيل دخول المستخدم: ' . $username);
        
        header('Location: dashboard.php');
        exit;
    } else {
        $error = 'خطأ: اسم المستخدم أو كلمة المرور غير صحيحة. يرجى التحقق من البيانات والمحاولة مرة أخرى.';
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تسجيل الدخول - نظام نتائج جامعة الشرق للعلوم والتكنولوجيا: Alsharg University of Science and Technology</title>
    <?php include __DIR__ . '/includes/compatibility.php'; ?>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body class="login-page">
    <div class="login-container">
        <div class="login-box">
            <h1>نظام نتائج جامعة الشرق للعلوم والتكنولوجيا: Alsharg University of Science and Technology</h1>
            <h2>تسجيل الدخول</h2>
            
            <?php if ($error): ?>
                <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>
            
            <form method="POST" action="" autocomplete="off">
                <div class="form-group">
                    <label for="username">اسم المستخدم</label>
                    <input type="text" id="username" name="username" required autofocus autocomplete="off" spellcheck="false" inputmode="text">
                </div>
                
                <div class="form-group">
                    <label for="password">كلمة المرور</label>
                    <input type="password" id="password" name="password" required autocomplete="new-password">
                </div>
                
                <button type="submit" class="btn btn-primary">تسجيل الدخول</button>
            </form>
            
            <div style="margin-top: 30px; padding-top: 30px; border-top: 2px solid #e0e0e0; text-align: center;">
                <p style="margin-bottom: 15px; color: #666;">للطلاب: استعلام عن النتائج</p>
                <a href="student_results_by_seat.php" 
                   style="display: inline-block; padding: 12px 30px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; text-decoration: none; border-radius: 25px; font-weight: bold; transition: all 0.3s; box-shadow: 0 5px 15px rgba(0,0,0,0.1);"
                   onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 8px 20px rgba(0,0,0,0.2)';"
                   onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 5px 15px rgba(0,0,0,0.1)';">
                    🔍 استعلام عن النتائج برقم الجلوس
                </a>
            </div>
        </div>
    </div>
</body>
</html>

