<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || (!$auth->hasRole('admin') && !$auth->hasRole('college_admin'))) {
    header('Location: index.php');
    exit;
}

$db = Database::getInstance();
$college_id = isset($_GET['college_id']) ? (int)$_GET['college_id'] : $_SESSION['college_id'];
$message = '';

// فحص وإصلاح AUTO_INCREMENT إذا لزم الأمر
try {
    // التحقق من وجود سجل ب id=0 وحذفه
    $zero_record = $db->fetchOne("SELECT id FROM majors WHERE id = 0");
    if ($zero_record) {
        $db->query("DELETE FROM majors WHERE id = 0");
    }
    
    // التحقق من أن حقل id لديه خاصية AUTO_INCREMENT
    $columns = $db->fetchAll("SHOW COLUMNS FROM majors WHERE Field = 'id'");
    $has_auto_increment = false;
    if (!empty($columns)) {
        $has_auto_increment = (strpos($columns[0]['Extra'], 'auto_increment') !== false);
    }
    
    // إذا لم يكن لديه AUTO_INCREMENT، قم بإضافته
    if (!$has_auto_increment) {
        // جلب أعلى ID موجود
        $max_id_result = $db->fetchOne("SELECT MAX(id) as max_id FROM majors WHERE id > 0");
        $max_id = $max_id_result['max_id'] ?? 0;
        $new_auto_increment = max($max_id + 1, 1);
        
        // إضافة AUTO_INCREMENT للحقل
        $db->getConnection()->exec("ALTER TABLE majors MODIFY id INT(11) NOT NULL AUTO_INCREMENT");
        $db->getConnection()->exec("ALTER TABLE majors AUTO_INCREMENT = " . (int)$new_auto_increment);
    } else {
        // التحقق من أن AUTO_INCREMENT مضبوط بشكل صحيح
        $status = $db->fetchOne("SHOW TABLE STATUS LIKE 'majors'");
        $auto_increment = $status['Auto_increment'] ?? null;
        $max_id_result = $db->fetchOne("SELECT MAX(id) as max_id FROM majors WHERE id > 0");
        $max_id = $max_id_result['max_id'] ?? 0;
        
        // إذا كان AUTO_INCREMENT أقل من أو يساوي أعلى ID موجود، قم بتحديثه
        if ($auto_increment !== null && $auto_increment <= $max_id) {
            $new_auto_increment = max($max_id + 1, 1);
            $db->getConnection()->exec("ALTER TABLE majors AUTO_INCREMENT = " . (int)$new_auto_increment);
        }
    }
} catch (PDOException $e) {
    // تجاهل الأخطاء في الفحص الاستباقي
    error_log("Auto-increment check error: " . $e->getMessage());
}

// التحقق من الصلاحية
if (!$auth->belongsToCollege($college_id) && !$auth->hasRole('admin')) {
    header('Location: colleges.php');
    exit;
}

// إنشاء تخصص "الفصول العامة (قبل التشعيب)" للكليات التي بها تشعيب
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add_general') {
    $college_for_general = $db->fetchOne("SELECT id, specialization_year FROM colleges WHERE id = ?", [$college_id]);
    $sy = isset($college_for_general['specialization_year']) && $college_for_general['specialization_year'] > 0 ? (int)$college_for_general['specialization_year'] : 0;
    $gen_count = $sy ? ($sy - 1) * 2 : 0;
    if ($gen_count > 0) {
        $exists = $db->fetchOne("SELECT id FROM majors WHERE college_id = ? AND is_general = 1", [$college_id]);
        if (!$exists) {
            try {
                $db->query(
                    "INSERT INTO majors (college_id, name_ar, name_en, code, total_semesters, is_general) VALUES (?, ?, ?, ?, ?, 1)",
                    [$college_id, 'مشترك (قبل التشعيب)', 'Common (Pre-Specialization)', 'COMMON', $gen_count]
                );
                $message = '<div class="alert alert-success">تم إنشاء تخصص الفصول العامة (قبل التشعيب) بنجاح. هذه الفصول مشتركة لجميع التخصصات.</div>';
            } catch (PDOException $e) {
                $message = '<div class="alert alert-error">خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
            }
        } else {
            $message = '<div class="alert alert-info">تخصص الفصول العامة موجود مسبقاً.</div>';
        }
    }
}

// معالجة الإضافة
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add') {
    $name_ar = $_POST['name_ar'] ?? '';
    $name_en = $_POST['name_en'] ?? '';
    $code = $_POST['code'] ?? '';
    $total_semesters = (int)($_POST['total_semesters'] ?? 8);
    
    if ($name_ar && $code) {
        try {
            // التأكد من عدم وجود سجل ب id=0 قبل الإدراج
            $zero_record = $db->fetchOne("SELECT id FROM majors WHERE id = 0");
            if ($zero_record) {
                $db->query("DELETE FROM majors WHERE id = 0");
            }
            
            // التأكد من أن AUTO_INCREMENT يعمل بشكل صحيح
            $columns = $db->fetchAll("SHOW COLUMNS FROM majors WHERE Field = 'id'");
            $has_auto_increment = false;
            if (!empty($columns)) {
                $has_auto_increment = (strpos($columns[0]['Extra'], 'auto_increment') !== false);
            }
            
            if (!$has_auto_increment) {
                // إضافة AUTO_INCREMENT إذا لم يكن موجوداً
                $max_id_result = $db->fetchOne("SELECT MAX(id) as max_id FROM majors WHERE id > 0");
                $max_id = $max_id_result['max_id'] ?? 0;
                $new_auto_increment = max($max_id + 1, 1);
                $db->getConnection()->exec("ALTER TABLE majors MODIFY id INT(11) NOT NULL AUTO_INCREMENT");
                $db->getConnection()->exec("ALTER TABLE majors AUTO_INCREMENT = " . (int)$new_auto_increment);
            }
            
            // إدراج السجل الجديد (is_general=0 للتخصصات العادية بعد التشعيب)
            $db->query(
                "INSERT INTO majors (college_id, name_ar, name_en, code, total_semesters, is_general) VALUES (?, ?, ?, ?, ?, 0)",
                [$college_id, $name_ar, $name_en, $code, $total_semesters]
            );
            
            // الحصول على ID المولّد تلقائياً
            $new_id = $db->getConnection()->lastInsertId();
            
            // إذا كان ID = 0 أو false، فهناك مشكلة، يجب إصلاحها
            if ($new_id == 0 || $new_id === false || $new_id === '0') {
                // حذف أي سجل ب id=0
                $db->query("DELETE FROM majors WHERE id = 0");
                
                // جلب أعلى ID موجود
                $max_id_result = $db->fetchOne("SELECT MAX(id) as max_id FROM majors WHERE id > 0");
                $max_id = $max_id_result['max_id'] ?? 0;
                $new_auto_increment = max($max_id + 1, 1);
                
                // إصلاح AUTO_INCREMENT
                $db->getConnection()->exec("ALTER TABLE majors MODIFY id INT(11) NOT NULL AUTO_INCREMENT");
                $db->getConnection()->exec("ALTER TABLE majors AUTO_INCREMENT = " . (int)$new_auto_increment);
                
                // إعادة إدراج السجل
                $db->query(
                    "INSERT INTO majors (college_id, name_ar, name_en, code, total_semesters, is_general) VALUES (?, ?, ?, ?, ?, 0)",
                    [$college_id, $name_ar, $name_en, $code, $total_semesters]
                );
                $new_id = $db->getConnection()->lastInsertId();
                
                // التحقق مرة أخرى
                if ($new_id == 0 || $new_id === false || $new_id === '0') {
                    throw new Exception("فشل في توليد ID تلقائياً. يرجى التحقق من إعدادات قاعدة البيانات.");
                }
            }
            
            $message = '<div class="alert alert-success">تم إضافة التخصص بنجاح</div>';
        } catch (PDOException $e) {
            $message = '<div class="alert alert-error">خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
        } catch (Exception $e) {
            $message = '<div class="alert alert-error">خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
        }
    }
}

// معالجة التعديل
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'edit') {
    $id = (int)($_POST['id'] ?? 0);
    $name_ar = $_POST['name_ar'] ?? '';
    $name_en = $_POST['name_en'] ?? '';
    $code = $_POST['code'] ?? '';
    $total_semesters = (int)($_POST['total_semesters'] ?? 8);
    
    if ($id && $name_ar && $code) {
        // التحقق من أن التخصص ينتمي للكلية الصحيحة
        $major_check = $db->fetchOne("SELECT college_id FROM majors WHERE id = ?", [$id]);
        if ($major_check && ($auth->belongsToCollege($major_check['college_id']) || $auth->hasRole('admin'))) {
            try {
                $db->query(
                    "UPDATE majors SET name_ar = ?, name_en = ?, code = ?, total_semesters = ? WHERE id = ?",
                    [$name_ar, $name_en, $code, $total_semesters, $id]
                );
                $message = '<div class="alert alert-success">تم تحديث التخصص بنجاح</div>';
            } catch (PDOException $e) {
                $message = '<div class="alert alert-error">خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
            }
        }
    }
}

// جلب بيانات التخصص للتعديل
$edit_major = null;
if (isset($_GET['edit'])) {
    $edit_id = (int)$_GET['edit'];
    $edit_major = $db->fetchOne("SELECT * FROM majors WHERE id = ?", [$edit_id]);
    // التحقق من الصلاحية
    if ($edit_major && !$auth->belongsToCollege($edit_major['college_id']) && !$auth->hasRole('admin')) {
        $edit_major = null;
    }
    if ($edit_major) {
        $college_id = $edit_major['college_id']; // تحديث college_id للتأكد من عرض الكلية الصحيحة
    }
}

// جلب التخصصات
$majors = $db->fetchAll(
    "SELECT m.*, c.name_ar as college_name FROM majors m 
     JOIN colleges c ON m.college_id = c.id 
     WHERE m.college_id = ? ORDER BY m.name_ar",
    [$college_id]
);

$college = $db->fetchOne("SELECT * FROM colleges WHERE id = ?", [$college_id]);

// السماح بـ is_general في جدول majors (للفصول العامة قبل التشعيب)
$specialization_year = isset($college['specialization_year']) && $college['specialization_year'] > 0 ? (int)$college['specialization_year'] : null;
try {
    $col_major = $db->fetchOne("SHOW COLUMNS FROM majors WHERE Field = 'is_general'");
    if (!$col_major) {
        $db->getConnection()->exec("ALTER TABLE majors ADD COLUMN is_general TINYINT(1) NOT NULL DEFAULT 0 COMMENT '1=فصول عامة قبل التشعيب' AFTER total_semesters");
    }
} catch (PDOException $e) {
    error_log("Majors is_general column: " . $e->getMessage());
}

// عدد الفصول العامة قبل التشعيب (قبل سنة التشعيب = سنوات مشتركة، كل سنة = 2 فصل)
$general_semesters_count = $specialization_year ? ($specialization_year - 1) * 2 : 0;

// تخصص "الفصول العامة" للكلية التي بها تشعيب (إن لم يكن موجوداً)
$general_major = null;
if ($specialization_year && $general_semesters_count > 0) {
    $general_major = $db->fetchOne("SELECT * FROM majors WHERE college_id = ? AND is_general = 1", [$college_id]);
}

// جلب التخصصات: الفصل العام (إن وجد) + التخصصات العادية (is_general=0)
$majors = $db->fetchAll(
    "SELECT m.*, c.name_ar as college_name FROM majors m 
     JOIN colleges c ON m.college_id = c.id 
     WHERE m.college_id = ? ORDER BY m.is_general DESC, m.name_ar",
    [$college_id]
);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة التخصصات - <?php echo htmlspecialchars($college['name_ar']); ?></title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h2>إدارة التخصصات - <?php echo htmlspecialchars($college['name_ar']); ?></h2>
            <div>
                <a href="colleges.php" class="btn btn-secondary">العودة للكليات</a>
                <a href="add_majors_bulk.php?college_id=<?php echo $college_id; ?>" class="btn btn-primary" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; margin-left: 10px;">➕ إضافة تخصصات دفعة واحدة</a>
                <?php if ($specialization_year && $general_semesters_count > 0 && !$general_major): ?>
                <form method="POST" style="display:inline; margin-left:10px;">
                    <input type="hidden" name="action" value="add_general">
                    <button type="submit" class="btn btn-primary" style="background:#11998e;">إنشاء الفصول العامة (قبل التشعيب)</button>
                </form>
                <?php endif; ?>
                <button onclick="document.getElementById('addForm').style.display='block'" class="btn btn-primary">إضافة تخصص</button>
            </div>
        </div>
        
        <?php if ($specialization_year && $general_semesters_count > 0): ?>
        <div class="alert alert-info" style="margin-bottom:20px;">
            <strong>كلية بها تشعيب (سنة التوزيع: السنة <?php echo $specialization_year; ?>):</strong><br>
            • الفصول <strong>قبل</strong> سنة التشعيب تكون <strong>عامة لجميع التخصصات</strong> (مشتركة).<br>
            • <strong>بعد</strong> التشعيب يكون لكل تخصص <strong>فصوله الخاصة</strong>.
        </div>
        <?php else: ?>
        <div class="alert alert-info" style="margin-bottom:20px;">
            <strong>لا يوجد تشعيب في هذه الكلية:</strong> تدخل الفصول <strong>مباشرة</strong> لكل تخصص — لكل تخصص فصوله وطلابه دون مرحلة مشتركة.
        </div>
        <?php endif; ?>
        
        <?php echo $message; ?>
        
        <div id="addForm" class="card" style="display:<?php echo $edit_major ? 'none' : 'none'; ?>; margin-bottom: 20px;">
            <div class="card-header">
                <h3>إضافة تخصص جديد</h3>
            </div>
            <?php if ($specialization_year && $general_semesters_count > 0): ?>
            <p class="alert alert-info" style="margin:15px;">التخصصات المضافة هنا هي <strong>بعد التشعيب</strong> — لكل تخصص فصوله الخاصة.</p>
            <?php endif; ?>
            <form method="POST">
                <input type="hidden" name="action" value="add">
                <div class="form-group">
                    <label>اسم التخصص (عربي)</label>
                    <input type="text" name="name_ar" required>
                </div>
                <div class="form-group">
                    <label>اسم التخصص (إنجليزي)</label>
                    <input type="text" name="name_en">
                </div>
                <div class="form-group">
                    <label>رمز التخصص</label>
                    <input type="text" name="code" required>
                </div>
                <div class="form-group">
                    <label>عدد الفصول الدراسية</label>
                    <input type="number" name="total_semesters" value="8" min="1" max="16" required>
                </div>
                <button type="submit" class="btn btn-success">إضافة</button>
                <button type="button" onclick="document.getElementById('addForm').style.display='none'" class="btn btn-secondary">إلغاء</button>
            </form>
        </div>
        
        <?php if ($edit_major): ?>
        <div id="editForm" class="card" style="margin-bottom: 20px;">
            <div class="card-header">
                <h3>تعديل التخصص</h3>
            </div>
            <?php if (!empty($edit_major['is_general'])): ?>
            <p class="alert alert-info" style="margin:15px;">هذا تخصص <strong>الفصول العامة (قبل التشعيب)</strong> — مشتركة لجميع التخصصات. عدد الفصول الموصى به: <?php echo $general_semesters_count; ?>.</p>
            <?php endif; ?>
            <form method="POST">
                <input type="hidden" name="action" value="edit">
                <input type="hidden" name="id" value="<?php echo $edit_major['id']; ?>">
                <div class="form-group">
                    <label>اسم التخصص (عربي)</label>
                    <input type="text" name="name_ar" value="<?php echo htmlspecialchars($edit_major['name_ar']); ?>" required>
                </div>
                <div class="form-group">
                    <label>اسم التخصص (إنجليزي)</label>
                    <input type="text" name="name_en" value="<?php echo htmlspecialchars($edit_major['name_en']); ?>">
                </div>
                <div class="form-group">
                    <label>رمز التخصص</label>
                    <input type="text" name="code" value="<?php echo htmlspecialchars($edit_major['code']); ?>" required>
                </div>
                <div class="form-group">
                    <label>عدد الفصول الدراسية</label>
                    <input type="number" name="total_semesters" value="<?php echo $edit_major['total_semesters']; ?>" min="1" max="16" required>
                </div>
                <button type="submit" class="btn btn-success">تحديث</button>
                <a href="majors.php?college_id=<?php echo $college_id; ?>" class="btn btn-secondary">إلغاء</a>
            </form>
        </div>
        <?php endif; ?>
        
        <?php if ($specialization_year && $general_semesters_count > 0): ?>
        <?php 
        $general_majors_list = array_filter($majors, function($m) { return !empty($m['is_general']); });
        $specialized_majors_list = array_filter($majors, function($m) { return empty($m['is_general']); });
        ?>
        <?php if (!empty($general_majors_list)): ?>
        <div class="card" style="margin-bottom: 25px;">
            <div class="card-header" style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); color: white;">
                <h3>الفصول العامة (قبل التشعيب) — مشتركة لجميع التخصصات</h3>
            </div>
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>الرمز</th>
                            <th>الاسم</th>
                            <th>عدد الفصول</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($general_majors_list as $major): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($major['code']); ?></td>
                            <td><?php echo htmlspecialchars($major['name_ar']); ?> <span style="color:#666;">(عامة لكل التخصصات)</span></td>
                            <td><?php echo $major['total_semesters']; ?></td>
                            <td>
                                <a href="semesters.php?major_id=<?php echo $major['id']; ?>" class="btn btn-primary">الفصول</a>
                                <a href="?edit=<?php echo $major['id']; ?>&college_id=<?php echo $college_id; ?>" class="btn btn-success">تعديل</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>
        
        <div class="card">
            <div class="card-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                <h3>التخصصات (بعد التشعيب) — لكل تخصص فصوله الخاصة</h3>
            </div>
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>الرمز</th>
                            <th>الاسم (عربي)</th>
                            <th>عدد الفصول</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($specialized_majors_list)): ?>
                        <tr><td colspan="4" style="text-align:center; color:#666;">لم تتم إضافة تخصصات بعد التشعيب. استخدم زر «إضافة تخصص».</td></tr>
                        <?php else: ?>
                        <?php foreach ($specialized_majors_list as $major): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($major['code']); ?></td>
                            <td><?php echo htmlspecialchars($major['name_ar']); ?></td>
                            <td><?php echo $major['total_semesters']; ?></td>
                            <td>
                                <a href="semesters.php?major_id=<?php echo $major['id']; ?>" class="btn btn-primary">الفصول</a>
                                <a href="students.php?major_id=<?php echo $major['id']; ?>" class="btn btn-success">الطلاب</a>
                                <a href="?edit=<?php echo $major['id']; ?>&college_id=<?php echo $college_id; ?>" class="btn btn-success">تعديل</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php else: ?>
        <div class="card">
            <div class="card-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                <h3>التخصصات — تدخل الفصول مباشرة لكل تخصص</h3>
            </div>
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>الرمز</th>
                            <th>الاسم (عربي)</th>
                            <th>عدد الفصول</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($majors)): ?>
                        <tr><td colspan="4" style="text-align:center; color:#666;">لا توجد تخصصات. استخدم زر «إضافة تخصص».</td></tr>
                        <?php else: ?>
                        <?php foreach ($majors as $major): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($major['code']); ?></td>
                            <td><?php echo htmlspecialchars($major['name_ar']); ?></td>
                            <td><?php echo $major['total_semesters']; ?></td>
                            <td>
                                <a href="semesters.php?major_id=<?php echo $major['id']; ?>" class="btn btn-primary">الفصول</a>
                                <a href="students.php?major_id=<?php echo $major['id']; ?>" class="btn btn-success">الطلاب</a>
                                <a href="?edit=<?php echo $major['id']; ?>&college_id=<?php echo $college_id; ?>" class="btn btn-success">تعديل</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>

