<?php
/**
 * إدارة أسماء المسؤولين للتوقيعات في الشهادات
 * Manage Certificate Signatures
 */

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || (!$auth->hasRole('admin') && !$auth->hasRole('college_admin'))) {
    header('Location: index.php');
    exit;
}

$db = Database::getInstance();
$message = '';

// إنشاء جدول settings إذا لم يكن موجوداً
try {
    $db->query("
        CREATE TABLE IF NOT EXISTS settings (
            setting_key VARCHAR(255) PRIMARY KEY,
            setting_value TEXT,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");
} catch (Exception $e) {
    // الجدول موجود بالفعل أو حدث خطأ
}

// معالجة حفظ الأسماء والأوصاف
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'save_signatures') {
    $registrar_name = trim($_POST['registrar_name'] ?? '');
    $registrar_title = trim($_POST['registrar_title'] ?? '');
    $academic_affairs_name = trim($_POST['academic_affairs_name'] ?? '');
    $academic_affairs_title = trim($_POST['academic_affairs_title'] ?? '');
    $dean_name = trim($_POST['dean_name'] ?? '');
    $dean_title = trim($_POST['dean_title'] ?? '');
    
    if (empty($registrar_name) || empty($academic_affairs_name) || empty($dean_name)) {
        $message = '<div class="alert alert-error">✗ يجب إدخال جميع الأسماء</div>';
    } else {
        try {
            // حفظ أو تحديث الأسماء والأوصاف
            $db->query(
                "INSERT INTO settings (setting_key, setting_value) VALUES ('registrar_name', ?)
                 ON DUPLICATE KEY UPDATE setting_value = ?",
                [$registrar_name, $registrar_name]
            );
            
            $db->query(
                "INSERT INTO settings (setting_key, setting_value) VALUES ('registrar_title', ?)
                 ON DUPLICATE KEY UPDATE setting_value = ?",
                [$registrar_title, $registrar_title]
            );
            
            $db->query(
                "INSERT INTO settings (setting_key, setting_value) VALUES ('academic_affairs_name', ?)
                 ON DUPLICATE KEY UPDATE setting_value = ?",
                [$academic_affairs_name, $academic_affairs_name]
            );
            
            $db->query(
                "INSERT INTO settings (setting_key, setting_value) VALUES ('academic_affairs_title', ?)
                 ON DUPLICATE KEY UPDATE setting_value = ?",
                [$academic_affairs_title, $academic_affairs_title]
            );
            
            $db->query(
                "INSERT INTO settings (setting_key, setting_value) VALUES ('dean_name', ?)
                 ON DUPLICATE KEY UPDATE setting_value = ?",
                [$dean_name, $dean_name]
            );
            
            $db->query(
                "INSERT INTO settings (setting_key, setting_value) VALUES ('dean_title', ?)
                 ON DUPLICATE KEY UPDATE setting_value = ?",
                [$dean_title, $dean_title]
            );
            
            $message = '<div class="alert alert-success">✓ تم حفظ الأسماء والأوصاف بنجاح</div>';
        } catch (Exception $e) {
            $message = '<div class="alert alert-error">✗ خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
            error_log("Error saving signatures: " . $e->getMessage());
        }
    }
}

// جلب الأسماء والأوصاف الحالية
$registrar_name = 'مسجل الكلية';
$registrar_title = 'مسجل الكلية';
$academic_affairs_name = 'أمين الشؤون العلمية';
$academic_affairs_title = 'أمين الشؤون العلمية';
$dean_name = 'عميد الكلية';
$dean_title = 'عميد الكلية';

try {
    $registrar_setting = $db->fetchOne("SELECT setting_value FROM settings WHERE setting_key = 'registrar_name'");
    $registrar_title_setting = $db->fetchOne("SELECT setting_value FROM settings WHERE setting_key = 'registrar_title'");
    $academic_affairs_setting = $db->fetchOne("SELECT setting_value FROM settings WHERE setting_key = 'academic_affairs_name'");
    $academic_affairs_title_setting = $db->fetchOne("SELECT setting_value FROM settings WHERE setting_key = 'academic_affairs_title'");
    $dean_setting = $db->fetchOne("SELECT setting_value FROM settings WHERE setting_key = 'dean_name'");
    $dean_title_setting = $db->fetchOne("SELECT setting_value FROM settings WHERE setting_key = 'dean_title'");
    
    if ($registrar_setting) {
        $registrar_name = $registrar_setting['setting_value'];
    }
    if ($registrar_title_setting) {
        $registrar_title = $registrar_title_setting['setting_value'];
    }
    if ($academic_affairs_setting) {
        $academic_affairs_name = $academic_affairs_setting['setting_value'];
    }
    if ($academic_affairs_title_setting) {
        $academic_affairs_title = $academic_affairs_title_setting['setting_value'];
    }
    if ($dean_setting) {
        $dean_name = $dean_setting['setting_value'];
    }
    if ($dean_title_setting) {
        $dean_title = $dean_title_setting['setting_value'];
    }
} catch (Exception $e) {
    // في حالة عدم وجود الجدول، استخدم القيم الافتراضية
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة أسماء المسؤولين للشهادات</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .form-container {
            max-width: 800px;
            margin: 30px auto;
            padding: 20px;
        }
        .info-box {
            background: #e3f2fd;
            border-right: 5px solid #2196F3;
            padding: 15px;
            border-radius: 5px;
            margin: 15px 0;
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h2>إدارة أسماء المسؤولين للشهادات</h2>
            <a href="dashboard.php" class="btn btn-secondary">العودة</a>
        </div>
        
        <?php echo $message; ?>
        
        <div class="info-box">
            <strong>ℹ️ معلومات:</strong>
            <p>هذه الأسماء ستظهر في شهادات التفاصيل كتوقيعات للمسؤولين.</p>
        </div>
        
        <div class="card">
            <div class="card-header">
                <h3>أسماء المسؤولين</h3>
            </div>
            <div style="padding: 20px;">
                <form method="POST">
                    <input type="hidden" name="action" value="save_signatures">
                    
                    <div class="form-group">
                        <label><strong>اسم مسجل الكلية:</strong> <span style="color: red;">*</span></label>
                        <input type="text" 
                               name="registrar_name" 
                               value="<?php echo htmlspecialchars($registrar_name); ?>" 
                               required
                               style="width: 100%; padding: 10px; margin-top: 5px;"
                               placeholder="أدخل اسم مسجل الكلية">
                    </div>
                    
                    <div class="form-group" style="margin-top: 15px;">
                        <label><strong>وصف/منصب مسجل الكلية:</strong></label>
                        <input type="text" 
                               name="registrar_title" 
                               value="<?php echo htmlspecialchars($registrar_title); ?>" 
                               style="width: 100%; padding: 10px; margin-top: 5px;"
                               placeholder="مثال: مسجل الكلية">
                    </div>
                    
                    <div class="form-group" style="margin-top: 20px;">
                        <label><strong>اسم أمين الشؤون العلمية:</strong> <span style="color: red;">*</span></label>
                        <input type="text" 
                               name="academic_affairs_name" 
                               value="<?php echo htmlspecialchars($academic_affairs_name); ?>" 
                               required
                               style="width: 100%; padding: 10px; margin-top: 5px;"
                               placeholder="أدخل اسم أمين الشؤون العلمية">
                    </div>
                    
                    <div class="form-group" style="margin-top: 15px;">
                        <label><strong>وصف/منصب أمين الشؤون العلمية:</strong></label>
                        <input type="text" 
                               name="academic_affairs_title" 
                               value="<?php echo htmlspecialchars($academic_affairs_title); ?>" 
                               style="width: 100%; padding: 10px; margin-top: 5px;"
                               placeholder="مثال: أمين الشؤون العلمية">
                    </div>
                    
                    <div class="form-group" style="margin-top: 20px;">
                        <label><strong>اسم عميد الكلية:</strong> <span style="color: red;">*</span></label>
                        <input type="text" 
                               name="dean_name" 
                               value="<?php echo htmlspecialchars($dean_name); ?>" 
                               required
                               style="width: 100%; padding: 10px; margin-top: 5px;"
                               placeholder="أدخل اسم عميد الكلية">
                    </div>
                    
                    <div class="form-group" style="margin-top: 15px;">
                        <label><strong>وصف/منصب عميد الكلية:</strong></label>
                        <input type="text" 
                               name="dean_title" 
                               value="<?php echo htmlspecialchars($dean_title); ?>" 
                               style="width: 100%; padding: 10px; margin-top: 5px;"
                               placeholder="مثال: عميد الكلية">
                    </div>
                    
                    <button type="submit" class="btn btn-primary" style="margin-top: 20px; padding: 12px 30px; font-size: 16px;">
                        ✅ حفظ الأسماء
                    </button>
                </form>
            </div>
        </div>
        
        <div class="card" style="margin-top: 20px;">
            <div class="card-header">
                <h3>معاينة التوقيعات</h3>
            </div>
            <div style="padding: 20px; text-align: center;">
                <div style="display: flex; justify-content: space-around; margin-top: 20px;">
                    <div style="text-align: center;">
                        <div style="border-top: 2px solid #333; width: 200px; margin: 50px auto 10px;"></div>
                        <div style="font-weight: bold; margin-top: 10px;"><?php echo htmlspecialchars($registrar_name); ?></div>
                    </div>
                    <div style="text-align: center;">
                        <div style="border-top: 2px solid #333; width: 200px; margin: 50px auto 10px;"></div>
                        <div style="font-weight: bold; margin-top: 10px;"><?php echo htmlspecialchars($academic_affairs_name); ?></div>
                    </div>
                    <div style="text-align: center;">
                        <div style="border-top: 2px solid #333; width: 200px; margin: 50px auto 10px;"></div>
                        <div style="font-weight: bold; margin-top: 10px;"><?php echo htmlspecialchars($dean_name); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>

