<?php
/**
 * صفحة لصق قائمة الطلاب وتوليد القالب مباشرة (بدون Excel)
 * تجنّب مشاكل الترميز و"سجل واحد فقط"
 */
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';
require_once __DIR__ . '/includes/header.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || (!$auth->hasRole('admin') && !$auth->hasRole('college_admin') && !$auth->hasRole('registrar'))) {
    header('Location: index.php');
    exit;
}

$message = '';
$saved_count = 0;
$download_url = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'generate') {
    $raw = trim($_POST['students_list'] ?? '');
    $lines = preg_split('/\r\n|\r|\n/', $raw);
    $rows = [];
    foreach ($lines as $line) {
        $line = trim($line);
        if ($line === '') continue;
        // فصل الرقم والاسم: إما Tab أو فاصلة أو أكثر من مسافة
        $parts = preg_split('/\t|,\s*|\s{2,}/u', $line, 2);
        $num = isset($parts[0]) ? trim($parts[0]) : '';
        $name = isset($parts[1]) ? trim($parts[1]) : '';
        if ($num === '' && $name === '') continue;
        // تخطي سطر العناوين
        if (preg_match('/^(student_number|رقم|number|الرقم)/iu', $num)) continue;
        $rows[] = [$num, $name];
    }
    
    if (empty($rows)) {
        $message = '<div class="alert alert-error">لم يتم العثور على أي سطر صالح. تأكد من أن كل سطر يحتوي على: رقم جامعي ثم الاسم (مفصول بمسافة أو Tab أو فاصلة).</div>';
    } else {
        $csv_header = "student_number,full_name_ar,college_id,major_id,status\n";
        $csv_content = $csv_header;
        foreach ($rows as $r) {
            $num = str_replace(["\r", "\n", '"'], ['', '', '""'], $r[0]);
            $name = str_replace(["\r", "\n", '"'], ['', '', '""'], $r[1]);
            if (strpos($name, ',') !== false) $name = '"' . $name . '"';
            $csv_content .= $num . ',' . $name . ",,,active\n";
        }
        $law_content = "student_number,full_name_ar\n";
        foreach ($rows as $r) {
            $num = str_replace(["\r", "\n", '"'], ['', '', '""'], $r[0]);
            $name = str_replace(["\r", "\n", '"'], ['', '', '""'], $r[1]);
            if (strpos($name, ',') !== false) $name = '"' . $name . '"';
            $law_content .= $num . ',' . $name . "\n";
        }
        
        if (!mb_check_encoding($csv_content, 'UTF-8')) {
            $csv_content = mb_convert_encoding($csv_content, 'UTF-8', 'auto');
        }
        if (!mb_check_encoding($law_content, 'UTF-8')) {
            $law_content = mb_convert_encoding($law_content, 'UTF-8', 'auto');
        }
        
        $bom = "\xEF\xBB\xBF";
        $template_path = __DIR__ . '/templates/template_students_law.csv';
        $law_path = __DIR__ . '/law_students.csv';
        @file_put_contents($template_path, $bom . $csv_content, LOCK_EX);
        @file_put_contents($law_path, $bom . $law_content, LOCK_EX);
        $saved_count = count($rows);
        $download_url = 'download_templates.php?type=students_law';
        $message = '<div class="alert alert-success">✓ تم إنشاء القالب بنجاح: <strong>' . $saved_count . '</strong> طالب/طالبة. الملف محفوظ بترميز UTF-8. <a href="' . htmlspecialchars($download_url) . '" class="btn btn-success" style="margin-right:10px;">📥 تحميل القالب الآن</a> ثم اذهب إلى <a href="students.php">إدارة الطلاب</a> واختر «رفع طلاب من Excel» وارفع الملف المُحمَّل.</div>';
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لصق قائمة الطلاب وتوليد القالب</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .paste-box { width: 100%; min-height: 280px; font-family: inherit; font-size: 15px; padding: 12px; border: 2px solid #4CAF50; border-radius: 8px; }
        .steps { background: #f0f8f0; padding: 20px; border-radius: 8px; margin: 20px 0; border-right: 4px solid #4CAF50; }
        .steps ol { margin: 10px 0 0 20px; }
        .steps li { margin: 8px 0; }
    </style>
</head>
<body>
<div class="container" style="max-width: 900px; margin: 30px auto;">
    <h1>📋 لصق قائمة الطلاب وتوليد القالب (بدون Excel)</h1>
    <p style="color:#666;">هذه الطريقة تتجنب مشاكل الترميز و«سجل واحد فقط». الصق القائمة من أي مصدر (Word، Excel، جدول) وسيتم توليد ملف CSV جاهز بترميز UTF-8.</p>
    
    <?php echo $message; ?>
    
    <div class="steps">
        <strong>خطوات الاستخدام:</strong>
        <ol>
            <li>انسخ قائمة الطلاب من مصدرك (Excel أو Word أو جدول) — عمود الرقم الجامعي وعمود الاسم.</li>
            <li>الصق في الصندوق أدناه. كل سطر = طالب واحد. يمكن أن يكون الفاصل بين الرقم والاسم: <strong>مسافة</strong> أو <strong>Tab</strong> أو <strong>فاصلة</strong>.</li>
            <li>اضغط «توليد القالب وحفظه».</li>
            <li>حمّل الملف المُولَّد من الرابط الذي يظهر، ثم اذهب إلى <strong>إدارة الطلاب → رفع طلاب من Excel</strong> وارفع هذا الملف (اختر الكلية والتخصص ثم ارفع).</li>
        </ol>
    </div>
    
    <form method="POST">
        <input type="hidden" name="action" value="generate">
        <div class="form-group">
            <label for="students_list"><strong>الصق قائمة الطلاب هنا (سطر لكل طالب: رقم جامعي ثم الاسم):</strong></label>
            <textarea name="students_list" id="students_list" class="paste-box" placeholder="مثال:
23-11064571	هبه الله سليمان محمد سليمان
23-11015654	موسى احمد اونور محمد
23-11070385	منية علي محمد ابو القاسم
أو:
23-11064571, هبه الله سليمان محمد سليمان
23-11015654, موسى احمد اونور محمد"><?php echo isset($_POST['students_list']) ? htmlspecialchars($_POST['students_list']) : ''; ?></textarea>
        </div>
        <button type="submit" class="btn btn-success">توليد القالب وحفظه</button>
        <a href="students.php" class="btn btn-secondary">العودة إلى الطلاب</a>
    </form>
    
    <p style="margin-top: 25px; color: #666; font-size: 14px;">
        <strong>ملاحظة:</strong> الملف المُولَّد يُحفظ أيضاً في <code>templates/template_students_law.csv</code> و <code>law_students.csv</code> بترميز UTF-8 مع BOM، لذا الأسماء العربية ستظهر بشكل صحيح عند الرفع.
    </p>
    <p style="margin-top: 15px;">
        <a href="view_guide.php?file=دليل_نقل_الطلاب_خطوة_بخطوة.md" class="btn btn-secondary">📖 دليل نقل الطلاب خطوة بخطوة</a>
    </p>
</div>
</body>
</html>
