<?php
/**
 * سكريبت لإزالة AUTO_INCREMENT من حقل ID في جدول semesters
 */

require_once __DIR__ . '/config/config.php';

$db = Database::getInstance();

echo "<!DOCTYPE html><html lang='ar' dir='rtl'><head><meta charset='UTF-8'><title>إزالة AUTO_INCREMENT من جدول الفصول</title>";
echo "<style>body{font-family:Arial;padding:20px;direction:rtl;max-width:800px;margin:0 auto;} .success{color:green;font-weight:bold;background:#d4edda;padding:15px;border-radius:5px;margin:10px 0;} .error{color:red;font-weight:bold;background:#f8d7da;padding:15px;border-radius:5px;margin:10px 0;} .warning{color:orange;font-weight:bold;background:#fff3cd;padding:15px;border-radius:5px;margin:10px 0;} a{display:inline-block;padding:10px 20px;text-decoration:none;border-radius:5px;margin:5px;background:#007bff;color:white;}</style></head><body>";
echo "<h1>🔧 إزالة AUTO_INCREMENT من جدول الفصول الدراسية</h1>";

try {
    echo "<h2>1. فحص الحالة الحالية:</h2>";
    
    // فحص بنية الجدول
    $columns = $db->fetchAll("SHOW COLUMNS FROM semesters WHERE Field = 'id'");
    if (!empty($columns)) {
        $id_column = $columns[0];
        echo "<p>حقل ID الحالي:</p>";
        echo "<ul>";
        echo "<li>النوع: <strong>{$id_column['Type']}</strong></li>";
        echo "<li>NULL: <strong>{$id_column['Null']}</strong></li>";
        echo "<li>المفتاح: <strong>{$id_column['Key']}</strong></li>";
        echo "<li>الإضافي: <strong>{$id_column['Extra']}</strong></li>";
        echo "</ul>";
        
        if (strpos($id_column['Extra'], 'auto_increment') !== false) {
            echo "<p class='warning'>⚠️ AUTO_INCREMENT مفعّل حالياً</p>";
        } else {
            echo "<p class='success'>✓ AUTO_INCREMENT غير مفعّل</p>";
        }
    }
    
    // فحص AUTO_INCREMENT
    $status = $db->fetchOne("SHOW TABLE STATUS LIKE 'semesters'");
    $auto_increment = $status['Auto_increment'] ?? 'NULL';
    echo "<p>AUTO_INCREMENT الحالي: <strong>{$auto_increment}</strong></p>";
    
    echo "<h2>2. إزالة AUTO_INCREMENT:</h2>";
    
    // إزالة AUTO_INCREMENT من حقل ID
    // نحتاج إلى تعديل الحقل بدون AUTO_INCREMENT مع الحفاظ على PRIMARY KEY
    $db->getConnection()->exec("ALTER TABLE semesters MODIFY id INT NOT NULL");
    
    echo "<p class='success'>✓ تم إزالة AUTO_INCREMENT من حقل ID</p>";
    
    // التحقق من الإزالة
    echo "<h2>3. التحقق من الإزالة:</h2>";
    $columns_after = $db->fetchAll("SHOW COLUMNS FROM semesters WHERE Field = 'id'");
    if (!empty($columns_after)) {
        $id_column_after = $columns_after[0];
        if (strpos($id_column_after['Extra'], 'auto_increment') !== false) {
            echo "<p class='error'>✗ لا يزال AUTO_INCREMENT مفعّل!</p>";
        } else {
            echo "<p class='success'>✓ تم إزالة AUTO_INCREMENT بنجاح</p>";
            echo "<p>حقل ID الآن:</p>";
            echo "<ul>";
            echo "<li>النوع: <strong>{$id_column_after['Type']}</strong></li>";
            echo "<li>NULL: <strong>{$id_column_after['Null']}</strong></li>";
            echo "<li>المفتاح: <strong>{$id_column_after['Key']}</strong></li>";
            echo "<li>الإضافي: <strong>{$id_column_after['Extra']}</strong></li>";
            echo "</ul>";
        }
    }
    
    $status_after = $db->fetchOne("SHOW TABLE STATUS LIKE 'semesters'");
    $auto_increment_after = $status_after['Auto_increment'] ?? 'NULL';
    echo "<p>AUTO_INCREMENT بعد الإزالة: <strong>{$auto_increment_after}</strong></p>";
    
    echo "<h2 class='success'>✅ تمت العملية بنجاح!</h2>";
    echo "<p>يمكنك الآن إدخال ID يدوياً عند إضافة فصل دراسي جديد.</p>";
    echo "<p><a href='semesters.php'>العودة إلى صفحة الفصول الدراسية</a></p>";
    
} catch (PDOException $e) {
    echo "<h2 class='error'>✗ خطأ في العملية</h2>";
    echo "<p class='error'>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<p><a href='semesters.php'>العودة إلى صفحة الفصول الدراسية</a></p>";
}

echo "</body></html>";

