<?php
/**
 * سكريبت لإعادة تعيين جدول الكليات
 * يحذف جميع الكليات ويعيد تعيين AUTO_INCREMENT
 */

require_once __DIR__ . '/config/config.php';

$db = Database::getInstance();

echo "<!DOCTYPE html><html lang='ar' dir='rtl'><head><meta charset='UTF-8'><title>إعادة تعيين جدول الكليات</title>";
echo "<style>body{font-family:Arial;padding:20px;direction:rtl;} .success{color:green;} .error{color:red;} .warning{color:orange;}</style></head><body>";
echo "<h1>=== إعادة تعيين جدول الكليات ===</h1>";

// التحقق من وجود معامل تأكيد
if (!isset($_GET['confirm']) || $_GET['confirm'] !== 'yes') {
    echo "<div class='warning'>";
    echo "<h2>⚠️ تحذير!</h2>";
    echo "<p>هذا السكريبت سيقوم بـ:</p>";
    echo "<ul>";
    echo "<li>حذف <strong>جميع</strong> الكليات من الجدول</li>";
    echo "<li>حذف جميع التخصصات المرتبطة</li>";
    echo "<li>حذف جميع المستخدمين المرتبطين</li>";
    echo "<li>حذف جميع الطلاب المرتبطين</li>";
    echo "<li>إعادة تعيين AUTO_INCREMENT إلى 1</li>";
    echo "</ul>";
    echo "<p><strong>هذه العملية لا يمكن التراجع عنها!</strong></p>";
    echo "<p><a href='?confirm=yes' style='background:red;color:white;padding:10px 20px;text-decoration:none;border-radius:5px;'>تأكيد الحذف</a></p>";
    echo "<p><a href='colleges.php' style='background:gray;color:white;padding:10px 20px;text-decoration:none;border-radius:5px;'>إلغاء</a></p>";
    echo "</div>";
    echo "</body></html>";
    exit;
}

try {
    echo "<h2>بدء العملية...</h2>";
    
    // 1. جلب عدد السجلات قبل الحذف
    $colleges_count = count($db->fetchAll("SELECT id FROM colleges"));
    $majors_count = count($db->fetchAll("SELECT id FROM majors"));
    $users_count = count($db->fetchAll("SELECT id FROM users"));
    $students_count = count($db->fetchAll("SELECT id FROM students"));
    
    echo "<p>عدد السجلات الموجودة:</p>";
    echo "<ul>";
    echo "<li>الكليات: <strong>{$colleges_count}</strong></li>";
    echo "<li>التخصصات: <strong>{$majors_count}</strong></li>";
    echo "<li>المستخدمين: <strong>{$users_count}</strong></li>";
    echo "<li>الطلاب: <strong>{$students_count}</strong></li>";
    echo "</ul>";
    
    // 2. بدء المعاملة
    $db->getConnection()->beginTransaction();
    
    echo "<h2>جاري الحذف...</h2>";
    
    // 3. حذف السجلات المرتبطة أولاً (بسبب Foreign Keys)
    echo "<p>1. حذف الطلاب المرتبطين...</p>";
    $deleted_students = $db->query("DELETE FROM students")->rowCount();
    echo "<p class='success'>✓ تم حذف {$deleted_students} طالب</p>";
    
    echo "<p>2. حذف المستخدمين المرتبطين...</p>";
    $deleted_users = $db->query("DELETE FROM users")->rowCount();
    echo "<p class='success'>✓ تم حذف {$deleted_users} مستخدم</p>";
    
    echo "<p>3. حذف التخصصات المرتبطة...</p>";
    $deleted_majors = $db->query("DELETE FROM majors")->rowCount();
    echo "<p class='success'>✓ تم حذف {$deleted_majors} تخصص</p>";
    
    echo "<p>4. حذف جميع الكليات...</p>";
    $deleted_colleges = $db->query("DELETE FROM colleges")->rowCount();
    echo "<p class='success'>✓ تم حذف {$deleted_colleges} كلية</p>";
    
    // 4. إعادة تعيين AUTO_INCREMENT
    echo "<p>5. إعادة تعيين AUTO_INCREMENT...</p>";
    $db->getConnection()->exec("ALTER TABLE colleges AUTO_INCREMENT = 1");
    echo "<p class='success'>✓ تم إعادة تعيين AUTO_INCREMENT إلى 1</p>";
    
    // 5. التحقق من الحذف
    $remaining_colleges = count($db->fetchAll("SELECT id FROM colleges"));
    $status = $db->fetchOne("SHOW TABLE STATUS LIKE 'colleges'");
    $auto_increment = $status['Auto_increment'] ?? 'NULL';
    
    // تأكيد المعاملة
    $db->getConnection()->commit();
    
    echo "<h2 class='success'>✓✓✓ تمت العملية بنجاح! ✓✓✓</h2>";
    echo "<p>النتائج:</p>";
    echo "<ul>";
    echo "<li>عدد الكليات المتبقية: <strong>{$remaining_colleges}</strong></li>";
    echo "<li>AUTO_INCREMENT الحالي: <strong>{$auto_increment}</strong></li>";
    echo "</ul>";
    
    echo "<p><a href='colleges.php' style='background:green;color:white;padding:10px 20px;text-decoration:none;border-radius:5px;'>العودة إلى صفحة الكليات</a></p>";
    
} catch (PDOException $e) {
    // إلغاء المعاملة في حالة الخطأ
    $db->getConnection()->rollBack();
    
    echo "<h2 class='error'>✗ خطأ في العملية</h2>";
    echo "<p class='error'>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<p>تم إلغاء جميع التغييرات.</p>";
    echo "<p><a href='colleges.php'>العودة إلى صفحة الكليات</a></p>";
}

echo "</body></html>";

