<?php
/**
 * سكريبت شامل للتحقق من MySQL وإعادة تعيين كلمة المرور
 * Comprehensive script to check MySQL and reset password
 */

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إعادة تعيين كلمة مرور MySQL</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .content { padding: 30px; }
        .section {
            margin: 20px 0;
            padding: 20px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            background: #f9f9f9;
        }
        .success { border-color: #4caf50; background: #f1f8f4; }
        .error { border-color: #f44336; background: #ffebee; }
        .warning { border-color: #ff9800; background: #fff3e0; }
        .info { border-color: #2196f3; background: #e3f2fd; }
        h2 { color: #667eea; margin-bottom: 15px; }
        h3 { margin: 15px 0 10px 0; }
        code {
            background: #f4f4f4;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: 'Courier New', monospace;
            color: #d63384;
            display: block;
            padding: 10px;
            margin: 10px 0;
            overflow-x: auto;
        }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin: 10px 5px;
            border: none;
            cursor: pointer;
            font-size: 16px;
        }
        .btn:hover { background: #5568d3; }
        .btn-success { background: #4caf50; }
        .btn-danger { background: #f44336; }
        ul { margin-right: 20px; }
        li { margin: 8px 0; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🔧 إعادة تعيين كلمة مرور MySQL</h1>
            <p>أداة شاملة للتحقق من MySQL وإعادة تعيين كلمة المرور</p>
        </div>
        
        <div class="content">
            <?php
            $host = 'localhost';
            $user = 'root';
            $port = 3306;
            
            // ========== 1. التحقق من حالة MySQL ==========
            echo '<div class="section info">';
            echo '<h2>1. التحقق من حالة MySQL</h2>';
            
            // محاولة الاتصال بالمنفذ
            $socket = @fsockopen($host, $port, $errno, $errstr, 2);
            if ($socket) {
                echo '<p style="color: #4caf50;">✓ MySQL يعمل على المنفذ ' . $port . '</p>';
                fclose($socket);
                $mysqlRunning = true;
            } else {
                echo '<p style="color: #f44336;">✗ MySQL غير قيد التشغيل أو غير متاح على المنفذ ' . $port . '</p>';
                echo '<p><strong>الحل:</strong></p>';
                echo '<ol>';
                echo '<li>افتح <strong>AppServ Control Panel</strong></li>';
                echo '<li>تأكد من أن MySQL يعمل (Status: Running)</li>';
                echo '<li>إذا لم يكن يعمل، اضغط <strong>Start</strong></li>';
                echo '</ol>';
                $mysqlRunning = false;
            }
            echo '</div>';
            
            if (!$mysqlRunning) {
                echo '<div class="section warning">';
                echo '<h2>⚠ تحذير</h2>';
                echo '<p>يجب تشغيل MySQL أولاً قبل المتابعة. يرجى تشغيل MySQL من AppServ Control Panel ثم تحديث هذه الصفحة.</p>';
                echo '</div>';
                echo '</div></div></body></html>';
                exit;
            }
            
            // ========== 2. محاولة الاتصال بكلمات مرور مختلفة ==========
            echo '<div class="section info">';
            echo '<h2>2. محاولة الاتصال بكلمات مرور مختلفة</h2>';
            
            $commonPasswords = ['', 'root', 'password', '123456', 'admin', 'mysql', '1234', '12345'];
            $found = false;
            $workingPassword = null;
            
            foreach ($commonPasswords as $password) {
                $displayPassword = $password === '' ? '(فارغة)' : $password;
                echo '<p>تجربة: <code>' . htmlspecialchars($displayPassword) . '</code> ... ';
                
                try {
                    $dsn = "mysql:host=$host;charset=utf8mb4";
                    $options = [
                        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                        PDO::ATTR_TIMEOUT => 2,
                    ];
                    
                    $pdo = new PDO($dsn, $user, $password, $options);
                    echo '<span style="color: #4caf50;">✓ نجح!</span></p>';
                    $found = true;
                    $workingPassword = $password;
                    break;
                } catch (PDOException $e) {
                    echo '<span style="color: #f44336;">✗ فشل</span></p>';
                }
            }
            
            if ($found) {
                echo '<div class="section success">';
                echo '<h3>✓ تم العثور على كلمة مرور صحيحة!</h3>';
                echo '<p><strong>كلمة المرور:</strong> <code>' . ($workingPassword === '' ? '(فارغة)' : htmlspecialchars($workingPassword)) . '</code></p>';
                echo '<p>قم بتحديث ملف <code>config/database.php</code>:</p>';
                echo '<code>define(\'DB_PASS\', \'' . htmlspecialchars($workingPassword) . '\');</code>';
                echo '</div>';
            } else {
                echo '<div class="section error">';
                echo '<h3>✗ لم يتم العثور على كلمة مرور صحيحة</h3>';
                echo '<p>يجب إعادة تعيين كلمة مرور MySQL.</p>';
                echo '</div>';
            }
            echo '</div>';
            
            // ========== 3. تعليمات إعادة التعيين ==========
            if (!$found) {
                echo '<div class="section warning">';
                echo '<h2>3. إعادة تعيين كلمة مرور MySQL</h2>';
                echo '<p>اتبع الخطوات التالية لإعادة تعيين كلمة مرور MySQL:</p>';
                
                echo '<h3>الطريقة 1: من AppServ Control Panel (الأسهل)</h3>';
                echo '<ol>';
                echo '<li>افتح <strong>AppServ Control Panel</strong></li>';
                echo '<li>ابحث عن خيار <strong>"MySQL Password"</strong> أو <strong>"Reset Password"</strong></li>';
                echo '<li>عيّن كلمة مرور جديدة (مثلاً: <code>root</code>)</li>';
                echo '<li>حدّث ملف <code>config/database.php</code> بالكلمة الجديدة</li>';
                echo '</ol>';
                
                echo '<h3>الطريقة 2: من سطر الأوامر (PowerShell)</h3>';
                echo '<p>انسخ الأوامر التالية في PowerShell (كمسؤول):</p>';
                echo '<code>';
                echo '# 1. أوقف MySQL من AppServ Control Panel أولاً<br>';
                echo '# 2. ثم شغّل هذه الأوامر:<br><br>';
                echo 'cd C:\\AppServ\\MySQL\\bin<br><br>';
                echo '# في نافذة PowerShell منفصلة (كمسؤول):<br>';
                echo 'Start-Process -FilePath "mysqld.exe" -ArgumentList "--skip-grant-tables" -WindowStyle Hidden<br><br>';
                echo '# انتظر 3 ثوانٍ، ثم في نافذة أخرى:<br>';
                echo 'mysql -u root<br><br>';
                echo '# في MySQL prompt:<br>';
                echo 'ALTER USER \'root\'@\'localhost\' IDENTIFIED BY \'root\';<br>';
                echo 'FLUSH PRIVILEGES;<br>';
                echo 'EXIT;<br><br>';
                echo '# أوقف MySQL (من AppServ Control Panel) وأعد تشغيله';
                echo '</code>';
                
                echo '<h3>الطريقة 3: استخدام سكريبت PowerShell</h3>';
                echo '<p>تم إنشاء ملف <code>reset_mysql_password.ps1</code> - شغّله كمسؤول</p>';
                echo '</div>';
            }
            
            // ========== 4. إنشاء سكريبت PowerShell ==========
            if (!$found) {
                $psScript = <<<'POWERSHELL'
# سكريبت لإعادة تعيين كلمة مرور MySQL في AppServ
# قم بتشغيل هذا السكريبت كمسؤول (Run as Administrator)

Write-Host "========================================" -ForegroundColor Cyan
Write-Host "إعادة تعيين كلمة مرور MySQL" -ForegroundColor Cyan
Write-Host "========================================" -ForegroundColor Cyan
Write-Host ""

# التحقق من الصلاحيات
$isAdmin = ([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole]::Administrator)
if (-not $isAdmin) {
    Write-Host "خطأ: يجب تشغيل هذا السكريبت كمسؤول!" -ForegroundColor Red
    Write-Host "انقر بزر الماوس الأيمن واختر 'Run as Administrator'" -ForegroundColor Yellow
    pause
    exit
}

# المسار الافتراضي لـ AppServ
$mysqlPath = "C:\AppServ\MySQL\bin"
if (-not (Test-Path $mysqlPath)) {
    Write-Host "خطأ: لم يتم العثور على MySQL في: $mysqlPath" -ForegroundColor Red
    Write-Host "يرجى تحديث المسار في السكريبت" -ForegroundColor Yellow
    pause
    exit
}

Write-Host "1. يرجى إيقاف MySQL من AppServ Control Panel أولاً" -ForegroundColor Yellow
Write-Host "   اضغط Enter بعد إيقاف MySQL..." -ForegroundColor Yellow
Read-Host

Write-Host ""
Write-Host "2. بدء MySQL في وضع safe mode..." -ForegroundColor Cyan
$mysqlProcess = Start-Process -FilePath "$mysqlPath\mysqld.exe" -ArgumentList "--skip-grant-tables" -WindowStyle Hidden -PassThru

Write-Host "   انتظر 5 ثوانٍ..." -ForegroundColor Yellow
Start-Sleep -Seconds 5

Write-Host ""
Write-Host "3. إعادة تعيين كلمة المرور..." -ForegroundColor Cyan

# كلمة المرور الجديدة
$newPassword = "root"

# إنشاء ملف SQL مؤقت
$sqlFile = "$env:TEMP\reset_password.sql"
@"
ALTER USER 'root'@'localhost' IDENTIFIED BY '$newPassword';
FLUSH PRIVILEGES;
EXIT;
"@ | Out-File -FilePath $sqlFile -Encoding UTF8

# تنفيذ الأوامر
$process = Start-Process -FilePath "$mysqlPath\mysql.exe" -ArgumentList "-u", "root" -RedirectStandardInput $sqlFile -Wait -NoNewWindow -PassThru

if ($process.ExitCode -eq 0) {
    Write-Host "   ✓ تم إعادة تعيين كلمة المرور بنجاح!" -ForegroundColor Green
    Write-Host "   كلمة المرور الجديدة: $newPassword" -ForegroundColor Green
} else {
    Write-Host "   ✗ فشل إعادة تعيين كلمة المرور" -ForegroundColor Red
}

# حذف الملف المؤقت
Remove-Item $sqlFile -ErrorAction SilentlyContinue

# إيقاف MySQL
Write-Host ""
Write-Host "4. إيقاف MySQL..." -ForegroundColor Cyan
Stop-Process -Id $mysqlProcess.Id -Force -ErrorAction SilentlyContinue

Write-Host ""
Write-Host "========================================" -ForegroundColor Cyan
Write-Host "تم الانتهاء!" -ForegroundColor Green
Write-Host "الآن:" -ForegroundColor Yellow
Write-Host "1. أعد تشغيل MySQL من AppServ Control Panel" -ForegroundColor Yellow
Write-Host "2. حدّث config/database.php: define('DB_PASS', 'root');" -ForegroundColor Yellow
Write-Host "========================================" -ForegroundColor Cyan
Write-Host ""
pause

POWERSHELL;
                
                file_put_contents(__DIR__ . '/reset_mysql_password.ps1', $psScript);
                
                echo '<div class="section info">';
                echo '<h2>4. سكريبت PowerShell جاهز</h2>';
                echo '<p>تم إنشاء ملف <code>reset_mysql_password.ps1</code> في مجلد المشروع.</p>';
                echo '<p><strong>كيفية الاستخدام:</strong></p>';
                echo '<ol>';
                echo '<li>انقر بزر الماوس الأيمن على <code>reset_mysql_password.ps1</code></li>';
                echo '<li>اختر <strong>"Run with PowerShell"</strong> أو <strong>"Run as Administrator"</strong></li>';
                echo '<li>اتبع التعليمات على الشاشة</li>';
                echo '</ol>';
                echo '<p><strong>ملاحظة:</strong> قد تحتاج إلى تغيير سياسة PowerShell:</p>';
                echo '<code>Set-ExecutionPolicy -ExecutionPolicy RemoteSigned -Scope CurrentUser</code>';
                echo '</div>';
            }
            
            // ========== 5. تعليمات phpMyAdmin ==========
            echo '<div class="section info">';
            echo '<h2>5. التحقق من phpMyAdmin</h2>';
            echo '<p>يمكنك أيضاً التحقق من كلمة المرور من phpMyAdmin:</p>';
            echo '<ol>';
            echo '<li>افتح: <a href="http://localhost/phpmyadmin" target="_blank">http://localhost/phpmyadmin</a></li>';
            echo '<li>جرب تسجيل الدخول بكلمات مرور مختلفة</li>';
            echo '<li>الكلمة التي تنجح هي الصحيحة</li>';
            echo '</ol>';
            echo '</div>';
            ?>
            
            <div class="section">
                <h2>الخطوات التالية</h2>
                <p>بعد إعادة تعيين كلمة المرور:</p>
                <ol>
                    <li>حدّث ملف <code>config/database.php</code> بكلمة المرور الجديدة</li>
                    <li>اختبر الاتصال: <a href="test_student_registration.php">test_student_registration.php</a></li>
                    <li>تأكد من وجود قاعدة البيانات <code>university_results</code></li>
                </ol>
            </div>
        </div>
    </div>
</body>
</html>

