# سكريبت لإعادة تعيين كلمة مرور MySQL في AppServ
# قم بتشغيل هذا السكريبت كمسؤول (Run as Administrator)

Write-Host "========================================" -ForegroundColor Cyan
Write-Host "إعادة تعيين كلمة مرور MySQL" -ForegroundColor Cyan
Write-Host "========================================" -ForegroundColor Cyan
Write-Host ""

# التحقق من الصلاحيات
$isAdmin = ([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole]::Administrator)
if (-not $isAdmin) {
    Write-Host "خطأ: يجب تشغيل هذا السكريبت كمسؤول!" -ForegroundColor Red
    Write-Host "انقر بزر الماوس الأيمن واختر 'Run as Administrator'" -ForegroundColor Yellow
    pause
    exit
}

# المسار الافتراضي لـ AppServ
$mysqlPath = "C:\AppServ\MySQL\bin"
if (-not (Test-Path $mysqlPath)) {
    Write-Host "خطأ: لم يتم العثور على MySQL في: $mysqlPath" -ForegroundColor Red
    Write-Host "يرجى تحديث المسار في السكريبت" -ForegroundColor Yellow
    pause
    exit
}

Write-Host "1. يرجى إيقاف MySQL من AppServ Control Panel أولاً" -ForegroundColor Yellow
Write-Host "   اضغط Enter بعد إيقاف MySQL..." -ForegroundColor Yellow
Read-Host

Write-Host ""
Write-Host "2. بدء MySQL في وضع safe mode..." -ForegroundColor Cyan
$mysqlProcess = Start-Process -FilePath "$mysqlPath\mysqld.exe" -ArgumentList "--skip-grant-tables" -WindowStyle Hidden -PassThru

Write-Host "   انتظر 5 ثوانٍ..." -ForegroundColor Yellow
Start-Sleep -Seconds 5

Write-Host ""
Write-Host "3. إعادة تعيين كلمة المرور..." -ForegroundColor Cyan

# كلمة المرور الجديدة
$newPassword = "root"

# إنشاء ملف SQL مؤقت
$sqlFile = "$env:TEMP\reset_password.sql"
@"
ALTER USER 'root'@'localhost' IDENTIFIED BY '$newPassword';
FLUSH PRIVILEGES;
EXIT;
"@ | Out-File -FilePath $sqlFile -Encoding UTF8

# تنفيذ الأوامر
$process = Start-Process -FilePath "$mysqlPath\mysql.exe" -ArgumentList "-u", "root" -RedirectStandardInput $sqlFile -Wait -NoNewWindow -PassThru

if ($process.ExitCode -eq 0) {
    Write-Host "   ✓ تم إعادة تعيين كلمة المرور بنجاح!" -ForegroundColor Green
    Write-Host "   كلمة المرور الجديدة: $newPassword" -ForegroundColor Green
} else {
    Write-Host "   ✗ فشل إعادة تعيين كلمة المرور" -ForegroundColor Red
}

# حذف الملف المؤقت
Remove-Item $sqlFile -ErrorAction SilentlyContinue

# إيقاف MySQL
Write-Host ""
Write-Host "4. إيقاف MySQL..." -ForegroundColor Cyan
Stop-Process -Id $mysqlProcess.Id -Force -ErrorAction SilentlyContinue

Write-Host ""
Write-Host "========================================" -ForegroundColor Cyan
Write-Host "تم الانتهاء!" -ForegroundColor Green
Write-Host "الآن:" -ForegroundColor Yellow
Write-Host "1. أعد تشغيل MySQL من AppServ Control Panel" -ForegroundColor Yellow
Write-Host "2. حدّث config/database.php: define('DB_PASS', 'root');" -ForegroundColor Yellow
Write-Host "========================================" -ForegroundColor Cyan
Write-Host ""
pause
