<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || (!$auth->hasRole('admin') && !$auth->hasRole('college_admin'))) {
    header('Location: index.php');
    exit;
}

$db = Database::getInstance();
$major_id = isset($_GET['major_id']) ? (int)$_GET['major_id'] : 0;
$message = '';

// فحص وإصلاح AUTO_INCREMENT إذا لزم الأمر
try {
    // التحقق من وجود سجل ب id=0 وحذفه
    $zero_record = $db->fetchOne("SELECT id FROM semesters WHERE id = 0");
    if ($zero_record) {
        $db->query("DELETE FROM semesters WHERE id = 0");
    }
    
    // التحقق من أن حقل id لديه خاصية AUTO_INCREMENT
    $columns = $db->fetchAll("SHOW COLUMNS FROM semesters WHERE Field = 'id'");
    $has_auto_increment = false;
    if (!empty($columns)) {
        $has_auto_increment = (strpos($columns[0]['Extra'], 'auto_increment') !== false);
    }
    
    // إذا لم يكن لديه AUTO_INCREMENT، قم بإضافته
    if (!$has_auto_increment) {
        // جلب أعلى ID موجود
        $max_id_result = $db->fetchOne("SELECT MAX(id) as max_id FROM semesters WHERE id > 0");
        $max_id = $max_id_result['max_id'] ?? 0;
        $new_auto_increment = max($max_id + 1, 1);
        
        // إضافة AUTO_INCREMENT للحقل
        $db->getConnection()->exec("ALTER TABLE semesters MODIFY id INT(11) NOT NULL AUTO_INCREMENT");
        $db->getConnection()->exec("ALTER TABLE semesters AUTO_INCREMENT = " . (int)$new_auto_increment);
    } else {
        // التحقق من أن AUTO_INCREMENT مضبوط بشكل صحيح
        $status = $db->fetchOne("SHOW TABLE STATUS LIKE 'semesters'");
        $auto_increment = $status['Auto_increment'] ?? null;
        $max_id_result = $db->fetchOne("SELECT MAX(id) as max_id FROM semesters WHERE id > 0");
        $max_id = $max_id_result['max_id'] ?? 0;
        
        // إذا كان AUTO_INCREMENT أقل من أو يساوي أعلى ID موجود، قم بتحديثه
        if ($auto_increment !== null && $auto_increment <= $max_id) {
            $new_auto_increment = max($max_id + 1, 1);
            $db->getConnection()->exec("ALTER TABLE semesters AUTO_INCREMENT = " . (int)$new_auto_increment);
        }
    }
} catch (PDOException $e) {
    // تجاهل الأخطاء في الفحص الاستباقي
    error_log("Auto-increment check error: " . $e->getMessage());
}

if (!$major_id) {
    header('Location: majors.php');
    exit;
}

// التحقق من الصلاحية
$major = $db->fetchOne("SELECT m.*, c.id as college_id, c.specialization_year FROM majors m JOIN colleges c ON m.college_id = c.id WHERE m.id = ?", [$major_id]);
if (!$major || (!$auth->belongsToCollege($major['college_id']) && !$auth->hasRole('admin'))) {
    header('Location: majors.php');
    exit;
}
$is_general_major = !empty($major['is_general']);
if (!isset($major['is_general'])) {
    $major['is_general'] = 0;
}

// معالجة الإضافة
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add') {
    $semester_number = (int)($_POST['semester_number'] ?? 0);
    $academic_year = trim($_POST['academic_year'] ?? '');
    $start_date = !empty($_POST['start_date']) ? $_POST['start_date'] : null;
    $end_date = !empty($_POST['end_date']) ? $_POST['end_date'] : null;
    
    if ($semester_number && $academic_year) {
        try {
            // التحقق من تكرار الفصل الدراسي (major_id + semester_number + academic_year)
            $existing_semester = $db->fetchOne(
                "SELECT * FROM semesters WHERE major_id = ? AND semester_number = ? AND academic_year = ?",
                [$major_id, $semester_number, $academic_year]
            );
            
            if ($existing_semester) {
                $message = '<div class="alert alert-error">الفصل الدراسي موجود مسبقاً (الفصل: ' . $semester_number . ', السنة: ' . htmlspecialchars($academic_year) . ', ID: ' . $existing_semester['id'] . ')</div>';
            } else {
                // التأكد من عدم وجود سجل ب id=0 قبل الإدراج
                $zero_record = $db->fetchOne("SELECT id FROM semesters WHERE id = 0");
                if ($zero_record) {
                    $db->query("DELETE FROM semesters WHERE id = 0");
                }
                
                // التأكد من أن AUTO_INCREMENT يعمل بشكل صحيح
                $columns = $db->fetchAll("SHOW COLUMNS FROM semesters WHERE Field = 'id'");
                $has_auto_increment = false;
                if (!empty($columns)) {
                    $has_auto_increment = (strpos($columns[0]['Extra'], 'auto_increment') !== false);
                }
                
                if (!$has_auto_increment) {
                    // إضافة AUTO_INCREMENT إذا لم يكن موجوداً
                    $max_id_result = $db->fetchOne("SELECT MAX(id) as max_id FROM semesters WHERE id > 0");
                    $max_id = $max_id_result['max_id'] ?? 0;
                    $new_auto_increment = max($max_id + 1, 1);
                    $db->getConnection()->exec("ALTER TABLE semesters MODIFY id INT(11) NOT NULL AUTO_INCREMENT");
                    $db->getConnection()->exec("ALTER TABLE semesters AUTO_INCREMENT = " . (int)$new_auto_increment);
                }
                
                // إدراج الفصل الدراسي (بدون تحديد id ليتم توليده تلقائياً)
                $db->query(
                    "INSERT INTO semesters (major_id, semester_number, academic_year, start_date, end_date) 
                     VALUES (?, ?, ?, ?, ?)",
                    [$major_id, $semester_number, $academic_year, $start_date, $end_date]
                );
                
                // الحصول على ID المولّد تلقائياً
                $new_id = $db->getConnection()->lastInsertId();
                
                // إذا كان ID = 0 أو false، فهناك مشكلة، يجب إصلاحها
                if ($new_id == 0 || $new_id === false || $new_id === '0') {
                    // حذف أي سجل ب id=0
                    $db->query("DELETE FROM semesters WHERE id = 0");
                    
                    // جلب أعلى ID موجود
                    $max_id_result = $db->fetchOne("SELECT MAX(id) as max_id FROM semesters WHERE id > 0");
                    $max_id = $max_id_result['max_id'] ?? 0;
                    $new_auto_increment = max($max_id + 1, 1);
                    
                    // إصلاح AUTO_INCREMENT
                    $db->getConnection()->exec("ALTER TABLE semesters MODIFY id INT(11) NOT NULL AUTO_INCREMENT");
                    $db->getConnection()->exec("ALTER TABLE semesters AUTO_INCREMENT = " . (int)$new_auto_increment);
                    
                    // إعادة إدراج السجل
                    $db->query(
                        "INSERT INTO semesters (major_id, semester_number, academic_year, start_date, end_date) 
                         VALUES (?, ?, ?, ?, ?)",
                        [$major_id, $semester_number, $academic_year, $start_date, $end_date]
                    );
                    $new_id = $db->getConnection()->lastInsertId();
                    
                    // التحقق مرة أخرى
                    if ($new_id == 0 || $new_id === false || $new_id === '0') {
                        throw new Exception("فشل في توليد ID تلقائياً. يرجى التحقق من إعدادات قاعدة البيانات.");
                    }
                }
                
                header('Location: semesters.php?major_id=' . $major_id);
                exit;
            }
        } catch (PDOException $e) {
            $message = '<div class="alert alert-error">خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
        } catch (Exception $e) {
            $message = '<div class="alert alert-error">خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
        }
    } else {
        $message = '<div class="alert alert-error">يرجى ملء جميع الحقول المطلوبة</div>';
    }
}

// جلب الفصول
$semesters = $db->fetchAll(
    "SELECT s.*, m.name_ar as major_name 
     FROM semesters s 
     JOIN majors m ON s.major_id = m.id 
     WHERE s.major_id = ?
     ORDER BY s.id DESC, s.academic_year, s.semester_number",
    [$major_id]
);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة الفصول الدراسية</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h2>إدارة الفصول الدراسية - <?php echo htmlspecialchars($major['name_ar']); ?><?php if ($is_general_major): ?> <span style="font-size:0.85em; color:#11998e;">(فصول عامة قبل التشعيب - مشتركة لجميع التخصصات)</span><?php endif; ?></h2>
            <div>
                <a href="create_next_semester.php" class="btn btn-success">🔄 إنشاء فصل جديد تلقائياً</a>
                <a href="transfer_semester_content.php" class="btn btn-info" style="margin-right:8px;">📦 نقل محتوى فصل إلى فصل آخر</a>
                <a href="majors.php?college_id=<?php echo $major['college_id']; ?>" class="btn btn-secondary">العودة للتخصصات</a>
                <a href="add_semesters_bulk.php?major_id=<?php echo $major_id; ?>&college_id=<?php echo $major['college_id']; ?>" class="btn btn-primary" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; margin-left: 10px;">➕ إضافة فصول دفعة واحدة</a>
                <button onclick="document.getElementById('addForm').style.display='block'" class="btn btn-primary">إضافة فصل</button>
            </div>
        </div>
        
        <?php echo $message; ?>
        
        <div id="addForm" class="card" style="display:none; margin-bottom: 20px;">
            <div class="card-header">
                <h3>إضافة فصل دراسي جديد</h3>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="add">
                <div class="form-group">
                    <label>رقم الفصل</label>
                    <input type="number" name="semester_number" min="1" max="<?php echo $major['total_semesters']; ?>" required>
                </div>
                <div class="form-group">
                    <label>السنة الدراسية (مثال: 2024-2025)</label>
                    <input type="text" name="academic_year" placeholder="2024-2025" required>
                </div>
                <div class="form-group">
                    <label>تاريخ البدء</label>
                    <input type="date" name="start_date">
                </div>
                <div class="form-group">
                    <label>تاريخ الانتهاء</label>
                    <input type="date" name="end_date">
                </div>
                <button type="submit" class="btn btn-success">إضافة</button>
                <button type="button" onclick="document.getElementById('addForm').style.display='none'" class="btn btn-secondary">إلغاء</button>
            </form>
        </div>
        
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>رقم الفصل</th>
                        <th>السنة الدراسية</th>
                        <th>تاريخ البدء</th>
                        <th>تاريخ الانتهاء</th>
                        <th>الحالة</th>
                        <th>الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($semesters as $semester): ?>
                        <tr>
                            <td><strong><?php echo $semester['id']; ?></strong></td>
                            <td><?php echo $semester['semester_number']; ?></td>
                            <td><?php echo htmlspecialchars($semester['academic_year']); ?></td>
                            <td><?php echo $semester['start_date'] ? date('Y-m-d', strtotime($semester['start_date'])) : '-'; ?></td>
                            <td><?php echo $semester['end_date'] ? date('Y-m-d', strtotime($semester['end_date'])) : '-'; ?></td>
                            <td><?php echo $semester['is_active'] ? 'نشط' : 'غير نشط'; ?></td>
                            <td>
                                <a href="courses.php?semester_id=<?php echo $semester['id']; ?>" class="btn btn-primary">المواد</a>
                                <a href="grades.php?semester_id=<?php echo $semester['id']; ?>" class="btn btn-success">الدرجات</a>
                                <a href="attendance.php?college_id=<?php echo (int)$major['college_id']; ?>&major_id=<?php echo $major_id; ?>&semester_number=<?php echo (int)$semester['semester_number']; ?>&academic_year=<?php echo urlencode($semester['academic_year']); ?>" class="btn btn-info">الحضور</a>
                                <a href="semester_results.php?semester_id=<?php echo $semester['id']; ?>" class="btn btn-secondary">النتائج</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>

