<?php
/**
 * حل بسيط وقوي لإصلاح جدول الكليات
 * يحذف السجل ب ID = 0 ويصلح AUTO_INCREMENT
 */

require_once __DIR__ . '/config/config.php';

$db = Database::getInstance();

echo "<!DOCTYPE html><html lang='ar' dir='rtl'><head><meta charset='UTF-8'><title>إصلاح بسيط لجدول الكليات</title>";
echo "<style>body{font-family:Arial;padding:20px;direction:rtl;max-width:800px;margin:0 auto;} .success{color:green;font-weight:bold;background:#d4edda;padding:15px;border-radius:5px;margin:10px 0;} .error{color:red;font-weight:bold;background:#f8d7da;padding:15px;border-radius:5px;margin:10px 0;} .info{color:blue;background:#d1ecf1;padding:15px;border-radius:5px;margin:10px 0;} a{display:inline-block;padding:10px 20px;text-decoration:none;border-radius:5px;margin:5px;background:#007bff;color:white;}</style></head><body>";
echo "<h1>🔧 إصلاح بسيط لجدول الكليات</h1>";

try {
    echo "<div class='info'>جاري فحص وإصلاح جدول الكليات...</div>";
    
    // 1. فحص السجل ب ID = 0
    $zero_college = $db->fetchOne("SELECT * FROM colleges WHERE id = 0");
    
    // 2. فحص AUTO_INCREMENT
    $status = $db->fetchOne("SHOW TABLE STATUS LIKE 'colleges'");
    $current_auto = $status['Auto_increment'] ?? null;
    
    echo "<h2>الخطوة 1: فحص المشاكل</h2>";
    echo "<ul>";
    echo "<li>السجل ب ID = 0: " . ($zero_college ? "⚠️ موجود (الرمز: " . htmlspecialchars($zero_college['code']) . ")" : "✓ غير موجود") . "</li>";
    echo "<li>AUTO_INCREMENT: " . ($current_auto === null || $current_auto == 0 ? "⚠️ NULL أو 0" : "✓ " . $current_auto) . "</li>";
    echo "</ul>";
    
    // 3. الإصلاح
    if ($zero_college || $current_auto === null || $current_auto == 0) {
        echo "<h2>الخطوة 2: بدء الإصلاح</h2>";
        
        // بدء المعاملة
        $db->getConnection()->beginTransaction();
        
        try {
            // حذف السجل ب ID = 0 مباشرة (لأنه يسبب المشاكل)
            if ($zero_college) {
                echo "<p>🗑️ حذف السجل ب ID = 0...</p>";
                
                // حذف السجلات المرتبطة أولاً (إذا كانت موجودة)
                try {
                    $db->query("DELETE FROM majors WHERE college_id = 0");
                    echo "<p class='success'>✓ تم حذف التخصصات المرتبطة</p>";
                } catch (PDOException $e) {
                    // تجاهل الخطأ إذا لم تكن هناك سجلات
                }
                
                try {
                    $db->query("DELETE FROM users WHERE college_id = 0");
                    echo "<p class='success'>✓ تم حذف المستخدمين المرتبطين</p>";
                } catch (PDOException $e) {
                    // تجاهل الخطأ إذا لم تكن هناك سجلات
                }
                
                try {
                    $db->query("DELETE FROM students WHERE college_id = 0");
                    echo "<p class='success'>✓ تم حذف الطلاب المرتبطين</p>";
                } catch (PDOException $e) {
                    // تجاهل الخطأ إذا لم تكن هناك سجلات
                }
                
                // حذف السجل ب ID = 0
                $db->query("DELETE FROM colleges WHERE id = 0");
                echo "<p class='success'>✓ تم حذف السجل ب ID = 0</p>";
            }
            
            // إصلاح AUTO_INCREMENT
            echo "<p>🔧 إصلاح AUTO_INCREMENT...</p>";
            $max_id = $db->fetchOne("SELECT MAX(id) as max_id FROM colleges WHERE id > 0");
            $new_auto = max(($max_id['max_id'] ?? 0) + 1, 1);
            $db->getConnection()->exec("ALTER TABLE colleges AUTO_INCREMENT = " . (int)$new_auto);
            echo "<p class='success'>✓ تم تعيين AUTO_INCREMENT إلى {$new_auto}</p>";
            
            // تأكيد المعاملة
            $db->getConnection()->commit();
            
            // التحقق النهائي
            echo "<h2>الخطوة 3: التحقق النهائي</h2>";
            $status_after = $db->fetchOne("SHOW TABLE STATUS LIKE 'colleges'");
            $auto_after = $status_after['Auto_increment'] ?? null;
            $zero_check = $db->fetchOne("SELECT id FROM colleges WHERE id = 0");
            $all_colleges = $db->fetchAll("SELECT id, name_ar, code FROM colleges ORDER BY id");
            
            echo "<ul>";
            echo "<li>AUTO_INCREMENT: <strong>" . ($auto_after ?? 'NULL') . "</strong></li>";
            echo "<li>السجل ب ID = 0: " . ($zero_check ? "⚠️ لا يزال موجوداً" : "✓ تم حذفه") . "</li>";
            echo "<li>عدد الكليات: <strong>" . count($all_colleges) . "</strong></li>";
            echo "</ul>";
            
            if (!empty($all_colleges)) {
                echo "<p><strong>الكليات الموجودة:</strong></p><ul>";
                foreach ($all_colleges as $col) {
                    echo "<li>ID: {$col['id']} - " . htmlspecialchars($col['name_ar']) . " (" . htmlspecialchars($col['code']) . ")</li>";
                }
                echo "</ul>";
            } else {
                echo "<p class='info'>لا توجد كليات في النظام. يمكنك الآن إضافة كليات جديدة.</p>";
            }
            
            echo "<div class='success'>";
            echo "<h2>✅ تم الإصلاح بنجاح!</h2>";
            echo "<p>يمكنك الآن:</p>";
            echo "<ul>";
            echo "<li>إضافة كليات جديدة من صفحة الكليات</li>";
            echo "<li>استخدام النظام بشكل طبيعي</li>";
            echo "</ul>";
            echo "</div>";
            
            echo "<p><a href='colleges.php' style='background:green;'>العودة إلى صفحة الكليات</a></p>";
            
        } catch (PDOException $e) {
            $db->getConnection()->rollBack();
            throw $e;
        }
    } else {
        echo "<div class='success'>";
        echo "<h2>✅ لا توجد مشاكل!</h2>";
        echo "<p>جدول الكليات في حالة جيدة. لا حاجة للإصلاح.</p>";
        echo "</div>";
        echo "<p><a href='colleges.php' style='background:blue;'>العودة إلى صفحة الكليات</a></p>";
    }
    
} catch (PDOException $e) {
    echo "<div class='error'>";
    echo "<h2>❌ خطأ في الإصلاح</h2>";
    echo "<p>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<p>تفاصيل الخطأ:</p>";
    echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
    echo "</div>";
    echo "<p><a href='diagnose_colleges.php' style='background:orange;'>فتح صفحة التشخيص</a></p>";
}

echo "</body></html>";

