<?php
/**
 * اختبار وصول الملفات
 * Test file access
 */

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>اختبار وصول الملفات</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; background: #f5f5f5; }
        .test { background: white; padding: 15px; margin: 10px 0; border-radius: 5px; border-right: 4px solid #ddd; }
        .success { border-right-color: #4caf50; background: #f1f8f4; }
        .error { border-right-color: #f44336; background: #ffebee; }
        a { color: #667eea; text-decoration: none; margin: 5px; display: inline-block; padding: 8px 15px; background: #e3f2fd; border-radius: 3px; }
        a:hover { background: #bbdefb; }
    </style>
</head>
<body>
    <h1>🔍 اختبار وصول الملفات</h1>
    
    <div class="test success">
        <h2>✓ هذه الصفحة تعمل!</h2>
        <p>إذا رأيت هذه الصفحة، فملفات PHP تعمل بشكل صحيح.</p>
    </div>
    
    <div class="test">
        <h2>اختبار الوصول للملفات:</h2>
        <p>انقر على الروابط التالية للتحقق من عمل الملفات:</p>
        
        <h3>الصفحات الرئيسية:</h3>
        <a href="index.php" target="_blank">index.php (تسجيل الدخول)</a>
        <a href="dashboard.php" target="_blank">dashboard.php (لوحة التحكم)</a>
        <a href="students.php" target="_blank">students.php (تسجيل الطلاب)</a>
        
        <h3>صفحات الاختبار:</h3>
        <a href="test.php" target="_blank">test.php</a>
        <a href="test_student_registration.php" target="_blank">test_student_registration.php</a>
        <a href="debug_students.php" target="_blank">debug_students.php</a>
        <a href="test_mysql_connection.php" target="_blank">test_mysql_connection.php</a>
        
        <h3>أدوات المساعدة:</h3>
        <a href="auto_reset_password.php" target="_blank">auto_reset_password.php</a>
        <a href="reset_mysql_password.php" target="_blank">reset_mysql_password.php</a>
    </div>
    
    <div class="test">
        <h2>معلومات الخادم:</h2>
        <p><strong>المسار الحالي:</strong> <code><?php echo __DIR__; ?></code></p>
        <p><strong>الملف الحالي:</strong> <code><?php echo __FILE__; ?></code></p>
        <p><strong>REQUEST_URI:</strong> <code><?php echo $_SERVER['REQUEST_URI'] ?? 'غير محدد'; ?></code></p>
        <p><strong>SCRIPT_NAME:</strong> <code><?php echo $_SERVER['SCRIPT_NAME'] ?? 'غير محدد'; ?></code></p>
    </div>
    
    <div class="test">
        <h2>إذا كانت الصفحات لا تعمل:</h2>
        <ol>
            <li><strong>تحقق من المسار:</strong> تأكد من أنك تفتح <code>http://localhost/GUNS/students.php</code></li>
            <li><strong>تحقق من .htaccess:</strong> إذا استمرت المشكلة، أعد تسمية <code>.htaccess</code> إلى <code>.htaccess.backup</code> مؤقتاً</li>
            <li><strong>تحقق من Apache:</strong> تأكد من أن Apache يعمل من AppServ Control Panel</li>
            <li><strong>تحقق من mod_rewrite:</strong> تأكد من تفعيل mod_rewrite في Apache</li>
        </ol>
    </div>
</body>
</html>

