<?php
/**
 * رفع صورة الطالب
 * Upload Student Photo
 */

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    header('Location: index.php');
    exit;
}

$db = Database::getInstance();

$student_id = isset($_GET['student_id']) ? (int)$_GET['student_id'] : 0;

// التحقق من الصلاحيات
if (!$auth->canAccessStudent($student_id) && !$auth->hasRole('admin')) {
    header('Location: dashboard.php');
    exit;
}

// جلب معلومات الطالب
$student = $db->fetchOne(
    "SELECT * FROM students WHERE id = ?",
    [$student_id]
);

if (!$student) {
    header('Location: students.php');
    exit;
}

// التحقق من وجود حقل photo_path في جدول students
try {
    $db->query("SELECT photo_path FROM students LIMIT 1");
} catch (Exception $e) {
    // إضافة الحقل إذا لم يكن موجوداً
    try {
        $db->query("ALTER TABLE students ADD COLUMN photo_path VARCHAR(255) NULL AFTER graduation_date");
    } catch (Exception $e2) {
        // تجاهل الخطأ إذا كان الحقل موجوداً بالفعل
    }
}

$message = '';
$message_type = '';

// معالجة رفع الصورة
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['photo'])) {
    $upload_dir = __DIR__ . '/uploads/students/';
    
    // إنشاء المجلد إذا لم يكن موجوداً
    if (!file_exists($upload_dir)) {
        @mkdir($upload_dir, 0777, true);
    }
    
    $file = $_FILES['photo'];
    
    // التحقق من وجود ملف
    if ($file['error'] === UPLOAD_ERR_OK) {
        // التحقق من نوع الملف
        $allowed_types = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif'];
        $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif'];
        
        // محاولة الحصول على نوع MIME بطريقة آمنة
        $file_type = null;
        
        // الطريقة 1: استخدام finfo_file (الأفضل والأكثر أماناً)
        if (function_exists('finfo_open')) {
            $finfo = finfo_open(FILEINFO_MIME_TYPE);
            if ($finfo) {
                $file_type = finfo_file($finfo, $file['tmp_name']);
                finfo_close($finfo);
            }
        }
        
        // الطريقة 2: استخدام mime_content_type (إذا كان متاحاً)
        if (!$file_type && function_exists('mime_content_type')) {
            $file_type = mime_content_type($file['tmp_name']);
        }
        
        // الطريقة 3: التحقق من الامتداد كبديل
        $extension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        $extension_valid = in_array($extension, $allowed_extensions);
        
        // التحقق من نوع MIME أو الامتداد
        $file_valid = false;
        if ($file_type && in_array($file_type, $allowed_types)) {
            $file_valid = true;
        } elseif (!$file_type && $extension_valid) {
            // إذا لم نتمكن من تحديد نوع MIME لكن الامتداد صحيح، نتابع
            $file_valid = true;
        }
        
        if (!$file_valid) {
            $message = 'نوع الملف غير مدعوم. يرجى رفع صورة (JPG, PNG, GIF)';
            $message_type = 'error';
        } else {
            // التحقق من حجم الملف (5MB كحد أقصى)
            if ($file['size'] > 5 * 1024 * 1024) {
                $message = 'حجم الملف كبير جداً. الحد الأقصى 5MB';
                $message_type = 'error';
            } else {
                // إنشاء اسم فريد للملف
                $extension = pathinfo($file['name'], PATHINFO_EXTENSION);
                $filename = 'student_' . $student_id . '_' . time() . '.' . $extension;
                $file_path = $upload_dir . $filename;
                
                // حذف الصورة القديمة إذا كانت موجودة
                if (!empty($student['photo_path']) && file_exists(__DIR__ . '/' . $student['photo_path'])) {
                    @unlink(__DIR__ . '/' . $student['photo_path']);
                }
                
                // رفع الملف
                if (move_uploaded_file($file['tmp_name'], $file_path)) {
                    // حفظ المسار في قاعدة البيانات
                    $relative_path = 'uploads/students/' . $filename;
                    $db->query(
                        "UPDATE students SET photo_path = ? WHERE id = ?",
                        [$relative_path, $student_id]
                    );
                    
                    $message = 'تم رفع الصورة بنجاح';
                    $message_type = 'success';
                    
                    // تحديث معلومات الطالب
                    $student['photo_path'] = $relative_path;
                } else {
                    $message = 'فشل رفع الملف. يرجى المحاولة مرة أخرى';
                    $message_type = 'error';
                }
            }
        }
    } else {
        $error_messages = [
            UPLOAD_ERR_INI_SIZE => 'حجم الملف يتجاوز الحد المسموح به',
            UPLOAD_ERR_FORM_SIZE => 'حجم الملف يتجاوز الحد المسموح به في النموذج',
            UPLOAD_ERR_PARTIAL => 'تم رفع الملف جزئياً فقط',
            UPLOAD_ERR_NO_FILE => 'لم يتم اختيار ملف',
            UPLOAD_ERR_NO_TMP_DIR => 'مجلد مؤقت غير موجود',
            UPLOAD_ERR_CANT_WRITE => 'فشل كتابة الملف على القرص',
            UPLOAD_ERR_EXTENSION => 'تم إيقاف رفع الملف بواسطة إضافة PHP'
        ];
        
        $message = isset($error_messages[$file['error']]) ? $error_messages[$file['error']] : 'حدث خطأ أثناء رفع الملف';
        $message_type = 'error';
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>رفع صورة الطالب - نظام نتائج جامعة الشرق للعلوم والتكنولوجيا: Alsharg University of Science and Technology</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .upload-container {
            max-width: 600px;
            margin: 30px auto;
            padding: 30px;
            background: white;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .photo-preview {
            text-align: center;
            margin: 20px 0;
        }
        
        .photo-preview img {
            max-width: 200px;
            max-height: 250px;
            border: 3px solid #667eea;
            border-radius: 8px;
            padding: 5px;
            background: white;
        }
        
        .upload-form {
            margin-top: 20px;
        }
        
        .file-input-wrapper {
            position: relative;
            display: inline-block;
            width: 100%;
        }
        
        .file-input-wrapper input[type="file"] {
            width: 100%;
            padding: 10px;
            border: 2px dashed #667eea;
            border-radius: 8px;
            background: #f9f9f9;
            cursor: pointer;
        }
        
        .file-input-wrapper input[type="file"]:hover {
            background: #f0f0f0;
        }
        
        .upload-button {
            margin-top: 15px;
            width: 100%;
        }
        
        .current-photo {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h2>رفع صورة الطالب</h2>
            <a href="student_details.php?id=<?php echo $student_id; ?>" class="btn btn-secondary">العودة</a>
        </div>
        
        <?php if ($message): ?>
            <div class="alert alert-<?php echo $message_type === 'success' ? 'success' : 'error'; ?>" style="margin: 20px 0;">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>
        
        <div class="upload-container">
            <h3>الطالب: <?php echo htmlspecialchars($student['full_name_ar']); ?></h3>
            <p>الرقم الجامعي: <?php echo htmlspecialchars($student['student_number']); ?></p>
            
            <?php if (!empty($student['photo_path']) && file_exists(__DIR__ . '/' . $student['photo_path'])): ?>
                <div class="current-photo">
                    <h4>الصورة الحالية:</h4>
                    <div class="photo-preview">
                        <img src="<?php echo htmlspecialchars($student['photo_path']); ?>" alt="صورة الطالب">
                    </div>
                </div>
            <?php endif; ?>
            
            <form method="POST" enctype="multipart/form-data" class="upload-form">
                <div class="file-input-wrapper">
                    <label for="photo">اختر صورة الطالب:</label>
                    <input type="file" name="photo" id="photo" accept="image/jpeg,image/jpg,image/png,image/gif" required>
                    <small style="display: block; margin-top: 5px; color: #666;">
                        أنواع الملفات المدعومة: JPG, PNG, GIF | الحد الأقصى: 5MB
                    </small>
                </div>
                
                <div id="preview" class="photo-preview" style="display: none;">
                    <h4>معاينة الصورة:</h4>
                    <img id="preview-img" src="" alt="معاينة">
                </div>
                
                <button type="submit" class="btn btn-primary upload-button">📤 رفع الصورة</button>
            </form>
        </div>
    </div>
    
    <script>
        document.getElementById('photo').addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    document.getElementById('preview-img').src = e.target.result;
                    document.getElementById('preview').style.display = 'block';
                };
                reader.readAsDataURL(file);
            } else {
                document.getElementById('preview').style.display = 'none';
            }
        });
    </script>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>

