<?php
/**
 * رفع شعار الجامعة
 * Upload University Logo
 */

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    header('Location: index.php');
    exit;
}

// التحقق من الصلاحيات (فقط للمديرين)
if (!$auth->hasRole('admin') && !$auth->hasRole('college_admin')) {
    header('Location: dashboard.php');
    exit;
}

$db = Database::getInstance();

// إنشاء جدول settings إذا لم يكن موجوداً
try {
    $db->query("SELECT 1 FROM settings LIMIT 1");
} catch (Exception $e) {
    $db->query("CREATE TABLE IF NOT EXISTS settings (
        setting_key VARCHAR(255) PRIMARY KEY,
        setting_value TEXT,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
}

$message = '';
$message_type = '';

// جلب الشعار الحالي
$current_logo = $db->fetchOne("SELECT setting_value FROM settings WHERE setting_key = 'university_logo_path'");
$current_logo_path = $current_logo ? $current_logo['setting_value'] : null;

// معالجة رفع الشعار
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['logo'])) {
    $upload_dir = __DIR__ . '/assets/images/logo/';
    
    // إنشاء المجلد إذا لم يكن موجوداً
    if (!file_exists($upload_dir)) {
        @mkdir($upload_dir, 0777, true);
    }
    
    $file = $_FILES['logo'];
    
    // التحقق من وجود ملف
    if ($file['error'] === UPLOAD_ERR_OK) {
        // التحقق من نوع الملف
        $allowed_types = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'image/svg+xml'];
        $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif', 'svg'];
        
        // محاولة الحصول على نوع MIME بطريقة آمنة
        $file_type = null;
        
        // الطريقة 1: استخدام finfo_file (الأفضل والأكثر أماناً)
        if (function_exists('finfo_open')) {
            $finfo = finfo_open(FILEINFO_MIME_TYPE);
            if ($finfo) {
                $file_type = finfo_file($finfo, $file['tmp_name']);
                finfo_close($finfo);
            }
        }
        
        // الطريقة 2: استخدام mime_content_type (إذا كان متاحاً)
        if (!$file_type && function_exists('mime_content_type')) {
            $file_type = mime_content_type($file['tmp_name']);
        }
        
        // الطريقة 3: التحقق من الامتداد كبديل
        $extension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        $extension_valid = in_array($extension, $allowed_extensions);
        
        // التحقق من نوع MIME أو الامتداد
        if (!$file_type && !$extension_valid) {
            $message = 'نوع الملف غير مدعوم. يرجى رفع صورة (JPG, PNG, GIF, SVG)';
            $message_type = 'error';
        } elseif ($file_type && !in_array($file_type, $allowed_types) && !$extension_valid) {
            $message = 'نوع الملف غير مدعوم. يرجى رفع صورة (JPG, PNG, GIF, SVG)';
            $message_type = 'error';
        } elseif (!$file_type && $extension_valid) {
            // إذا لم نتمكن من تحديد نوع MIME لكن الامتداد صحيح، نتابع
            // هذا يعمل لكن أقل أماناً - يمكن إضافة تحقق إضافي
        } else {
            // التحقق من حجم الملف (5MB كحد أقصى)
            if ($file['size'] > 5 * 1024 * 1024) {
                $message = 'حجم الملف كبير جداً. الحد الأقصى 5MB';
                $message_type = 'error';
            } else {
                // إنشاء اسم فريد للملف
                $extension = pathinfo($file['name'], PATHINFO_EXTENSION);
                $filename = 'university_logo_' . time() . '.' . $extension;
                $file_path = $upload_dir . $filename;
                
                // حذف الشعار القديم إذا كان موجوداً
                if ($current_logo_path && file_exists(__DIR__ . '/' . $current_logo_path)) {
                    @unlink(__DIR__ . '/' . $current_logo_path);
                }
                
                // رفع الملف
                if (move_uploaded_file($file['tmp_name'], $file_path)) {
                    // حفظ المسار في قاعدة البيانات
                    $relative_path = 'assets/images/logo/' . $filename;
                    $db->query(
                        "INSERT INTO settings (setting_key, setting_value) VALUES ('university_logo_path', ?)
                         ON DUPLICATE KEY UPDATE setting_value = ?",
                        [$relative_path, $relative_path]
                    );
                    
                    $message = 'تم رفع الشعار بنجاح';
                    $message_type = 'success';
                    $current_logo_path = $relative_path;
                } else {
                    $message = 'فشل رفع الملف. يرجى المحاولة مرة أخرى';
                    $message_type = 'error';
                }
            }
        }
    } else {
        $error_messages = [
            UPLOAD_ERR_INI_SIZE => 'حجم الملف يتجاوز الحد المسموح به',
            UPLOAD_ERR_FORM_SIZE => 'حجم الملف يتجاوز الحد المسموح به في النموذج',
            UPLOAD_ERR_PARTIAL => 'تم رفع الملف جزئياً فقط',
            UPLOAD_ERR_NO_FILE => 'لم يتم اختيار ملف',
            UPLOAD_ERR_NO_TMP_DIR => 'مجلد مؤقت غير موجود',
            UPLOAD_ERR_CANT_WRITE => 'فشل كتابة الملف على القرص',
            UPLOAD_ERR_EXTENSION => 'تم إيقاف رفع الملف بواسطة إضافة PHP'
        ];
        
        $message = isset($error_messages[$file['error']]) ? $error_messages[$file['error']] : 'حدث خطأ أثناء رفع الملف';
        $message_type = 'error';
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>رفع شعار جامعة الشرق للعلوم والتكنولوجيا: Alsharg University of Science and Technology - نظام نتائج جامعة الشرق للعلوم والتكنولوجيا: Alsharg University of Science and Technology</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .upload-container {
            max-width: 600px;
            margin: 30px auto;
            padding: 30px;
            background: white;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .logo-preview {
            text-align: center;
            margin: 20px 0;
        }
        
        .logo-preview img {
            max-width: 200px;
            max-height: 200px;
            border: 3px solid #667eea;
            border-radius: 8px;
            padding: 5px;
            background: white;
        }
        
        .upload-form {
            margin-top: 20px;
        }
        
        .file-input-wrapper {
            position: relative;
            display: inline-block;
            width: 100%;
        }
        
        .file-input-wrapper input[type="file"] {
            width: 100%;
            padding: 10px;
            border: 2px dashed #667eea;
            border-radius: 8px;
            background: #f9f9f9;
            cursor: pointer;
        }
        
        .file-input-wrapper input[type="file"]:hover {
            background: #f0f0f0;
        }
        
        .upload-button {
            margin-top: 15px;
            width: 100%;
        }
        
        .current-logo {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h2>رفع شعار الجامعة</h2>
            <a href="dashboard.php" class="btn btn-secondary">العودة</a>
        </div>
        
        <?php if ($message): ?>
            <div class="alert alert-<?php echo $message_type === 'success' ? 'success' : 'error'; ?>" style="margin: 20px 0;">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>
        
        <div class="upload-container">
            <h3>شعار الجامعة</h3>
            <p>سيظهر هذا الشعار في الشهادات الجامعية</p>
            
            <?php if ($current_logo_path && file_exists(__DIR__ . '/' . $current_logo_path)): ?>
                <div class="current-logo">
                    <h4>الشعار الحالي:</h4>
                    <div class="logo-preview">
                        <img src="<?php echo htmlspecialchars($current_logo_path); ?>" alt="شعار الجامعة">
                    </div>
                </div>
            <?php endif; ?>
            
            <form method="POST" enctype="multipart/form-data" class="upload-form">
                <div class="file-input-wrapper">
                    <label for="logo">اختر شعار الجامعة:</label>
                    <input type="file" name="logo" id="logo" accept="image/jpeg,image/jpg,image/png,image/gif,image/svg+xml" required>
                    <small style="display: block; margin-top: 5px; color: #666;">
                        أنواع الملفات المدعومة: JPG, PNG, GIF, SVG | الحد الأقصى: 5MB
                    </small>
                </div>
                
                <div id="preview" class="logo-preview" style="display: none;">
                    <h4>معاينة الشعار:</h4>
                    <img id="preview-img" src="" alt="معاينة">
                </div>
                
                <button type="submit" class="btn btn-primary upload-button">📤 رفع الشعار</button>
            </form>
        </div>
    </div>
    
    <script>
        document.getElementById('logo').addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    document.getElementById('preview-img').src = e.target.result;
                    document.getElementById('preview').style.display = 'block';
                };
                reader.readAsDataURL(file);
            } else {
                document.getElementById('preview').style.display = 'none';
            }
        });
    </script>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>

