# 📘 الدليل الشامل لنظام إدارة نتائج جامعة الشرق للعلوم والتكنولوجيا: Alsharg University of Science and Technology

## 🎯 نظرة عامة

نظام شامل لإدارة نتائج الطلاب في الجامعة مع دعم متعدد الكليات والتخصصات والفصول الدراسية. يوفر النظام إدارة كاملة للطلاب، المواد، الدرجات، المعدلات، النتائج، الشهادات، والرسوم.

---

## 📑 فهرس المحتويات

1. [نظرة عامة على النظام](#نظرة-عامة-على-النظام)
2. [نظام الصلاحيات والأدوار](#نظام-الصلاحيات-والأدوار)
3. [إدارة الكليات والتخصصات](#إدارة-الكليات-والتخصصات)
4. [إدارة الفصول الدراسية](#إدارة-الفصول-الدراسية)
5. [إدارة المواد الدراسية](#إدارة-المواد-الدراسية)
6. [إدارة الطلاب](#إدارة-الطلاب)
7. [نظام التسجيل](#نظام-التسجيل)
8. [إدخال الدرجات](#إدخال-الدرجات)
9. [حساب المعدلات](#حساب-المعدلات)
10. [استخراج النتائج](#استخراج-النتائج)
11. [نشر النتائج](#نشر-النتائج)
12. [نظام الشهادات](#نظام-الشهادات)
13. [إدارة الرسوم](#إدارة-الرسوم)
14. [التقارير والإحصائيات](#التقارير-والإحصائيات)
15. [إدارة المستخدمين](#إدارة-المستخدمين)
16. [النسخ الاحتياطي](#النسخ-الاحتياطي)
17. [حل المشاكل الشائعة](#حل-المشاكل-الشائعة)

---

## 🏛️ نظرة عامة على النظام

### المميزات الرئيسية

1. **إدارة متعددة الكليات**: دعم كامل لإدارة عدة كليات وتخصصات
2. **نظام الفصول الدراسية**: إدارة فصلية منفصلة لكل فصل دراسي
3. **حساب المعدلات التلقائي**: حساب المعدل الفصلي والتراكمي تلقائياً
4. **نظام الدرجات المتقدم**: دعم الدرجات الرقمية والنصية
5. **نظام الشهادات الإلكتروني**: إصدار شهادات PDF تلقائياً
6. **الأمان والصلاحيات**: نظام صلاحيات دقيق مع عزل البيانات
7. **التقارير والإحصائيات**: تقارير شاملة عن النتائج والإحصائيات

### متطلبات التشغيل

- PHP 7.4 أو أحدث
- MySQL 5.7 أو أحدث
- Apache مع mod_rewrite
- PDO extension
- GD Library (للمعالجة الصور)

---

## 👥 نظام الصلاحيات والأدوار

### الأدوار المتاحة

#### 1. **مدير عام (Admin)**
- ✅ وصول كامل لجميع الكليات والتخصصات
- ✅ إدارة جميع المستخدمين
- ✅ إدارة الكليات والتخصصات والفصول
- ✅ إدارة الطلاب والمواد والدرجات
- ✅ إصدار الشهادات
- ✅ الوصول لسجل الأنشطة
- ✅ النسخ الاحتياطي

#### 2. **مدير كلية (College Admin)**
- ✅ إدارة التخصصات والفصول في كليته فقط
- ✅ إدارة الطلاب والمواد في كليته
- ✅ إدخال وتعديل الدرجات
- ✅ استخراج النتائج
- ✅ الموافقة على طلبات الشهادات
- ❌ لا يمكنه الوصول لكليات أخرى

#### 3. **مسجل (Registrar)**
- ✅ إضافة وإدارة الطلاب
- ✅ تسجيل الطلاب في المواد
- ✅ إدخال الدرجات
- ✅ استخراج النتائج
- ✅ إصدار الشهادات
- ✅ عرض التقارير
- ❌ لا يمكنه إدارة الكليات والتخصصات

#### 4. **أستاذ (Instructor)**
- ✅ عرض قوائم الطلاب
- ✅ إدخال الدرجات
- ✅ تعديل الدرجات
- ❌ لا يمكنه إدارة الطلاب أو المواد

#### 5. **طالب (Student)**
- ✅ عرض درجاته ومعدلاته
- ✅ طلب الشهادات
- ✅ عرض الشهادات الصادرة
- ❌ لا يمكنه الوصول لأي بيانات أخرى

### عزل البيانات

- كل مستخدم (عدا Admin) يرى فقط بيانات كليته
- لا يمكن للمستخدمين الوصول لبيانات الكليات الأخرى
- الحماية مضمونة على مستوى قاعدة البيانات

---

## 🏛️ إدارة الكليات والتخصصات

### إضافة كلية جديدة

1. **الوصول**: من الشاشة الرئيسية → **"🏛️ إدارة الكليات"**
2. **إضافة كلية**:
   - اضغط على **"إضافة كلية"**
   - أدخل:
     - **اسم الكلية (عربي)**: مطلوب
     - **اسم الكلية (إنجليزي)**: اختياري
     - **رمز الكلية**: رمز فريد (مثل: CS, ENG, MED)
     - **سنة التوزيع على التخصصات**: (اختياري)
       - **لا يوجد توزيع متأخر**: إذا كان الطلاب يتوزعون على التخصصات من البداية (القيمة الافتراضية)
       - **السنة الأولى**: إذا كان التوزيع بعد السنة الأولى
       - **السنة الثانية**: إذا كان التوزيع بعد السنة الثانية
       - **السنة الثالثة**: إذا كان التوزيع بعد السنة الثالثة
       - **السنة الرابعة**: إذا كان التوزيع بعد السنة الرابعة
       - **السنة الخامسة**: إذا كان التوزيع بعد السنة الخامسة
       - 💡 **ملاحظة**: هذا الحقل يحدد متى يتوزع طلاب الكلية على التخصصات المختلفة. بعض الكليات تبدأ بتخصص عام ثم يتوزع الطلاب في سنوات لاحقة.
   - اضغط **"إضافة"**

### إضافة تخصص جديد

1. **الوصول**: من الشاشة الرئيسية → **"📖 إدارة التخصصات"**
2. **اختيار الكلية**: اختر الكلية من القائمة
3. **إضافة تخصص**:
   - اضغط على **"إضافة تخصص"**
   - أدخل:
     - **اسم التخصص (عربي)**: مطلوب
     - **اسم التخصص (إنجليزي)**: اختياري
     - **رمز التخصص**: رمز فريد
     - **عدد الفصول الإجمالي**: عدد الفصول الدراسية (مثل: 8)
   - اضغط **"إضافة"**

### تعديل أو حذف كلية/تخصص

- اضغط على **"تعديل"** بجانب الكلية/التخصص
- في نموذج التعديل، يمكنك تغيير:
  - اسم الكلية (عربي/إنجليزي)
  - رمز الكلية
  - **سنة التوزيع على التخصصات** (يمكن تغييرها في أي وقت)
- اضغط **"تحديث"** لحفظ التغييرات
- أو اضغط **"حذف"** لحذف الكلية/التخصص
- ⚠️ **تحذير**: حذف كلية سيحذف جميع التخصصات والفصول والطلاب المرتبطين بها

### عرض سنة التوزيع

- في جدول الكليات، عمود **"سنة التوزيع على التخصصات"** يعرض:
  - **"من البداية"**: إذا لم يتم تحديد سنة توزيع
  - **"السنة X"**: إذا تم تحديد سنة التوزيع (حيث X هي 1, 2, 3, 4, أو 5)

---

## 📅 إدارة الفصول الدراسية

### إضافة فصل دراسي يدوياً

1. **الوصول**: من الشاشة الرئيسية → **"📖 إدارة التخصصات"** → اختر التخصص → **"الفصول الدراسية"**
2. **إضافة فصل**:
   - اضغط على **"إضافة فصل"**
   - أدخل:
     - **رقم الفصل**: من 1 إلى العدد الإجمالي للفصول
     - **السنة الدراسية**: بصيغة `YYYY-YYYY` (مثل: `2024-2025`)
     - **تاريخ البدء**: اختياري
     - **تاريخ الانتهاء**: اختياري
   - اضغط **"إضافة"**

### إنشاء فصل دراسي جديد تلقائياً

1. **الوصول**: من الشاشة الرئيسية → **"🔄 إنشاء فصل جديد تلقائياً"**
2. **اختيار الفصل السابق**:
   - اختر الكلية والتخصص
   - اختر الفصل الدراسي السابق
3. **تحديد بيانات الفصل الجديد**:
   - رقم الفصل الجديد
   - السنة الدراسية الجديدة
   - التواريخ (اختياري)
4. **النتيجة**:
   - يتم إنشاء الفصل الجديد
   - نسخ المواد من الفصل السابق
   - تسجيل الطلاب الناجحين والعائدين تلقائياً

### عرض وإدارة الفصول

- من صفحة الفصول يمكنك:
  - عرض قائمة الفصول
  - الوصول إلى **"المواد"** لإدارة مواد الفصل
  - الوصول إلى **"الدرجات"** لإدخال الدرجات
  - الوصول إلى **"النتائج"** لعرض نتائج الفصل

---

## 📚 إدارة المواد الدراسية

### إضافة مادة جديدة

1. **الوصول**: من صفحة الفصول → **"المواد"** أو من الشاشة الرئيسية → **"📚 إدارة المواد"**
2. **إضافة مادة**:
   - اضغط على **"إضافة مادة"**
   - أدخل:
     - **رمز المادة**: رمز فريد (مثل: CS101, MATH201)
     - **اسم المادة (عربي)**: مطلوب
     - **اسم المادة (إنجليزي)**: اختياري
     - **الساعات المعتمدة**: عدد الساعات (مثل: 3, 4)
     - **الفصل الدراسي**: اختر الفصل أو اتركه "جميع الفصول"
     - **مادة إجبارية**: حدد إذا كانت إجبارية
   - اضغط **"إضافة"**

### تعديل أو حذف مادة

- اضغط على **"تعديل"** أو **"حذف"** بجانب المادة
- ⚠️ **تحذير**: لا يمكن حذف مادة إذا كان هناك طلاب مسجلين فيها أو درجات مرتبطة بها

### الفلترة والبحث

- يمكنك فلترة المواد حسب:
  - الكلية
  - التخصص
  - الفصل الدراسي
  - السنة الدراسية
- يمكنك البحث بالاسم أو الرمز

---

## 👥 إدارة الطلاب

### إضافة طالب واحد يدوياً

1. **الوصول**: من الشاشة الرئيسية → **"👥 إدارة الطلاب"**
2. **إضافة طالب**:
   - اضغط على **"إضافة طالب"**
   - أدخل:
     - **الرقم الجامعي**: رقم فريد
     - **الرقم الوطني**: اختياري
     - **الاسم الكامل (عربي)**: مطلوب
     - **الاسم الكامل (إنجليزي)**: اختياري
     - **البريد الإلكتروني**: اختياري
     - **الهاتف**: اختياري
     - **الكلية**: اختر الكلية
     - **التخصص**: بعد اختيار الكلية، ستظهر التخصصات
     - **تاريخ التسجيل**: افتراضي اليوم
   - اضغط **"إضافة"**

### رفع طلاب من ملف Excel/CSV

1. **إعداد الملف**:
   - استخدم ملف Excel أو CSV
   - الأعمدة المطلوبة:
     - `student_number` (الرقم الجامعي)
     - `full_name_ar` (الاسم بالعربي)
     - `full_name_en` (الاسم بالإنجليزي) - اختياري
     - `national_id` (الرقم الوطني) - اختياري
     - `email` (البريد) - اختياري
     - `phone` (الهاتف) - اختياري

2. **الرفع**:
   - من صفحة إدارة الطلاب → **"رفع طلاب من Excel"**
   - اختر الكلية والتخصص
   - اختر الملف
   - اضغط **"رفع"**

### تعديل أو حذف طالب

- اضغط على **"تعديل"** أو **"حذف"** بجانب الطالب
- ⚠️ **تحذير**: حذف طالب سيحذف جميع بياناته (الدرجات، التسجيلات، إلخ)

### حذف جميع الطلاب (Admin فقط)

- من صفحة إدارة الطلاب → **"حذف جميع الطلاب"**
- ⚠️ **تحذير خطير**: هذه العملية لا يمكن التراجع عنها
- يجب كتابة **"حذف جميع الطلاب"** للتأكيد

---

## 📋 نظام التسجيل

### التسجيل الشامل

1. **الوصول**: من الشاشة الرئيسية → **"📋 نظام التسجيل الشامل"**
2. **البحث والفلترة**:
   - استخدم الفلاتر للبحث عن الطلاب:
     - الكلية
     - التخصص
     - الفصل الدراسي
     - السنة الدراسية
   - أو استخدم البحث النصي (الرقم الجامعي، الاسم، الرقم الوطني)

3. **عرض التفاصيل**:
   - اضغط على **"التفاصيل"** لعرض معلومات الطالب الكاملة
   - اضغط على **"الدرجات"** لعرض درجات الطالب

### تسجيل طالب في مواد فصل محدد

1. **الوصول**: من صفحة الفصول → **"التسجيل"** أو من صفحة الطالب
2. **اختيار الفصل**: اختر الفصل الدراسي
3. **اختيار المواد**: حدد المواد المراد التسجيل فيها
4. **حفظ**: اضغط **"تسجيل"**

### تسجيل طلاب متعددين في مادة واحدة

1. **الوصول**: من صفحة المواد → اختر المادة → **"تسجيل طلاب"**
2. **اختيار الطلاب**: حدد الطلاب المراد تسجيلهم
3. **حفظ**: اضغط **"تسجيل"**

---

## ✏️ إدخال الدرجات

### إدخال الدرجات (الطريقة الأساسية)

1. **الوصول**: من الشاشة الرئيسية → **"✏️ إدخال الدرجات"**
2. **اختيار الفصل والمادة**:
   - اختر الفصل الدراسي
   - اختر المادة
3. **إدخال الدرجات**:
   - أدخل الدرجة لكل طالب (رقم من 0-100)
   - أو أدخل حالة نصية (غياب، غش، بديل)
   - سيتم حساب التقدير الحرفي والنقاط تلقائياً
4. **حفظ**: اضغط **"حفظ جميع الدرجات"**

### إدخال الدرجات (مبسط)

1. **الوصول**: من الشاشة الرئيسية → **"⚡ إدخال الدرجات (مبسط)"**
2. **اختيار الفصل والمادة**
3. **إدخال الدرجات**: نفس الطريقة السابقة ولكن بواجهة مبسطة

### تعديل درجات حسب التخصص والفصل

1. **الوصول**: من الشاشة الرئيسية → **"📝 تعديل درجات الطلاب حسب التخصص والفصل"**
2. **اختيار التخصص والفصل**
3. **تعديل الدرجات**: يمكنك تعديل درجات جميع المواد في الفصل

### رفع الدرجات من Excel

1. **إعداد الملف**:
   - استخدم ملف Excel أو CSV
   - الأعمدة المطلوبة:
     - `student_number` (الرقم الجامعي)
     - `marks` (الدرجة)
     - أو `letter_grade` (التقدير الحرفي)

2. **الرفع**:
   - من الشاشة الرئيسية → **"📤 رفع الدرجات من Excel"**
   - اختر الفصل والمادة
   - اختر الملف
   - اضغط **"رفع"**

### نظام الدرجات

#### التقديرات الحرفية والنقاط:

- **A** (80-100): 4.0 نقاط
- **B** (70-79): 3.0 نقاط
- **C** (60-69): 2.0 نقاط
- **D** (50-59): 1.0 نقطة
- **F** (أقل من 50): 0.0 نقطة

💡 **ملاحظة**: النظام يستخدم فقط التقديرات A, B, C, D, F بدون علامات + (مثل B+ أو C+). أي تقديرات قديمة تحتوي على علامات + سيتم تنظيفها تلقائياً عند العرض.

#### الحالات النصية:

- **غياب**: 0.0 نقطة
- **غش**: 0.0 نقطة
- **بديل**: لا تُحسب في المعدل

---

## 📊 حساب المعدلات

### المعدل الفصلي (GPA)

- **يُحسب تلقائياً** عند إدخال أو تعديل الدرجات
- **الصيغة**: 
  ```
  المعدل الفصلي = مجموع (الدرجة/20 × الساعات المعتمدة) / مجموع الساعات المعتمدة
  ```
- **المعدل من 5** (ليس من 4)
- **يُحفظ في جدول**: `semester_gpas`

### المعدل التراكمي (CGPA)

- **يُحسب تلقائياً** لجميع الفصول الدراسية
- **الصيغة**: نفس صيغة المعدل الفصلي ولكن لجميع الفصول
  ```
  المعدل التراكمي = مجموع (الدرجة/20 × الساعات المعتمدة) / مجموع الساعات المعتمدة
  ```
- **المعدل من 5** (ليس من 4)
- **يُحفظ في جدول**: `cumulative_gpas`

### التحديث التلقائي

- يتم تحديث المعدلات تلقائياً عند:
  - إدخال درجات جديدة
  - تعديل درجات موجودة
  - حذف درجات

---

## 📈 استخراج النتائج

### النتائج الفصلية

1. **الوصول**: من الشاشة الرئيسية → **"📊 استخراج النتائج"**
2. **اختيار الفصل**:
   - اختر الكلية
   - اختر التخصص
   - اختر الفصل الدراسي
   - اختر السنة الدراسية
3. **عرض النتائج**:
   - النتائج الأصلية
   - النتائج المعايرة (Thorndike)
   - يمكنك التبديل بينهما

### النتائج السنوية (فصلين دراسيين)

1. **الوصول**: من الشاشة الرئيسية → **"📅 النتائج السنوية (فصلين دراسيين)"**
2. **اختيار الفصلين**:
   - اختر الكلية والتخصص
   - اختر السنة الدراسية
   - سيتم عرض نتائج الفصلين معاً
3. **القرارات السنوية**:
   - **إعادة السنة**: إذا رسب في أكثر من 50% من الساعات
   - **ملاحق**: إذا رسب في 50% أو أقل من الساعات

### مناقشة الكلية

1. **الوصول**: من الشاشة الرئيسية → **"📋 مناقشة الكلية"**
2. **عرض النتائج**: عرض النتائج المعدة للمناقشة في الكلية

### طلاب الملاحق والبدائل حسب المواد

1. **الوصول**: من الشاشة الرئيسية → **"📝 طلاب الملاحق والبدائل حسب المواد"**
2. **عرض الطلاب**: عرض قائمة الطلاب الذين لديهم ملاحق أو بدائل

---

## 🌐 نشر النتائج

### نشر النتائج على الموقع

1. **الوصول**: من الشاشة الرئيسية → **"🌐 نشر النتائج على الموقع"**
2. **اختيار الفصل**:
   - اختر الكلية والتخصص
   - اختر الفصل الدراسي
3. **النشر**:
   - اضغط **"نشر النتائج"**
   - سيتم إنشاء رابط عام للنتائج
   - يمكن مشاركة الرابط مع الطلاب

### الوصول للنتائج المنشورة

- الطلاب يمكنهم الوصول للنتائج من:
  - الرابط العام المقدم
  - صفحة النتائج العامة: `public_results.php`

### إلغاء النشر

- يمكنك إلغاء نشر النتائج من نفس الصفحة

---

## 📜 نظام الشهادات

### أنواع الشهادات

1. **شهادة تفاصيل (Detailed Certificate)**
   - تحتوي على تفاصيل كاملة عن الطالب ودرجاته

2. **شهادة جامعية (University Certificate)**
   - شهادة رسمية من الجامعة

3. **كشف درجات (Transcript)**
   - كشف بجميع الدرجات والمعدلات

4. **شهادة قيد (Enrollment Certificate)**
   - شهادة تثبت قيد الطالب في الجامعة

5. **شهادة تخرج (Graduation Certificate)**
   - شهادة التخرج الرسمية

### طلب شهادة (للطلاب)

1. **الوصول**: من الشاشة الرئيسية → **"📜 طلب شهادة"**
2. **اختيار نوع الشهادة**
3. **إرسال الطلب**:
   - سيتم التحقق من سداد الرسوم تلقائياً
   - إذا كانت الرسوم غير مسددة، سيتم رفض الطلب

### الموافقة على طلبات الشهادات

1. **الوصول**: من الشاشة الرئيسية → **"📜 طلبات الشهادات"**
2. **عرض الطلبات**:
   - طلبات معلقة
   - طلبات موافق عليها
   - طلبات مرفوضة
   - شهادات صادرة
3. **الموافقة والإصدار**:
   - اضغط **"موافقة"** للموافقة على الطلب
   - اضغط **"إصدار"** لإصدار الشهادة (PDF)
   - يمكنك رفض الطلب مع إضافة سبب الرفض

### إدارة أسماء المسؤولين للشهادات

1. **الوصول**: من الشاشة الرئيسية → **"✍️ إدارة أسماء المسؤولين للشهادات"**
2. **إضافة/تعديل الأسماء**:
   - اسم عميد الكلية
   - اسم رئيس الجامعة
   - إلخ

---

## 💰 إدارة الرسوم

### إضافة رسوم لطالب

1. **الوصول**: من الشاشة الرئيسية → **"💰 إدارة الرسوم"**
2. **اختيار الطالب**
3. **إضافة رسوم**:
   - نوع الرسوم
   - المبلغ
   - الفصل الدراسي
   - تاريخ الاستحقاق
4. **حفظ**: اضغط **"إضافة"**

### تسجيل دفعة

1. **من صفحة الرسوم**: اضغط **"تسجيل دفعة"** بجانب الرسوم
2. **إدخال البيانات**:
   - المبلغ المدفوع
   - تاريخ الدفع
   - طريقة الدفع
3. **حفظ**: اضغط **"حفظ"**

### التحقق من سداد الرسوم

- يتم التحقق تلقائياً عند:
  - طلب شهادة
  - إصدار شهادة
- إذا كانت الرسوم غير مسددة، سيتم رفض الطلب

---

## 📊 التقارير والإحصائيات

### تقرير المعدلات التراكمية

1. **الوصول**: من الشاشة الرئيسية → **"📊 تقرير المعدلات التراكمية"**
2. **الفلترة**:
   - حسب الكلية
   - حسب التخصص
   - حسب المعدل (ممتاز، جيد جداً، إلخ)
3. **التصدير**: يمكن تصدير التقرير إلى Excel

### تقارير النتائج الإحصائية

1. **الوصول**: من الشاشة الرئيسية → **"📈 تقارير النتائج الإحصائية"**
2. **الإحصائيات المتاحة**:
   - عدد الطلاب حسب التقدير (ممتاز، جيد جداً، إلخ)
   - عدد الطلاب الراسبين
   - عدد الطلاب الناجحين
   - عدد الطلاب الغائبين
   - عدد حالات الغش
   - إلخ
3. **الفلترة**: حسب الكلية، التخصص، الفصل، السنة

---

## 👤 إدارة المستخدمين

### إضافة مستخدم جديد

1. **الوصول**: من الشاشة الرئيسية → **"👤 إدارة المستخدمين"** (Admin فقط)
2. **إضافة مستخدم**:
   - اضغط **"إضافة مستخدم"**
   - أدخل:
     - **اسم المستخدم**: مطلوب
     - **كلمة المرور**: مطلوب
     - **الدور**: Admin, College Admin, Registrar, Instructor, Student
     - **الكلية**: إذا كان الدور مرتبط بكلية
     - **الاسم الكامل**: مطلوب
     - **البريد الإلكتروني**: اختياري
   - اضغط **"إضافة"**

### تعديل أو حذف مستخدم

- اضغط **"تعديل"** أو **"حذف"** بجانب المستخدم
- ⚠️ **تحذير**: حذف مستخدم سيحذف جميع بياناته المرتبطة

### إعادة تعيين كلمة المرور

- من صفحة إدارة المستخدمين → **"إعادة تعيين كلمة المرور"**
- سيتم إنشاء كلمة مرور جديدة تلقائياً

---

## 💾 النسخ الاحتياطي

### إنشاء نسخة احتياطية

1. **الوصول**: من الشاشة الرئيسية → **"💾 النسخ الاحتياطي"** (Admin فقط)
2. **إنشاء النسخة**:
   - اضغط **"إنشاء نسخة احتياطية"**
   - سيتم إنشاء ملف SQL يحتوي على جميع البيانات
   - يمكنك تحميل الملف

### استعادة نسخة احتياطية

1. **الوصول**: من الشاشة الرئيسية → **"📤 رفع قاعدة البيانات"** (Admin فقط)
2. **رفع الملف**:
   - اختر ملف SQL
   - اضغط **"رفع"**
   - ⚠️ **تحذير**: هذه العملية ستحذف جميع البيانات الحالية

---

## 🔧 حل المشاكل الشائعة

### المشكلة: لا يمكن تسجيل الدخول

**الحلول**:
1. تأكد من صحة اسم المستخدم وكلمة المرور
2. تأكد من أن الحساب نشط
3. جرب إعادة تعيين كلمة المرور
4. تحقق من اتصال قاعدة البيانات

### المشكلة: لا تظهر البيانات

**الحلول**:
1. تحقق من الصلاحيات الخاصة بحسابك
2. تحقق من أن البيانات موجودة في قاعدة البيانات
3. تحقق من الفلاتر المطبقة
4. تأكد من أنك في الكلية الصحيحة

### المشكلة: لا يتم حساب المعدلات

**الحلول**:
1. تأكد من إدخال جميع الدرجات
2. تأكد من أن الساعات المعتمدة محددة للمواد
3. تحقق من أن الدرجات صحيحة (رقمية أو نصية صحيحة)
4. جرب إعادة حساب المعدلات يدوياً

### المشكلة: لا يمكن إصدار شهادة

**الحلول**:
1. تحقق من سداد الرسوم
2. تأكد من اكتمال بيانات الطالب
3. تحقق من وجود المعدل التراكمي
4. تأكد من أن الطلب موافق عليه

### المشكلة: خطأ في رفع الملفات

**الحلول**:
1. تحقق من صيغة الملف (Excel, CSV)
2. تأكد من أن الأعمدة صحيحة
3. تحقق من حجم الملف (يجب أن يكون أقل من الحد المسموح)
4. تأكد من صلاحيات الكتابة على مجلد uploads

---

## 📞 الدعم والمساعدة

### الأدلة المتاحة

1. **دليل إضافة الطلاب والتسجيل**: `view_guide.php?file=دليل_إضافة_الطلاب_والتسجيل.md`
2. **دليل إدارة الفصول وإضافة المواد**: `view_guide.php?file=دليل_إدارة_الفصول_وإضافة_المواد.md`
3. **دليل نشر النتائج**: `view_guide.php?file=دليل_نشر_النتائج.md`

### الصفحات المساعدة

- **مساعدة إدخال الدرجات**: `help_enter_grades.php`
- **صفحة المساعدة**: من القائمة الرئيسية

---

## ✅ قائمة التحقق السريعة

### للمدير العام (Admin)

- [ ] إعداد الكليات والتخصصات
- [ ] إنشاء الفصول الدراسية
- [ ] إضافة المواد الدراسية
- [ ] إضافة المستخدمين
- [ ] إعداد نظام الشهادات
- [ ] إعداد النسخ الاحتياطي

### لمدير الكلية (College Admin)

- [ ] إدارة التخصصات في كليته
- [ ] إنشاء الفصول الدراسية
- [ ] إضافة المواد الدراسية
- [ ] إدارة الطلاب
- [ ] الموافقة على طلبات الشهادات

### للمسجل (Registrar)

- [ ] إضافة الطلاب
- [ ] تسجيل الطلاب في المواد
- [ ] إدخال الدرجات
- [ ] استخراج النتائج
- [ ] إصدار الشهادات

### للأستاذ (Instructor)

- [ ] عرض قوائم الطلاب
- [ ] إدخال الدرجات
- [ ] تعديل الدرجات

### للطالب (Student)

- [ ] عرض الدرجات والمعدلات
- [ ] طلب الشهادات
- [ ] عرض الشهادات الصادرة

---

## 🔐 الأمان

### أفضل الممارسات

1. **كلمات المرور**:
   - استخدم كلمات مرور قوية
   - غيّر كلمة المرور الافتراضية فوراً
   - لا تشارك كلمات المرور

2. **الصلاحيات**:
   - أعط كل مستخدم الصلاحيات المناسبة فقط
   - لا تعطِ صلاحيات Admin إلا للمستخدمين الموثوقين

3. **النسخ الاحتياطي**:
   - قم بإنشاء نسخ احتياطية بانتظام
   - احفظ النسخ في مكان آمن

4. **التحديثات**:
   - حافظ على تحديث النظام
   - راقب سجل الأنشطة بانتظام

---

## 📝 ملاحظات مهمة

1. **البيانات الحساسة**: جميع البيانات محمية ومشفرة
2. **العزل**: كل كلية لا ترى بيانات الكليات الأخرى
3. **التحديث التلقائي**: المعدلات تُحسب تلقائياً
4. **التحقق**: يتم التحقق من صحة البيانات تلقائياً
5. **السجل**: جميع الأنشطة تُسجل في سجل الأنشطة

---

**تم إعداد هذا الدليل بواسطة نظام إدارة نتائج جامعة الشرق للعلوم والتكنولوجيا: Alsharg University of Science and Technology**

**آخر تحديث: 2025**

**الإصدار: 1.0**

---

## 📚 روابط سريعة

- [دليل إضافة الطلاب والتسجيل](view_guide.php?file=دليل_إضافة_الطلاب_والتسجيل.md)
- [دليل إدارة الفصول وإضافة المواد](view_guide.php?file=دليل_إدارة_الفصول_وإضافة_المواد.md)
- [دليل نشر النتائج](view_guide.php?file=دليل_نشر_النتائج.md)

