# 📅 دليل شامل: إدارة الفصول الدراسية وإضافة المواد

## 🎯 نظرة عامة

هذا الدليل يشرح بالتفصيل كيفية إدارة الفصول الدراسية وإضافة المواد الدراسية على الفصول في نظام إدارة نتائج جامعة الشرق للعلوم والتكنولوجيا: Alsharg University of Science and Technology.

---

## 📋 الجزء الأول: إدارة الفصول الدراسية

### المتطلبات الأساسية

قبل إنشاء الفصول الدراسية، يجب التأكد من وجود:
- ✅ الكليات (Colleges)
- ✅ التخصصات (Majors) مرتبطة بالكليات

---

### الطريقة الأولى: إضافة فصل دراسي يدوياً

#### الخطوات:

1. **الوصول إلى صفحة إدارة الفصول**
   - من الشاشة الرئيسية (Dashboard)، اضغط على **"📚 إدارة التخصصات"**
   - أو انتقل مباشرة إلى: `majors.php`
   - اختر التخصص الذي تريد إضافة فصل دراسي له
   - اضغط على زر **"الفصول الدراسية"** بجانب التخصص

2. **فتح نموذج الإضافة**
   - في صفحة إدارة الفصول (`semesters.php`)، اضغط على زر **"إضافة فصل"** في أعلى الصفحة

3. **ملء بيانات الفصل الدراسي**
   - **رقم الفصل**: رقم الفصل الدراسي (من 1 إلى العدد الإجمالي للفصول في التخصص)
     - مثال: للفصل الأول = 1، للفصل الثاني = 2، وهكذا
   - **السنة الدراسية**: العام الدراسي بصيغة (YYYY-YYYY)
     - مثال: `2024-2025` أو `2025-2026`
   - **تاريخ البدء**: تاريخ بداية الفصل الدراسي (اختياري)
   - **تاريخ الانتهاء**: تاريخ نهاية الفصل الدراسي (اختياري)

4. **حفظ البيانات**
   - اضغط على زر **"إضافة"** لحفظ الفصل الدراسي
   - ستظهر رسالة نجاح عند إضافة الفصل بنجاح

#### مثال عملي:

```
رقم الفصل: 1
السنة الدراسية: 2024-2025
تاريخ البدء: 2024-09-01
تاريخ الانتهاء: 2025-01-15
```

---

### الطريقة الثانية: إنشاء فصل دراسي جديد تلقائياً

هذه الطريقة تتيح إنشاء فصل دراسي جديد تلقائياً من الطلاب الناجحين والعائدين من الفصل السابق.

#### الخطوات:

1. **الوصول إلى صفحة إنشاء الفصل التلقائي**
   - من صفحة إدارة الفصول (`semesters.php`)، اضغط على زر **"🔄 إنشاء فصل جديد تلقائياً"**
   - أو انتقل مباشرة إلى: `create_next_semester.php`

2. **اختيار الفصل السابق**
   - اختر **الكلية** من القائمة المنسدلة
   - اختر **التخصص** من القائمة المنسدلة (ستظهر التخصصات الخاصة بالكلية المختارة)
   - اختر **الفصل الدراسي السابق** الذي تريد إنشاء فصل جديد بعده

3. **تحديد بيانات الفصل الجديد**
   - **رقم الفصل الجديد**: رقم الفصل الدراسي الجديد
   - **السنة الدراسية الجديدة**: العام الدراسي الجديد
   - **تاريخ البدء**: تاريخ بداية الفصل الجديد (اختياري)
   - **تاريخ الانتهاء**: تاريخ نهاية الفصل الجديد (اختياري)

4. **إنشاء الفصل وتسجيل الطلاب**
   - اضغط على زر **"إنشاء الفصل وتسجيل الطلاب"**
   - سيتم:
     - إنشاء الفصل الدراسي الجديد
     - جلب الطلاب الناجحين من الفصل السابق
     - جلب الطلاب العائدين من العام السابق (نفس رقم الفصل)
     - نسخ المواد من الفصل السابق إلى الفصل الجديد
     - تسجيل الطلاب تلقائياً في المواد الجديدة

#### ملاحظات مهمة:

- ✅ يتم اعتبار الطالب ناجحاً إذا رسب في أقل من ثلثي الساعات المعتمدة
- ✅ يتم نسخ المواد من الفصل السابق إلى الفصل الجديد تلقائياً
- ✅ يتم تسجيل الطلاب الناجحين والعائدين تلقائياً في المواد الجديدة
- ⚠️ إذا كان الفصل الجديد موجوداً مسبقاً، سيتم عرض تحذير ولن يتم إنشاء فصل مكرر

---

### عرض وإدارة الفصول الدراسية

#### عرض قائمة الفصول:

في صفحة `semesters.php`، ستجد جدولاً يحتوي على:
- **رقم الفصل**: رقم الفصل الدراسي
- **السنة الدراسية**: العام الدراسي
- **تاريخ البدء**: تاريخ بداية الفصل
- **تاريخ الانتهاء**: تاريخ نهاية الفصل
- **الحالة**: نشط أو غير نشط
- **الإجراءات**: أزرار للوصول إلى:
  - **المواد**: عرض وإدارة مواد الفصل
  - **الدرجات**: إدخال درجات الطلاب
  - **النتائج**: عرض نتائج الفصل

---

## 📚 الجزء الثاني: إضافة المواد الدراسية على الفصول

### المتطلبات الأساسية

قبل إضافة المواد، يجب التأكد من وجود:
- ✅ الكليات (Colleges)
- ✅ التخصصات (Majors) مرتبطة بالكليات
- ✅ الفصول الدراسية (Semesters) مرتبطة بالتخصصات

---

### الطريقة الأولى: إضافة مادة جديدة على فصل دراسي محدد

#### الخطوات:

1. **الوصول إلى صفحة إدارة المواد**
   - من صفحة إدارة الفصول (`semesters.php`)، اضغط على زر **"المواد"** بجانب الفصل الدراسي المطلوب
   - أو انتقل مباشرة إلى: `courses.php?semester_id=XXX` (حيث XXX هو رقم الفصل)

2. **فتح نموذج الإضافة**
   - في صفحة إدارة المواد، اضغط على زر **"إضافة مادة"** في أعلى الصفحة

3. **ملء بيانات المادة**
   - **رمز المادة**: رمز فريد للمادة (مطلوب)
     - مثال: `CS101`، `MATH201`، `ENG101`
   - **اسم المادة (عربي)**: اسم المادة بالعربية (مطلوب)
   - **اسم المادة (إنجليزي)**: اسم المادة بالإنجليزية (اختياري)
   - **الساعات المعتمدة**: عدد الساعات المعتمدة للمادة (مطلوب)
     - مثال: 3، 4، 2
   - **الفصل الدراسي**: اختر الفصل الدراسي من القائمة المنسدلة
     - يمكنك اختيار فصل محدد أو تركها "جميع الفصول"
   - **مادة إجبارية**: حدد إذا كانت المادة إجبارية أم اختيارية

4. **حفظ البيانات**
   - اضغط على زر **"إضافة"** لحفظ المادة
   - ستظهر رسالة نجاح عند إضافة المادة بنجاح

#### مثال عملي:

```
رمز المادة: CS101
اسم المادة (عربي): مقدمة في علوم الحاسوب
اسم المادة (إنجليزي): Introduction to Computer Science
الساعات المعتمدة: 3
الفصل الدراسي: فصل 1 - 2024-2025
مادة إجبارية: ✓
```

---

### الطريقة الثانية: إضافة مادة عامة (غير مرتبطة بفصل محدد)

يمكنك إضافة مادة عامة للتخصص دون ربطها بفصل دراسي محدد، ثم ربطها لاحقاً بالفصول المناسبة.

#### الخطوات:

1. **الوصول إلى صفحة إدارة المواد**
   - من صفحة إدارة التخصصات (`majors.php`)، اختر التخصص
   - اضغط على زر **"المواد"** بجانب التخصص
   - أو انتقل مباشرة إلى: `courses.php?major_id=XXX` (حيث XXX هو رقم التخصص)

2. **إضافة المادة**
   - اتبع نفس الخطوات السابقة
   - في حقل **"الفصل الدراسي"**، اختر **"جميع الفصول"** أو اتركه فارغاً

3. **ربط المادة بفصل دراسي لاحقاً**
   - يمكنك تعديل المادة لاحقاً وربطها بفصل دراسي محدد

---

### تعديل مادة موجودة

#### الخطوات:

1. **العثور على المادة**
   - في صفحة إدارة المواد، ابحث عن المادة في الجدول

2. **فتح نموذج التعديل**
   - اضغط على زر **"تعديل"** بجانب المادة

3. **تعديل البيانات**
   - يمكنك تعديل:
     - رمز المادة
     - اسم المادة (عربي/إنجليزي)
     - الساعات المعتمدة
     - الفصل الدراسي (ربطها بفصل أو إلغاء الربط)
     - حالة المادة (إجبارية/اختيارية)

4. **حفظ التعديلات**
   - اضغط على زر **"حفظ"** لحفظ التعديلات

---

### حذف مادة

#### تحذير مهم:

⚠️ **قبل حذف مادة، تأكد من:**
- عدم وجود طلاب مسجلين في هذه المادة
- عدم وجود درجات مرتبطة بهذه المادة
- أنك متأكد تماماً من الحذف (لا يمكن التراجع)

#### الخطوات:

1. **العثور على المادة**
   - في صفحة إدارة المواد، ابحث عن المادة في الجدول

2. **حذف المادة**
   - اضغط على زر **"حذف"** بجانب المادة
   - سيتم طلب التأكيد قبل الحذف

---

## 🔄 سير العمل الكامل: من إنشاء الفصل إلى إضافة المواد

### السيناريو الكامل:

1. **إنشاء الفصل الدراسي**
   ```
   الكلية → التخصص → إدارة الفصول → إضافة فصل جديد
   ```

2. **إضافة المواد على الفصل**
   ```
   الفصل الدراسي → المواد → إضافة مادة جديدة
   ```

3. **تسجيل الطلاب على المواد**
   ```
   الفصل الدراسي → التسجيل → تسجيل الطلاب
   ```

---

## 📊 عرض المواد حسب الفصل الدراسي

### الفلترة والبحث:

في صفحة `courses.php`، يمكنك:

1. **الفلترة حسب الكلية**
   - اختر الكلية من القائمة المنسدلة

2. **الفلترة حسب التخصص**
   - بعد اختيار الكلية، ستظهر قائمة التخصصات الخاصة بتلك الكلية

3. **الفلترة حسب الفصل الدراسي**
   - بعد اختيار التخصص، ستظهر قائمة الفصول الدراسية

4. **الفلترة حسب السنة الدراسية**
   - اختر السنة الدراسية من القائمة المنسدلة

5. **البحث النصي**
   - استخدم مربع البحث للبحث عن مادة بالاسم أو الرمز

---

## 💡 نصائح وإرشادات مهمة

### أفضل الممارسات:

1. **تسمية الفصول الدراسية**
   - استخدم تنسيق موحد للسنوات الدراسية: `YYYY-YYYY`
   - مثال: `2024-2025`، `2025-2026`

2. **ترقيم الفصول**
   - تأكد من أن رقم الفصل يطابق رقم الفصل في الخطة الدراسية
   - مثال: الفصل الأول = 1، الفصل الثاني = 2

3. **تسمية المواد**
   - استخدم رموز واضحة ومنطقية للمواد
   - مثال: `CS101` (Computer Science 101)، `MATH201` (Mathematics 201)

4. **الساعات المعتمدة**
   - تأكد من أن الساعات المعتمدة صحيحة ومطابقة للخطة الدراسية

5. **المواد الإجبارية والاختيارية**
   - حدد المواد الإجبارية بشكل صحيح
   - المواد الاختيارية يمكن للطلاب اختيارها

---

## 🚨 حل المشاكل الشائعة

### المشكلة 1: لا يمكن إضافة فصل دراسي

**الحل:**
- تأكد من أن رقم الفصل لا يتجاوز العدد الإجمالي للفصول في التخصص
- تأكد من أن السنة الدراسية بصيغة صحيحة: `YYYY-YYYY`
- تأكد من عدم وجود فصل بنفس الرقم والسنة الدراسية مسبقاً

### المشكلة 2: لا تظهر المواد في الفصل

**الحل:**
- تأكد من ربط المادة بالفصل الدراسي الصحيح
- استخدم الفلترة في صفحة المواد للبحث عن المواد المرتبطة بفصل محدد

### المشكلة 3: لا يمكن حذف مادة

**الحل:**
- تأكد من عدم وجود طلاب مسجلين في هذه المادة
- تأكد من عدم وجود درجات مرتبطة بهذه المادة
- إذا كانت المادة مرتبطة ببيانات، يجب حذف البيانات المرتبطة أولاً

---

## 📞 الدعم والمساعدة

إذا واجهت أي مشاكل أو لديك أسئلة:

1. راجع هذا الدليل مرة أخرى
2. تحقق من الصلاحيات الخاصة بحسابك
3. تأكد من اكتمال البيانات الأساسية (الكليات، التخصصات)

---

## ✅ قائمة التحقق السريعة

### قبل إضافة فصل دراسي:
- [ ] الكلية موجودة
- [ ] التخصص موجود ومرتبط بالكلية
- [ ] العدد الإجمالي للفصول في التخصص محدد

### قبل إضافة مادة:
- [ ] التخصص موجود
- [ ] الفصل الدراسي موجود (إذا كنت تريد ربط المادة بفصل محدد)
- [ ] رمز المادة فريد وغير مستخدم مسبقاً

### بعد إضافة الفصل والمواد:
- [ ] تم إنشاء الفصل الدراسي بنجاح
- [ ] تم إضافة المواد على الفصل
- [ ] يمكنك الوصول إلى صفحة المواد من صفحة الفصول
- [ ] يمكنك تسجيل الطلاب على المواد

---

**تم إعداد هذا الدليل بواسطة نظام إدارة نتائج جامعة الشرق للعلوم والتكنولوجيا: Alsharg University of Science and Technology**

**آخر تحديث: 2025**

