# 📚 دليل شامل: إضافة الطلاب وتسجيلهم على المواد

## 🎯 نظرة عامة

هذا الدليل يشرح بالتفصيل كيفية إضافة الطلاب في الكليات والتخصصات، ثم تسجيلهم على المواد حسب الفصول الدراسية في نظام إدارة نتائج جامعة الشرق للعلوم والتكنولوجيا: Alsharg University of Science and Technology.

---

## 📋 الجزء الأول: إضافة الطلاب في الكليات والتخصصات

### المتطلبات الأساسية

قبل إضافة الطلاب، يجب التأكد من وجود:
- ✅ الكليات (Colleges)
- ✅ التخصصات (Majors) مرتبطة بالكليات
- ✅ الفصول الدراسية (Semesters) مرتبطة بالتخصصات

---

### الطريقة الأولى: إضافة طالب واحد يدوياً

#### الخطوات:

1. **الوصول إلى صفحة إدارة الطلاب**
   - من الشاشة الرئيسية (Dashboard)، اضغط على **"👥 إدارة الطلاب"**
   - أو انتقل مباشرة إلى: `students.php`

2. **فتح نموذج الإضافة**
   - اضغط على زر **"إضافة طالب"** في أعلى الصفحة

3. **ملء بيانات الطالب**
   - **الرقم الجامعي**: رقم فريد للطالب (مطلوب)
   - **الرقم الوطني**: الرقم الوطني للطالب (اختياري)
   - **الاسم الكامل (عربي)**: الاسم الكامل بالعربية (مطلوب)
   - **الاسم الكامل (إنجليزي)**: الاسم الكامل بالإنجليزية (اختياري)
   - **البريد الإلكتروني**: بريد الطالب (اختياري)
   - **الهاتف**: رقم الهاتف (اختياري)

4. **اختيار الكلية والتخصص**
   - **للإداريين (Admin)**: 
     - اختر **الكلية** من القائمة المنسدلة
     - بعد اختيار الكلية، ستظهر قائمة **التخصصات** الخاصة بتلك الكلية فقط
     - اختر **التخصص** المناسب
   - **لمديري الكليات**: الكلية محددة تلقائياً، اختر التخصص فقط

5. **تاريخ التسجيل**
   - اختر تاريخ تسجيل الطالب (افتراضي: اليوم)

6. **حفظ البيانات**
   - اضغط على زر **"إضافة"** لحفظ الطالب
   - سيتم إنشاء حساب مستخدم تلقائياً للطالب

---

### الطريقة الثانية: إضافة طلاب متعددين من ملف Excel/CSV

#### الخطوات:

1. **الوصول إلى صفحة إدارة الطلاب**
   - من الشاشة الرئيسية، اضغط على **"👥 إدارة الطلاب"**

2. **فتح نموذج رفع الملف**
   - اضغط على زر **"رفع طلاب من Excel"**

3. **اختيار الكلية والتخصص**
   - **للإداريين**: اختر الكلية أولاً، ثم التخصص
   - **لمديري الكليات**: الكلية محددة تلقائياً، اختر التخصص
   - **ملاحظة**: التخصص اختياري - سيتم استخدامه إذا لم يكن موجوداً في الملف

4. **إعداد ملف Excel/CSV**
   
   **الحقول المطلوبة:**
   - `student_number` أو `رقم_جامعي` - الرقم الجامعي (مطلوب)
   - `full_name_ar` أو `اسم_عربي` - الاسم الكامل بالعربية (مطلوب)
   
   **الحقول الاختيارية:**
   - `full_name_en` أو `اسم_إنجليزي` - الاسم بالإنجليزية
   - `national_id` أو `رقم_وطني` - الرقم الوطني
   - `email` أو `بريد` - البريد الإلكتروني
   - `phone` أو `هاتف` - رقم الهاتف
   - `major_code` أو `رمز_تخصص` - رمز التخصص (إذا كان مختلفاً عن المحدد في النموذج)
   - `major_id` - معرف التخصص مباشرة
   - `enrollment_date` أو `تاريخ_تسجيل` - تاريخ التسجيل

5. **مثال على ملف CSV:**
   ```csv
   student_number,full_name_ar,full_name_en,national_id,email,phone,major_code
   2021001,أحمد محمد علي,Ahmed Mohammed Ali,123456789012,ahmed@example.com,0501234567,CS001
   2021002,فاطمة أحمد حسن,Fatima Ahmed Hassan,234567890123,fatima@example.com,0502345678,CS001
   2021003,محمد خالد إبراهيم,Mohammed Khalid Ibrahim,345678901234,mohammed@example.com,0503456789,CS002
   ```

6. **رفع الملف**
   - اضغط على **"اختر ملف"** واختر ملف Excel (.xlsx, .xls) أو CSV
   - الحد الأقصى لحجم الملف: 10MB
   - اضغط على **"📤 رفع الملف وإضافة الطلاب"**

7. **مراجعة النتائج**
   - سيتم عرض عدد الطلاب المضافين بنجاح
   - عدد الطلاب المكررين (تم تخطيهم)
   - أي أخطاء في الإضافة

---

### ملاحظات مهمة:

- ✅ **الرقم الجامعي** يجب أن يكون فريداً - لا يمكن إضافة طالبين بنفس الرقم
- ✅ **الرقم الوطني** إذا تم إدخاله، يجب أن يكون فريداً أيضاً
- ✅ سيتم إنشاء **حساب مستخدم تلقائياً** للطالب:
  - اسم المستخدم: `STU` + الرقم الجامعي
  - كلمة المرور: الرقم الجامعي (يمكن تغييرها لاحقاً)
- ✅ الطلاب المكررون (بنفس الرقم الجامعي) سيتم تخطيهم تلقائياً

---

## 📚 الجزء الثاني: تسجيل الطلاب على المواد حسب الفصول

بعد إضافة الطلاب، يجب تسجيلهم على المواد الدراسية لكل فصل دراسي.

---

### الطريقة الأولى: تسجيل طالب واحد على مواد فصل معين

#### الخطوات:

1. **الوصول إلى صفحة إدارة الطلاب**
   - من الشاشة الرئيسية، اضغط على **"👥 إدارة الطلاب"**

2. **البحث عن الطالب**
   - استخدم مربع البحث للعثور على الطالب
   - يمكن البحث بالرقم الجامعي، الاسم، الرقم الوطني، أو البريد الإلكتروني

3. **فتح صفحة تفاصيل الطالب**
   - اضغط على زر **"التفاصيل"** بجانب اسم الطالب
   - أو انتقل إلى: `student_details.php?id=الرقم_الجامعي`

4. **اختيار الفصل الدراسي**
   - في صفحة التفاصيل، ستجد قائمة بالفصول الدراسية
   - اضغط على **"تسجيل مواد"** بجانب الفصل المطلوب
   - أو انتقل مباشرة إلى: `register_courses.php?student_id=ID&semester_id=ID`

5. **اختيار المواد**
   - ستظهر قائمة بجميع المواد المتاحة للطالب في هذا الفصل
   - المواد المسجلة مسبقاً ستظهر مع علامة ✓
   - حدد المواد التي تريد تسجيل الطالب عليها باستخدام مربعات الاختيار

6. **حفظ التسجيل**
   - اضغط على زر **"تسجيل المواد المحددة"**
   - سيتم تأكيد العملية قبل الحفظ

---

### الطريقة الثانية: تسجيل طلاب متعددين على مادة واحدة

#### الخطوات:

1. **الوصول إلى صفحة إدارة المواد**
   - من الشاشة الرئيسية، اضغط على **"📚 إدارة المواد"**
   - أو انتقل إلى: `courses.php`

2. **اختيار المادة والفصل**
   - استخدم الفلاتر لاختيار:
     - الكلية
     - التخصص
     - الفصل الدراسي
   - اضغط على **"تسجيل طلاب"** بجانب المادة المطلوبة
   - أو انتقل إلى: `register_students_to_course.php?course_id=ID&semester_id=ID`

3. **اختيار الطلاب**
   - ستظهر قائمة بجميع الطلاب المسجلين في نفس التخصص
   - الطلاب المسجلين مسبقاً ستظهر مع علامة ✓
   - حدد الطلاب الذين تريد تسجيلهم باستخدام مربعات الاختيار

4. **حفظ التسجيل**
   - اضغط على زر **"تسجيل الطلاب المحددين"**
   - سيتم تأكيد العملية قبل الحفظ

---

### الطريقة الثالثة: تسجيل طلاب متعددين من ملف Excel/CSV

#### الخطوات:

1. **الوصول إلى صفحة تسجيل الطلاب على مادة**
   - من صفحة إدارة المواد، اضغط على **"تسجيل طلاب"** بجانب المادة
   - أو انتقل إلى: `register_students_to_course.php?course_id=ID&semester_id=ID`

2. **إعداد ملف Excel/CSV**
   
   **الحقول المطلوبة:**
   - `student_number` أو `رقم_جامعي` - الرقم الجامعي (مطلوب)
   
   **مثال على ملف CSV:**
   ```csv
   student_number
   2021001
   2021002
   2021003
   ```

3. **رفع الملف**
   - في صفحة التسجيل، ستجد قسم **"رفع طلاب من Excel/CSV"**
   - اضغط على **"اختر ملف"** واختر ملف Excel أو CSV
   - اضغط على **"📤 رفع الملف وتسجيل الطلاب"**

4. **مراجعة النتائج**
   - سيتم عرض عدد الطلاب المسجلين بنجاح
   - عدد الطلاب المسجلين مسبقاً (تم تخطيهم)
   - أي أخطاء في التسجيل

---

### الطريقة الرابعة: استخدام نظام التسجيل الشامل

#### الخطوات:

1. **الوصول إلى نظام التسجيل الشامل**
   - من الشاشة الرئيسية، اضغط على **"📋 نظام التسجيل الشامل"**
   - أو انتقل إلى: `registration/index.php`

2. **البحث والتصفية**
   - استخدم الفلاتر للبحث عن الطلاب:
     - الكلية
     - التخصص
     - الفصل الدراسي
     - السنة الدراسية
   - أو استخدم مربع البحث للبحث بالرقم الجامعي أو الاسم

3. **عرض الطلاب**
   - ستظهر قائمة بجميع الطلاب المطابقة لمعايير البحث
   - يمكنك رؤية عدد المواد المسجلة لكل طالب

4. **التسجيل من صفحة التفاصيل**
   - اضغط على **"التفاصيل"** بجانب الطالب
   - ثم اتبع الخطوات في "الطريقة الأولى" أعلاه

---

## 🔄 إنشاء فصل دراسي جديد تلقائياً

### الخطوات:

1. **الوصول إلى صفحة إنشاء الفصل**
   - من الشاشة الرئيسية، اضغط على **"🔄 إنشاء فصل جديد تلقائياً"**
   - أو انتقل إلى: `create_next_semester.php`

2. **اختيار التخصص والفصل السابق**
   - اختر التخصص
   - اختر الفصل الدراسي السابق (مثلاً: فصل 1)
   - سيتم إنشاء الفصل التالي تلقائياً (مثلاً: فصل 2)

3. **اختيار الطلاب للتسجيل التلقائي**
   - يمكنك اختيار تسجيل جميع الطلاب النشطين تلقائياً في مواد الفصل الجديد
   - أو اختيار طلاب محددين

4. **إنشاء الفصل**
   - اضغط على زر **"إنشاء الفصل"**
   - سيتم إنشاء الفصل الجديد وتسجيل الطلاب تلقائياً

---

## ⚠️ ملاحظات مهمة

### عند إضافة الطلاب:
- ✅ تأكد من صحة البيانات قبل الحفظ
- ✅ الرقم الجامعي يجب أن يكون فريداً
- ✅ التخصص يجب أن يكون مرتبطاً بالكلية المختارة
- ✅ الطلاب المكررون سيتم تخطيهم تلقائياً

### عند تسجيل الطلاب على المواد:
- ✅ تأكد من أن الطالب مسجل في التخصص الصحيح
- ✅ تأكد من أن المادة مرتبطة بنفس التخصص
- ✅ لا يمكن تسجيل طالب على نفس المادة في نفس الفصل مرتين
- ✅ يمكن تسجيل طالب على نفس المادة في فصول مختلفة

### عند استخدام ملفات Excel/CSV:
- ✅ تأكد من صحة تنسيق الملف
- ✅ استخدم أسماء الأعمدة الصحيحة (عربي أو إنجليزي)
- ✅ تأكد من عدم وجود صفوف فارغة
- ✅ الحد الأقصى لحجم الملف: 10MB

---

## 📞 الدعم والمساعدة

إذا واجهت أي مشاكل أو لديك أسئلة:
- راجع هذا الدليل مرة أخرى
- تحقق من صحة البيانات المدخلة
- تأكد من وجود الكليات والتخصصات والفصول الدراسية قبل البدء

---

## 📝 ملخص سريع للخطوات

### إضافة طالب واحد:
1. إدارة الطلاب → إضافة طالب
2. ملء البيانات → اختيار الكلية → اختيار التخصص
3. حفظ

### إضافة طلاب متعددين:
1. إدارة الطلاب → رفع طلاب من Excel
2. اختيار الكلية والتخصص
3. رفع ملف Excel/CSV
4. مراجعة النتائج

### تسجيل طالب على مواد:
1. إدارة الطلاب → البحث عن الطالب → التفاصيل
2. اختيار الفصل → تسجيل مواد
3. اختيار المواد → حفظ

### تسجيل طلاب على مادة:
1. إدارة المواد → اختيار المادة → تسجيل طلاب
2. اختيار الطلاب → حفظ

---

**تم إعداد هذا الدليل بواسطة نظام إدارة نتائج جامعة الشرق للعلوم والتكنولوجيا: Alsharg University of Science and Technology**  
**آخر تحديث: 2024**

